/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.adonis.createfisheryindustry.block.FrameTrap.FrameTrapContext;
import com.adonis.createfisheryindustry.block.FrameTrap.FrameTrapFakePlayer;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class FrameTrapMovementBehaviour
implements MovementBehaviour {
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;
    private static final float WORN_HARPOON_CHANCE = 0.03f;

    public void tick(MovementContext context) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            FrameTrapContext fishing = this.getFishingNetContext(context, level2);
            if (fishing.timeUntilCatch > 0) {
                --fishing.timeUntilCatch;
            }
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            FrameTrapContext fishing = this.getFishingNetContext(context, level2);
            boolean inWater = fishing.visitNewPosition(level2, pos);
            this.killNearbyEntities(context, pos, level2);
            this.collectNearbyItems(context, pos, level2);
            if (!inWater || fishing.timeUntilCatch > 0) {
                return;
            }
            if (!CreateFisheryCommonConfig.isFishingEnabled()) {
                return;
            }
            if (fishing.canCatch()) {
                LootTable lootTable = fishing.getLootTable(level2);
                LootParams params = fishing.buildLootContext(context, level2, pos);
                ObjectArrayList loots = lootTable.m_287195_(params);
                if (fishing.getRandomSource().m_188501_() < 0.03f) {
                    ItemStack wornHarpoon = new ItemStack((ItemLike)CreateFisheryItems.WORN_HARPOON.get());
                    loots.add(wornHarpoon);
                }
                FrameTrapFakePlayer fakePlayer = new FrameTrapFakePlayer(level2);
                FishingHook fishingHook = new FishingHook((Player)fakePlayer, (Level)level2, 0, 0);
                ItemFishedEvent event = new ItemFishedEvent((List)loots, 0, fishingHook);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    loots.forEach(stack -> this.dropItem(context, (ItemStack)stack));
                    this.addExperienceNugget(context, level2, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                    this.spawnFishingParticles(level2, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                }
                fishing.reset(level2);
            }
        }
    }

    public void stopMoving(MovementContext context) {
        Object object = context.temporaryData;
        if (object instanceof FrameTrapContext) {
            FrameTrapContext fishing = (FrameTrapContext)object;
            object = context.world;
            if (object instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                fishing.invalidate(level);
            }
        }
    }

    protected FrameTrapContext getFishingNetContext(MovementContext context, ServerLevel level) {
        if (context.temporaryData == null || !(context.temporaryData instanceof FrameTrapContext)) {
            context.temporaryData = new FrameTrapContext(level, new ItemStack((ItemLike)Items.f_42523_));
        }
        return (FrameTrapContext)context.temporaryData;
    }

    protected void collectNearbyItems(MovementContext context, BlockPos pos, ServerLevel level) {
        AABB boundingBox = new AABB(pos).m_82400_(0.2);
        List items = level.m_45976_(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack = itemEntity.m_32055_();
            if (stack.m_41619_()) continue;
            this.dropItem(context, stack.m_41777_());
            itemEntity.m_146870_();
        }
    }

    protected void killNearbyEntities(MovementContext context, BlockPos pos, ServerLevel level) {
        AABB boundingBox = new AABB(pos).m_82400_(0.5);
        List entities = level.m_45976_(Entity.class, boundingBox);
        CreateFisheryCommonConfig.refreshCache();
        for (Entity entity : entities) {
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            EntityType entityType = entity.m_6095_();
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
            if (CreateFisheryCommonConfig.isEntityBlacklisted(entityId)) continue;
            if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
                this.processEntityDrops(context, level, mob);
                continue;
            }
            AABB collisionBox = entity.m_20191_();
            double width = collisionBox.m_82362_();
            double height = collisionBox.m_82376_();
            double depth = collisionBox.m_82385_();
            if (!(width <= 0.8) || !(height <= 0.8) || !(depth <= 0.8)) continue;
            this.processEntityDrops(context, level, mob);
        }
    }

    private void processEntityDrops(MovementContext context, ServerLevel level, Mob mob) {
        Player nearestPlayer;
        ResourceLocation lootTableKey = mob.m_5743_();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_());
        List players = level.m_7654_().m_6846_().m_11314_();
        if (!players.isEmpty() && (nearestPlayer = level.m_45930_((Entity)mob, -1.0)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)nearestPlayer;
            paramsBuilder.m_287286_(LootContextParams.f_81456_, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableKey);
        ObjectArrayList loots = lootTable.m_287195_(params);
        for (ItemStack stack : loots) {
            this.dropItem(context, stack);
        }
        mob.m_142687_(Entity.RemovalReason.KILLED);
        this.addExperienceNugget(context, level, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_());
        this.spawnEntityCaptureParticles(level, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_());
    }

    private void addExperienceNugget(MovementContext context, ServerLevel level, double x, double y, double z) {
        Item expNuggetItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create", "experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            this.dropItem(context, expNugget);
        } else {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, x, y, z, 1));
        }
    }

    private void spawnFishingParticles(ServerLevel level, double x, double y, double z) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 15, 0.5, 0.5, 0.5, 0.1);
        level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void spawnEntityCaptureParticles(ServerLevel level, double x, double y, double z) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 15, 0.5, 0.5, 0.5, 0.1);
        level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected boolean isEntityWhitelisted(EntityType<?> type) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(type);
        return CreateFisheryCommonConfig.isEntityWhitelisted(id);
    }

    protected boolean isEntityBlacklisted(EntityType<?> type) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(type);
        return CreateFisheryCommonConfig.isEntityBlacklisted(id);
    }
}

