/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.spreader;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.NozzleBlockEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.forsteri.ratatouille.entry.CRItems;
import org.jetbrains.annotations.NotNull;

public class SpreaderBlockEntity
extends KineticBlockEntity
implements IAirCurrentSource {
    public int timer = 1000;
    public ItemStackHandler inventory;
    public LazyOptional<IItemHandler> capability;
    public AirCurrent airCurrent = new AirCurrent((IAirCurrentSource)this);
    protected int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;

    public SpreaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler(1);
        this.capability = LazyOptional.of(() -> new SpreaderInventoryHandler());
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
        this.timer = compound.m_128451_("Timer");
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.timer);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
    }

    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
    }

    public Direction getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        return (speed = SpreaderBlockEntity.convertToDirection((float)speed, (Direction)facing)) > 0.0f ? facing : facing.m_122424_();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    public boolean isSourceRemoved() {
        return this.f_58859_;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        if (!direction.m_122434_().m_122478_()) {
            return;
        }
        BlockEntity poweredChute = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == Direction.DOWN) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public int getProcessingLevel() {
        int speed = this.getProcessingSpeed();
        if (1 <= speed && speed < 4) {
            return 2;
        }
        if (4 <= speed && speed < 8) {
            return 3;
        }
        if (8 <= speed && speed < 12) {
            return 4;
        }
        return 5;
    }

    public void addCorpBuffer(ArrayList<BlockPos> corps, BlockPos corpPos) {
        BonemealableBlock growable;
        Block block;
        BlockState corpState = this.f_58857_.m_8055_(corpPos);
        if (!(corpState.m_60734_() instanceof AirBlock) && !(corpState.m_60734_() instanceof GrassBlock) && !(corpState.m_60734_() instanceof TallGrassBlock) && (block = corpState.m_60734_()) instanceof BonemealableBlock && (growable = (BonemealableBlock)block).m_7370_((LevelReader)this.f_58857_, corpPos, corpState, false)) {
            corps.add(corpPos);
        }
    }

    public void tick() {
        block14: {
            ItemStack stack;
            ArrayList babyAnimals;
            ArrayList adultAnimals;
            block16: {
                int range;
                block15: {
                    boolean server;
                    super.tick();
                    boolean bl = server = !this.f_58857_.f_46443_ || this.isVirtual();
                    if (server && this.airCurrentUpdateCooldown-- <= 0) {
                        this.airCurrentUpdateCooldown = (Integer)AllConfigs.server().kinetics.fanBlockCheckRate.get();
                        this.updateAirFlow = true;
                    }
                    if (this.updateAirFlow) {
                        this.updateAirFlow = false;
                        this.airCurrent.rebuild();
                        this.sendData();
                    }
                    if (this.getSpeed() == 0.0f) {
                        return;
                    }
                    if (this.entitySearchCooldown-- <= 0) {
                        this.entitySearchCooldown = 5;
                        this.airCurrent.findEntities();
                    }
                    this.airCurrent.tick();
                    if (this.f_58857_.f_46443_ || this.inventory.getStackInSlot(0).m_41619_() || this.f_58857_.m_7654_() == null) break block14;
                    if (this.timer <= 0) break block15;
                    this.timer -= this.getProcessingSpeed();
                    break block14;
                }
                this.timer = 1000;
                ArrayList<BlockPos> corps = new ArrayList<BlockPos>();
                adultAnimals = new ArrayList();
                babyAnimals = new ArrayList();
                BlockPos facingPos = this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING));
                boolean hasNozzle = this.f_58857_.m_7702_(facingPos) instanceof NozzleBlockEntity;
                int n = range = hasNozzle ? (int)(this.getMaxDistance() / 2.0f) : (int)this.airCurrent.maxDistance;
                if (hasNozzle) {
                    BlockPos min = facingPos.m_7918_(-range, -range, -range);
                    BlockPos max = facingPos.m_7918_(range, range, range);
                    for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                        this.addCorpBuffer(corps, new BlockPos((Vec3i)pos));
                    }
                    aabb = new AABB(min, max);
                    this.f_58857_.m_45976_(Animal.class, aabb).forEach(animal -> {
                        if (!animal.m_6162_() && !animal.m_27593_()) {
                            adultAnimals.add(animal);
                        }
                        if (animal.m_6162_()) {
                            babyAnimals.add(animal);
                        }
                    });
                } else {
                    for (int i = 1; i < range; ++i) {
                        BlockPos corpPos = this.m_58899_().m_5484_(this.airCurrent.direction, i);
                        this.addCorpBuffer(corps, corpPos);
                        aabb = new AABB(corpPos).m_82400_(0.5);
                        this.f_58857_.m_45976_(Animal.class, aabb).forEach(animal -> {
                            if (!animal.m_6162_() && !animal.m_27593_()) {
                                adultAnimals.add(animal);
                            }
                            if (animal.m_6162_()) {
                                babyAnimals.add(animal);
                            }
                        });
                    }
                }
                stack = this.inventory.getStackInSlot(0);
                if (!stack.m_150930_((Item)CRItems.RIPEN_MATTER.get())) break block16;
                if (corps.isEmpty()) break block14;
                stack.m_41774_(1);
                for (int count = this.getProcessingLevel(); count > 0; --count) {
                    BonemealableBlock growable;
                    BlockPos corpPos = corps.get(this.f_58857_.f_46441_.m_216339_(0, corps.size()));
                    BlockState corpState = this.f_58857_.m_8055_(corpPos);
                    Block block = corpState.m_60734_();
                    if (!(block instanceof BonemealableBlock) || !(growable = (BonemealableBlock)block).m_7370_((LevelReader)this.f_58857_, corpPos, corpState, false) || !ForgeHooks.onCropsGrowPre((Level)this.f_58857_, (BlockPos)corpPos, (BlockState)corpState, (boolean)true)) continue;
                    growable.m_214148_(this.f_58857_.m_7654_().m_129783_(), this.f_58857_.f_46441_, corpPos, corpState);
                    this.f_58857_.m_46796_(2005, corpPos, 0);
                    ForgeHooks.onCropsGrowPost((Level)this.f_58857_, (BlockPos)corpPos, (BlockState)corpState);
                }
                break block14;
            }
            if (!(!stack.m_150930_((Item)CRItems.MATURE_MATTER.get()) || adultAnimals.isEmpty() && babyAnimals.isEmpty())) {
                stack.m_41774_(1);
                for (int count = this.getProcessingLevel(); count > 0; --count) {
                    Animal target;
                    boolean tryAdultFirst = this.f_58857_.f_46441_.m_188499_();
                    if (tryAdultFirst) {
                        if (!adultAnimals.isEmpty()) {
                            target = (Animal)adultAnimals.get(this.f_58857_.f_46441_.m_188503_(adultAnimals.size()));
                            if (target.m_27593_()) continue;
                            target.m_27595_(null);
                            continue;
                        }
                        if (babyAnimals.isEmpty()) continue;
                        target = (AgeableMob)babyAnimals.get(this.f_58857_.f_46441_.m_188503_(babyAnimals.size()));
                        target.m_146740_(Animal.m_216967_((int)(-target.m_146764_())), true);
                        continue;
                    }
                    if (!babyAnimals.isEmpty()) {
                        target = (AgeableMob)babyAnimals.get(this.f_58857_.f_46441_.m_188503_(babyAnimals.size()));
                        target.m_146740_(Animal.m_216967_((int)(-target.m_146764_())), true);
                        continue;
                    }
                    if (adultAnimals.isEmpty() || (target = (Animal)adultAnimals.get(this.f_58857_.f_46441_.m_188503_(adultAnimals.size()))).m_27593_()) continue;
                    target.m_27595_(null);
                }
            }
        }
    }

    public float calculateStressApplied() {
        return 2.0f;
    }

    public int getParticleColor() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_150930_((Item)CRItems.MATURE_MATTER.get())) {
            return 12924160;
        }
        if (stack.m_150930_((Item)CRItems.RIPEN_MATTER.get())) {
            return 10599777;
        }
        return 0xFFFFFF;
    }

    private class SpreaderInventoryHandler
    extends CombinedInvWrapper {
        public SpreaderInventoryHandler() {
            super(new IItemHandlerModifiable[]{SpreaderBlockEntity.this.inventory});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_150930_((Item)CRItems.RIPEN_MATTER.get()) || stack.m_150930_((Item)CRItems.MATURE_MATTER.get());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

