/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.compost_tower.CompostData;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.content.compost_tower.CompostItemHandler;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlock;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompostTowerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    protected LazyOptional<CompostTowerInventoryHandler> itemCapability = LazyOptional.empty();
    protected LazyOptional<CompostTowerFluidHandler> fluidCapability = LazyOptional.empty();
    private boolean updateConnectivity = true;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected CompostData compostData;
    protected CompostFluidTank tankInventory = new CompostFluidTank(FluidTankBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    public HashMap<Fluid, LerpedFloat> fluidLevels = new HashMap();
    public HashMap<Fluid, LerpedFloat> gasLevels = new HashMap();
    protected int height = 1;
    protected int radius = 1;

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        assert (this.f_58857_ != null);
        if (this.compostData.lastRecipe != null && this.compostData.lastRecipe.matches(inventoryIn, this.f_58857_)) {
            return true;
        }
        return CRRecipeTypes.COMPOSTING.find(inventoryIn, this.f_58857_).isPresent();
    }

    private int getTowerHeight() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return 1;
        }
        return be.height;
    }

    private int getOutputHeight() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return 0;
        }
        return this.m_58899_().m_123342_() - be.m_58899_().m_123342_();
    }

    public CompostTowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.compostData = new CompostData();
    }

    public int getTankSize(int tank) {
        return FluidTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(1);
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * FluidTankBlockEntity.getCapacityMultiplier());
        this.tankInventory.clearOverflow();
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluidInTank(tank);
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.radius - 1), (double)(this.height - 1), (double)(this.radius - 1));
        }
        return super.createRenderBoundingBox();
    }

    public void initialize() {
        super.initialize();
        this.notifyUpdate();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_)) {
            this.removeController(true);
            this.lastKnownPos = this.f_58858_;
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.isController()) {
            this.compostData.tick(this);
        }
        this.fluidLevels.values().forEach(LerpedFloat::tickChaser);
        this.gasLevels.values().forEach(LerpedFloat::tickChaser);
    }

    private void refreshCapability() {
        this.itemCapability.invalidate();
        this.fluidCapability.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    public CompostTowerBlockEntity getControllerBE() {
        assert (this.f_58857_ != null);
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof CompostTowerBlockEntity) {
            CompostTowerBlockEntity CompostTowerBlockEntity2 = (CompostTowerBlockEntity)blockEntity;
            return CompostTowerBlockEntity2;
        }
        return null;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void setController(BlockPos pos) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (pos.equals((Object)this.controller)) {
            return;
        }
        this.controller = pos;
        this.refreshCapability();
        this.notifyUpdate();
    }

    public void removeController(boolean keepContents) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.radius = 1;
        this.height = 1;
        this.refreshCapability();
        this.compostData.clear();
        this.tankInventory.onContentsChanged();
        this.notifyUpdate();
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void updateConnectivity() {
        assert (this.f_58857_ != null);
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void notifyMultiUpdated() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CompostTowerBlock.IS_2x2, (Comparable)Boolean.valueOf(this.getWidth() == 2)), 6);
        this.refreshCapability();
        this.tankInventory.onContentsChanged();
        this.updateCompostTowerState();
        if (this.isController()) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int yOffset = 0; yOffset < this.height; ++yOffset) {
                    for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                        BlockPos vaultPos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                        CompostTowerBlockEntity vaultAt = (CompostTowerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CRBlockEntityTypes.COMPOST_TOWER_BLOCK_ENTITY.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                        if (vaultAt == null || this == vaultAt) continue;
                        this.tankInventory.fillFrom(vaultAt.tankInventory);
                        vaultAt.tankInventory.clear();
                    }
                }
            }
        }
        this.notifyUpdate();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return 7;
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CompostTowerBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return controllerBE.compostData.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public void updateCompostTowerState() {
        if (!this.isController() && this.getControllerBE() != null) {
            this.getControllerBE().updateCompostTowerState();
            return;
        }
        if (this.compostData.evaluate(this)) {
            this.notifyUpdate();
        }
    }

    public void updateCompostData() {
        CompostTowerBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.compostData.updateRequired = 2;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        assert (this.f_58857_ != null);
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevHeight = this.height;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.deserializeNBT(compound.m_128469_("TankContent"));
            this.applyFluidTankSize(this.getTotalTankSize());
            for (Fluid fluid : this.tankInventory.getSortedFluids()) {
                HashMap<Fluid, LerpedFloat> targetLevel = fluid.getFluidType().isLighterThanAir() ? this.gasLevels : this.fluidLevels;
                LerpedFloat fluidLevel = targetLevel.get(fluid);
                if (fluidLevel == null) {
                    fluidLevel = LerpedFloat.linear().startWithValue((double)this.tankInventory.getFilledPercentage(fluid));
                    targetLevel.put(fluid, fluidLevel);
                }
                fluidLevel.chase((double)this.tankInventory.getFilledPercentage(fluid), 0.5, LerpedFloat.Chaser.EXP);
            }
        }
        this.compostData.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevHeight != this.height)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.applyFluidTankSize(this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public int getTotalTankSize() {
        return this.radius * this.radius * this.height;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Height", this.height);
            this.applyFluidTankSize(this.getTotalTankSize());
            compound.m_128365_("TankContent", (Tag)this.tankInventory.serializeNBT());
        }
        super.write(compound, clientPacket);
        this.compostData.write(compound, clientPacket);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        if (this.isFluidHandlerCap(cap)) {
            this.initCapability();
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        assert (this.f_58857_ != null);
        CompostTowerBlockEntity controller = this.getControllerBE();
        if (this.itemCapability.isPresent() && this.fluidCapability.isPresent() || controller == null) {
            return;
        }
        CompostFluidTank tank = this.isController() ? this.tankInventory : controller.tankInventory;
        this.itemCapability = LazyOptional.of(() -> new CompostTowerInventoryHandler(tank));
        this.fluidCapability = LazyOptional.of(() -> new CompostTowerFluidHandler(tank));
    }

    public CompostItemHandler getItemInventory() {
        return new CompostItemHandler(this.getControllerBE().tankInventory);
    }

    protected void onFluidStackChanged(HashMap<Fluid, Integer> tanks) {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.notifyUpdate();
        }
    }

    protected class CompostTowerFluidHandler
    extends CompostFluidTank {
        public CompostTowerFluidHandler(CompostFluidTank tank) {
            super(tank.fluidIds, tank.tanks, tank.updateCallback, tank.index, tank.capacity);
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            int outputHeight = CompostTowerBlockEntity.this.getOutputHeight();
            int towerHeight = CompostTowerBlockEntity.this.getTowerHeight();
            Fluid availFluid = this.getFluidAtBlockHeight(outputHeight, towerHeight);
            if (!resource.getFluid().m_6212_(availFluid)) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            int outputHeight = CompostTowerBlockEntity.this.getOutputHeight();
            int towerHeight = CompostTowerBlockEntity.this.getTowerHeight();
            Fluid availFluid = this.getFluidAtBlockHeight(outputHeight, towerHeight);
            return super.drain(new FluidStack(availFluid, maxDrain), action);
        }
    }

    protected class CompostTowerInventoryHandler
    extends CompostItemHandler {
        public CompostTowerInventoryHandler(CompostFluidTank tank) {
            super(tank);
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return CompostTowerBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    }
}

