/*
 * Decompiled with CFR 0.152.
 */
package com.dowar.mods.create_mixed_casing.mixins.jei;

import com.dowar.mods.create_mixed_casing.config.Configs;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ItemApplicationCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemApplicationCategory.class})
public abstract class ItemApplicationCategoryMixin
extends CreateRecipeCategory<ItemApplicationRecipe> {
    public ItemApplicationCategoryMixin(CreateRecipeCategory.Info<ItemApplicationRecipe> info) {
        super(info);
    }

    @Inject(method={"draw(Lcom/simibubi/create/content/kinetics/deployer/ItemApplicationRecipe;Lmezz/jei/api/gui/ingredient/IRecipeSlotsView;Lnet/minecraft/client/gui/GuiGraphics;DD)V"}, at={@At(value="TAIL")}, remap=false)
    private void onDraw(ItemApplicationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY, CallbackInfo ci) {
        Optional displayedIngredient = ((IRecipeSlotView)recipeSlotsView.getSlotViews().get(0)).getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
        if (displayedIngredient.isEmpty()) {
            return;
        }
        Item item = ((ItemStack)displayedIngredient.get()).m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(74.0f, 51.0f, 100.0f);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-15.5f));
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(22.5f));
        int scale = 20;
        PartialModel entity = null;
        Block block = state.m_60734_();
        if (block instanceof EncasedCogwheelBlock) {
            EncasedCogwheelBlock cogwheel = (EncasedCogwheelBlock)block;
            entity = cogwheel.isLargeCog() ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL;
        }
        if (state.m_60734_() instanceof EncasedShaftBlock) {
            entity = AllPartialModels.SHAFT;
        }
        if (entity != null) {
            GuiGameElement.of((PartialModel)entity).rotateBlock(0.0, (double)AnimatedKinetics.getCurrentAngle() * 1.5, 0.0).scale((double)scale).render(graphics);
        }
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.0f, 200.0f);
        int behavior_count = 0;
        if (blockItem.m_40614_() instanceof CasingBlock) {
            behavior_count += 3;
            if (!((Boolean)Configs.server().processApplicationRecipeOnBelt.get()).booleanValue()) {
                --behavior_count;
            }
            if (!((Boolean)Configs.server().processApplicationRecipeOnEncased.get()).booleanValue()) {
                --behavior_count;
            }
            if (!((Boolean)Configs.server().processApplicationRecipeOnGearbox.get()).booleanValue()) {
                --behavior_count;
            }
        }
        if (!(blockItem.m_40614_() instanceof EntityBlock) && ((Boolean)Configs.server().processApplicationRecipeInCopycat.get()).booleanValue()) {
            ++behavior_count;
        }
        if (behavior_count > 0) {
            graphics.m_280480_(AllItems.BRASS_HAND.asStack(), -2, -2);
            matrixStack.m_252880_(0.0f, 0.0f, 199.0f);
            graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)String.valueOf(behavior_count)), 8, 6, 0xFFFFFF, true);
        }
        matrixStack.m_85849_();
    }

    @NotNull
    public List<Component> getTooltipStrings(ItemApplicationRecipe recipe, @NotNull IRecipeSlotsView SlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Ingredient stack = recipe.getProcessedItem();
        boolean show = false;
        Item item = stack.m_43908_()[0].m_41720_();
        if (!(item instanceof BlockItem)) {
            return tooltip;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (mouseX >= 0.0 && mouseX < 14.0 && mouseY >= 0.0 && mouseY < 14.0) {
            tooltip.add((Component)Component.m_237115_((String)"jei.create_mixed_casing.item_application.behavior.title").m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)Component.m_237115_((String)"jei.create_mixed_casing.item_application.behavior.desc.1"));
            if (!(block instanceof EntityBlock) && ((Boolean)Configs.server().processApplicationRecipeInCopycat.get()).booleanValue()) {
                show = true;
                tooltip.add((Component)Component.m_264642_((String)"jei.create_mixed_casing.item_application.behavior.1", (String)"%s", (Object[])new Object[]{block.m_49954_().getString()}).m_130940_(ChatFormatting.GRAY));
            }
            if (block instanceof CasingBlock) {
                if (((Boolean)Configs.server().processApplicationRecipeOnEncased.get()).booleanValue()) {
                    show = true;
                    tooltip.add((Component)Component.m_264642_((String)"jei.create_mixed_casing.item_application.behavior.2", (String)"%s", (Object[])new Object[]{block.m_49954_().getString()}).m_130940_(ChatFormatting.GRAY));
                }
                if (((Boolean)Configs.server().processApplicationRecipeOnGearbox.get()).booleanValue()) {
                    show = true;
                    tooltip.add((Component)Component.m_264642_((String)"jei.create_mixed_casing.item_application.behavior.4", (String)"%s", (Object[])new Object[]{block.m_49954_().getString()}).m_130940_(ChatFormatting.GRAY));
                }
                if (((Boolean)Configs.server().processApplicationRecipeOnBelt.get()).booleanValue()) {
                    show = true;
                    tooltip.add((Component)Component.m_264642_((String)"jei.create_mixed_casing.item_application.behavior.3", (String)"%s", (Object[])new Object[]{block.m_49954_().getString()}).m_130940_(ChatFormatting.GRAY));
                }
            }
            tooltip.add((Component)Component.m_237115_((String)"jei.create_mixed_casing.item_application.behavior.desc.2"));
            tooltip.add((Component)Component.m_237115_((String)"jei.create_mixed_casing.item_application.behavior.info").m_130940_(ChatFormatting.GRAY));
        }
        if (!show) {
            tooltip.clear();
        }
        return tooltip;
    }
}

