/*
 * Decompiled with CFR 0.152.
 */
package com.dowar.mods.create_mixed_casing.item;

import com.dowar.mods.create_mixed_casing.config.Configs;
import com.dowar.mods.create_mixed_casing.item.MixedWrenchItemHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.decoration.encasing.EncasedBlock;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="create_mixed_casing")
public class MixedWrenchItemBehavior {
    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!Configs.server().wrenchEncasingBehavior.booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        BlockState state = level.m_8055_(pos);
        if (!player.m_36326_()) {
            return;
        }
        if (mainHand.m_41720_() != AllItems.WRENCH.get()) {
            return;
        }
        if (!MixedWrenchItemBehavior.can_be_encased(offHand.m_41720_())) {
            return;
        }
        if (!MixedWrenchItemBehavior.is_encased(state)) {
            return;
        }
        BlockState new_state = MixedWrenchItemBehavior.removeEncasedState(offHand.m_41720_(), face, player, state);
        int required_item = event.getEntity().m_150109_().m_36030_(new_state.m_60734_().m_5456_().m_7968_());
        if (required_item == -1) {
            return;
        }
        level.m_5594_(null, pos, AllSoundEvents.WRENCH_REMOVE.getMainEvent(), SoundSource.PLAYERS, 1.0f, level.f_46441_.m_188501_() * 0.5f + 0.5f);
        if (player.m_7500_()) {
            event.setCanceled(true);
        }
        if (level.f_46443_) {
            return;
        }
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        level.m_7731_(pos, new_state, 3);
        event.getEntity().m_150109_().m_7407_(required_item, 1);
        LootParams.Builder loot = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42396_));
        state.m_287290_(loot).forEach(itemStack -> {
            boolean success = event.getEntity().m_150109_().m_36054_(itemStack);
            if (!success) {
                Block.m_49840_((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)itemStack);
            }
        });
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!Configs.server().wrenchEncasingBehavior.booleanValue()) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        BlockState state = level.m_8055_(pos);
        BlockHitResult hit = event.getHitVec();
        BlockPos hit_block = hit.m_82425_();
        if (!player.m_36326_()) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        if (mainHand.m_41720_() != AllItems.WRENCH.get()) {
            return;
        }
        if (!MixedWrenchItemBehavior.can_be_encased(offHand.m_41720_())) {
            return;
        }
        if (!(state.m_60734_() instanceof EncasedBlock)) {
            List encased_list = EncasingRegistry.getVariants((Block)Block.m_49814_((Item)offHand.m_41720_()));
            Block found = Blocks.f_50016_;
            for (Block block : encased_list) {
                EncasedBlock encased;
                if (!(block instanceof EncasedBlock) || (encased = (EncasedBlock)block).getCasing().m_5456_() != state.m_60734_().m_5456_()) continue;
                found = (Block)encased;
            }
            if (found == Blocks.f_50016_) {
                return;
            }
            BlockState newstate = found.m_49966_();
            if (newstate.m_60734_() instanceof EncasedPipeBlock) {
                newstate = MixedWrenchItemHelper.handleClick(newstate, hit_block, hit);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)newstate));
            level.m_7731_(pos, newstate, 3);
            offHand.m_41774_(1);
            if (level.f_46443_) {
                return;
            }
            boolean success = event.getEntity().m_150109_().m_36054_(state.m_60734_().m_5456_().m_7968_());
            if (!success) {
                Block.m_49840_((Level)event.getLevel(), (BlockPos)event.getPos(), (ItemStack)state.m_60734_().m_5456_().m_7968_());
            }
        } else if (state.m_60734_() instanceof EncasedPipeBlock) {
            state = MixedWrenchItemHelper.handleClick(state, hit_block, hit);
            MixedWrenchItemBehavior.set_state(event, level, pos, state);
        }
    }

    private static void set_state(PlayerInteractEvent.RightClickBlock event, Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, SoundEvents.f_12017_, SoundSource.PLAYERS, 1.0f, -level.f_46441_.m_188501_() + 0.5f);
        level.m_7731_(pos, state, 3);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private static BlockState removeEncasedState(Item item, Direction face, Player player, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof EncasedBlock) {
            EncasedBlock encased = (EncasedBlock)block;
            return encased.getCasing().m_49966_();
        }
        return state;
    }

    private static boolean can_be_encased(Item item) {
        return item == AllBlocks.FLUID_PIPE.m_5456_();
    }

    private static boolean is_encased(BlockState state) {
        return state.m_60734_() instanceof EncasedPipeBlock;
    }
}

