/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.content.fluidvessel.BoilerData;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidVesselBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    private static final int SYNC_RATE = 8;
    protected FluidVesselBlock.WindowType windowType = FluidVesselBlock.WindowType.SIDE_WIDE;
    private LerpedFloat fluidLevel;

    public FluidVesselBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.boiler = new BoilerData();
        this.refreshCapability();
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(FluidVesselBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.fluidLevel != null) {
            this.fluidLevel.tickChaser();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public Direction.Axis getAxis() {
        return (Direction.Axis)this.m_58900_().m_61143_(FluidVesselBlock.AXIS);
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.width + 1.0f);
        Direction.Axis axis = this.getAxis();
        for (int yOffset = 0; yOffset < this.width; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.width - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    FluidVesselBlockEntity vesselAt = (FluidVesselBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (vesselAt == null) continue;
                    this.f_58857_.m_46717_(pos, vesselAt.m_58900_().m_60734_());
                    if (vesselAt.luminosity == actualLuminosity) continue;
                    vesselAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            if (this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
            }
            this.fluidLevel.chase((double)this.getFillState(), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    public FluidVesselBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof FluidVesselBlockEntity) {
            return (FluidVesselBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.boiler.clear();
        this.onFluidStackChanged(this.tankInventory.getFluid());
        BlockState state = this.m_58900_();
        if (FluidVesselBlock.isVessel(state)) {
            state = (BlockState)state.m_61124_((Property)FluidVesselBlock.POSITIVE, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)FluidVesselBlock.NEGATIVE, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(FluidVesselBlock.SHAPE, (Comparable)((Object)(this.window ? FluidVesselBlock.Shape.WINDOW : FluidVesselBlock.Shape.PLAIN)));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public boolean isWindowTypeAllowed(FluidVesselBlock.WindowType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FluidVesselBlock.WindowType.SIDE_WIDE -> true;
            case FluidVesselBlock.WindowType.SIDE_NARROW_ENDS -> {
                if (this.height >= 2) {
                    yield true;
                }
                yield false;
            }
            case FluidVesselBlock.WindowType.SIDE_NARROW_THIRDS -> {
                if (this.height >= 3) {
                    yield true;
                }
                yield false;
            }
            case FluidVesselBlock.WindowType.SIDE_HORIZONTAL -> this.width > 2 && this.width % 2 == 1;
        };
    }

    public void toggleWindows() {
        FluidVesselBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (be.boiler.isActive()) {
            return;
        }
        if (!be.window) {
            be.setWindowType(FluidVesselBlock.WindowType.SIDE_WIDE);
            be.setWindows(true);
        } else {
            FluidVesselBlock.WindowType[] types = FluidVesselBlock.WindowType.values();
            if (be.windowType.ordinal() >= types.length - 1) {
                be.setWindows(false);
                return;
            }
            FluidVesselBlock.WindowType nextType = types[be.windowType.ordinal() + 1];
            while (!be.isWindowTypeAllowed(nextType)) {
                if (nextType.ordinal() >= types.length - 1) {
                    be.setWindows(false);
                    return;
                }
                nextType = types[nextType.ordinal() + 1];
            }
            be.setWindowType(nextType);
            be.setWindows(true);
        }
    }

    public FluidVesselBlock.WindowType getWindowType() {
        return this.windowType;
    }

    public void setWindowType(FluidVesselBlock.WindowType windowType) {
        this.windowType = windowType;
    }

    public void setWindows(boolean window) {
        this.window = window;
        Direction.Axis axis = this.getAxis();
        for (int yOffset = 0; yOffset < this.width; ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    FluidVesselBlock.Shape shape = FluidVesselBlock.Shape.PLAIN;
                    if (window) {
                        if (this.windowType == FluidVesselBlock.WindowType.SIDE_HORIZONTAL) {
                            if (yOffset == this.width / 2) {
                                shape = FluidVesselBlock.Shape.WINDOW;
                            }
                        } else if (this.windowType == FluidVesselBlock.WindowType.SIDE_WIDE || this.height <= 1) {
                            if (widthOffset == 0 || widthOffset == this.width - 1) {
                                shape = this.width == 1 ? FluidVesselBlock.Shape.WINDOW : (yOffset == 0 ? FluidVesselBlock.Shape.WINDOW_TOP : (yOffset == this.width - 1 ? FluidVesselBlock.Shape.WINDOW_BOTTOM : FluidVesselBlock.Shape.WINDOW_MIDDLE));
                            }
                        } else if (this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_ENDS || this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_THIRDS) {
                            int windowOffset;
                            int n = windowOffset = this.windowType == FluidVesselBlock.WindowType.SIDE_NARROW_ENDS ? 0 : Math.max(1, this.height / 3 - 1);
                            if (!(lengthOffset != windowOffset && lengthOffset != this.height - 1 - windowOffset || widthOffset != 0 && widthOffset != this.width - 1)) {
                                shape = this.width == 1 ? FluidVesselBlock.Shape.WINDOW_SINGLE : (yOffset == 0 ? FluidVesselBlock.Shape.WINDOW_TOP_SINGLE : (yOffset == this.width - 1 ? FluidVesselBlock.Shape.WINDOW_BOTTOM_SINGLE : FluidVesselBlock.Shape.WINDOW_MIDDLE_SINGLE));
                            }
                        }
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(FluidVesselBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    public void updateBoilerState() {
        if (!this.isController()) {
            return;
        }
        boolean wasBoiler = this.boiler.isActive();
        boolean changed = this.boiler.evaluate((FluidTankBlockEntity)this);
        if (wasBoiler != this.boiler.isActive()) {
            if (this.boiler.isActive()) {
                this.setWindows(false);
            }
            Direction.Axis axis = this.getAxis();
            for (int yOffset = 0; yOffset < this.width; ++yOffset) {
                for (int lengthOffset = 0; lengthOffset < this.height; ++lengthOffset) {
                    for (int widthOffset = 0; widthOffset < this.width; ++widthOffset) {
                        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset));
                        if (!(blockEntity instanceof FluidVesselBlockEntity)) continue;
                        FluidVesselBlockEntity fbe = (FluidVesselBlockEntity)blockEntity;
                        fbe.refreshCapability();
                    }
                }
            }
        }
        if (changed) {
            this.notifyUpdate();
            this.boiler.checkPipeOrganAdvancement((FluidTankBlockEntity)this);
        }
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(this::handlerForCapability);
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? (this.boiler.isActive() ? this.boiler.createHandler() : this.tankInventory) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            Direction.Axis axis = this.getAxis();
            return super.createRenderBoundingBox().m_82363_(axis == Direction.Axis.X ? (double)(this.height - 1) : (double)(this.width - 1), (double)(this.width - 1), axis == Direction.Axis.Z ? (double)(this.height - 1) : (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public FluidVesselBlockEntity getOtherFluidTankBlockEntity(Direction direction) {
        BlockEntity otherBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (otherBE instanceof FluidVesselBlockEntity) {
            return (FluidVesselBlockEntity)otherBE;
        }
        return null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        FluidVesselBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        if (controllerBE.boiler.addToGoggleTooltip(tooltip, isPlayerSneaking, controllerBE.getTotalTankSize())) {
            return true;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevWidth = this.width;
        int prevLength = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.windowType = (FluidVesselBlock.WindowType)NBTHelper.readEnum((CompoundTag)compound, (String)"WindowType", FluidVesselBlock.WindowType.class);
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * FluidVesselBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        this.boiler.read(compound.m_128469_("Boiler"), this.width * this.width * this.height);
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.fluidLevel = LerpedFloat.linear().startWithValue((double)this.getFillState());
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevWidth != this.width || prevLength != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(FluidVesselBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.fluidLevel = LerpedFloat.linear().startWithValue((double)fillState);
            }
            this.fluidLevel.chase((double)fillState, 0.5, LerpedFloat.Chaser.EXP);
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
        if (compound.m_128441_("LazySync")) {
            this.fluidLevel.chase((double)this.fluidLevel.getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        compound.m_128365_("Boiler", (Tag)this.boiler.write());
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            NBTHelper.writeEnum((CompoundTag)compound, (String)"WindowType", (Enum)this.windowType);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat getFluidLevel() {
        return this.fluidLevel;
    }

    public void setFluidLevel(LerpedFloat fluidLevel) {
        this.fluidLevel = fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (FluidVesselBlock.isVessel(state)) {
            Direction.Axis axis = this.getAxis();
            state = (BlockState)state.m_61124_((Property)FluidVesselBlock.NEGATIVE, (Comparable)Boolean.valueOf(axis == Direction.Axis.X ? this.getController().m_123341_() == this.m_58899_().m_123341_() : this.getController().m_123343_() == this.m_58899_().m_123343_()));
            state = (BlockState)state.m_61124_((Property)FluidVesselBlock.POSITIVE, (Comparable)Boolean.valueOf(axis == Direction.Axis.X ? this.getController().m_123341_() + this.height - 1 == this.m_58899_().m_123341_() : this.getController().m_123343_() + this.height - 1 == this.m_58899_().m_123343_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.updateBoilerState();
        this.m_6596_();
    }

    public void setExtraData(@Nullable Object data) {
        if (data == null) {
            this.window = false;
            this.windowType = FluidVesselBlock.WindowType.SIDE_WIDE;
        } else if (data instanceof FluidVesselBlock.WindowType) {
            FluidVesselBlock.WindowType type = (FluidVesselBlock.WindowType)((Object)data);
            this.window = true;
            this.windowType = type;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window ? this.windowType : null;
    }

    public Object modifyExtraData(Object data) {
        if (data == null || data instanceof FluidVesselBlock.WindowType) {
            if (data != null && !this.window) {
                return data;
            }
            if (this.window) {
                return this.windowType;
            }
            return null;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getAxis();
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return FluidVesselBlockEntity.getMaxHeight();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getTankSize(int tank) {
        return FluidVesselBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public boolean hasWindow() {
        return this.window;
    }

    public int getLuminosity() {
        return this.luminosity;
    }
}

