/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.foundation.data.recipe.CommonMetal;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.mixin.fabric.TagAppenderAccessor;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2474;
import net.minecraft.class_3481;
import net.minecraft.class_3495;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class TagGen {
    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713}).tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33713});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new class_6862[]{class_3481.field_33715});
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<class_1747, BlockBuilder<T, P>>> tagBlockAndItem(CommonMetal.ItemLikeTag tag) {
        return TagGen.tagBlockAndItem(Map.of(tag.blocks(), tag.items()));
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<class_1747, BlockBuilder<T, P>>> tagBlockAndItem(class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
        return TagGen.tagBlockAndItem(Map.of(blockTag, itemTag));
    }

    public static <T extends class_2248, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<class_1747, BlockBuilder<T, P>>> tagBlockAndItem(Map<class_6862<class_2248>, class_6862<class_1792>> tags) {
        return b -> {
            for (class_6862 blockTag : tags.keySet()) {
                b.tag(new class_6862[]{blockTag});
            }
            ItemBuilder item = b.item();
            for (class_6862 itemTag : tags.values()) {
                item.tag(new class_6862[]{itemTag});
            }
            return item;
        };
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, String id) {
        appender.method_35922(mod.asResource(id));
        return appender;
    }

    public static <T extends class_2474.class_5124<?>> T addOptional(T appender, Mods mod, List<String> ids) {
        for (String id : ids) {
            appender.method_35922(mod.asResource(id));
        }
        return appender;
    }

    public static class CreateTagAppender<T>
    extends class_2474.class_5124<T> {
        private Function<T, class_5321<T>> keyExtractor;
        private final FabricTagProvider.FabricTagBuilder fabricBuilder;

        public CreateTagAppender(FabricTagProvider.FabricTagBuilder fabricBuilder, Function<T, class_5321<T>> pKeyExtractor) {
            super(CreateTagAppender.getBuilder(fabricBuilder));
            this.keyExtractor = pKeyExtractor;
            this.fabricBuilder = fabricBuilder;
        }

        private static class_3495 getBuilder(class_2474.class_5124<?> appender) {
            return ((TagAppenderAccessor)appender).getBuilder();
        }

        public CreateTagAppender<T> add(T entry) {
            this.method_46835(this.keyExtractor.apply(entry));
            return this;
        }

        @SafeVarargs
        public final CreateTagAppender<T> add(T ... entries) {
            Stream.of(entries).map(this.keyExtractor).forEach(arg_0 -> ((CreateTagAppender)this).method_46835(arg_0));
            return this;
        }

        @NotNull
        public class_2474.class_5124<T> method_26792(@NotNull class_6862<T> tag) {
            this.fabricBuilder.forceAddTag(tag);
            return this;
        }
    }

    public static class CreateTagsProvider<T> {
        private RegistrateTagsProvider<T> provider;
        private Function<T, class_5321<T>> keyExtractor;

        public CreateTagsProvider(RegistrateTagsProvider<T> provider, Function<T, class_6880.class_6883<T>> refExtractor) {
            this.provider = provider;
            this.keyExtractor = refExtractor.andThen(class_6880.class_6883::method_40237);
        }

        public CreateTagAppender<T> tag(class_6862<T> tag) {
            return new CreateTagAppender<T>(this.provider.addTag(tag), this.keyExtractor);
        }

        public void getOrCreateRawBuilder(class_6862<T> tag) {
            this.tag(tag);
        }
    }
}

