/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.nixieTube;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubeBlockEntity
extends SmartBlockEntity {
    private static final Couple<String> EMPTY = Couple.create((Object)"", (Object)"");
    private static final String EMPTY_COMPONENT_JSON = class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)""));
    private int redstoneStrength = 0;
    private Optional<DynamicComponent> customText = Optional.empty();
    private int nixieIndex;
    private Couple<String> displayedStrings;
    public AbstractComputerBehaviour computerBehaviour;
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    @Nullable
    public SignalBlockEntity.SignalState signalState;
    @Nullable
    public ComputerSignal computerSignal;

    public NixieTubeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            return;
        }
        this.signalState = null;
        if (this.computerBehaviour.hasAttachedComputer()) {
            if (this.field_11863.field_9236 && this.cachedSignalTE.get() != null) {
                this.cachedSignalTE = new WeakReference<Object>(null);
            }
            return;
        }
        this.computerSignal = null;
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        if (signalBlockEntity == null || signalBlockEntity.method_11015()) {
            class_2350 facing = NixieTubeBlock.getFacing(this.method_11010());
            class_2586 blockEntity = this.field_11863.method_8321(this.field_11867.method_10093(facing.method_10153()));
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
            }
            return;
        }
        this.signalState = signalBlockEntity.getState();
    }

    @Override
    public void initialize() {
        if (this.field_11863.field_9236) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return !this.computerBehaviour.hasAttachedComputer() && this.customText.isEmpty();
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public class_5250 getFullText() {
        return this.customText.map(DynamicComponent::get).orElse(class_2561.method_43470((String)("" + this.redstoneStrength)));
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayCustomText(String tagElement, int nixiePositionInRow) {
        if (tagElement == null) {
            return;
        }
        if (this.customText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.field_11863, this.field_11867, tagElement);
        this.customText = Optional.of(component);
        this.nixieIndex = nixiePositionInRow;
        DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
        this.notifyUpdate();
    }

    public void displayEmptyText(int nixiePositionInRow) {
        this.displayCustomText(EMPTY_COMPONENT_JSON, nixiePositionInRow);
    }

    public void updateDisplayedStrings() {
        if (this.signalState != null || this.computerSignal != null) {
            return;
        }
        this.customText.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.displayedStrings = Couple.create((Object)this.charOrEmpty((String)fullText, this.nixieIndex * 2), (Object)this.charOrEmpty((String)fullText, this.nixieIndex * 2 + 1));
        }, () -> {
            this.displayedStrings = Couple.create((Object)(this.redstoneStrength < 10 ? "0" : "1"), (Object)String.valueOf(this.redstoneStrength % 10));
        });
    }

    public void clearCustomText() {
        this.nixieIndex = 0;
        this.customText = Optional.empty();
    }

    public int getRedstoneStrength() {
        return this.redstoneStrength;
    }

    @Override
    protected void read(class_2487 nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.method_10545("CustomText")) {
            DynamicComponent component = this.customText.orElseGet(DynamicComponent::new);
            component.read(this.field_11863, this.field_11867, nbt);
            if (component.isValid()) {
                this.customText = Optional.of(component);
                this.nixieIndex = nbt.method_10550("CustomTextIndex");
            } else {
                this.customText = Optional.empty();
                this.nixieIndex = 0;
            }
        } else {
            this.customText = Optional.empty();
            this.nixieIndex = 0;
        }
        if (this.customText.isEmpty()) {
            this.redstoneStrength = nbt.method_10550("RedstoneStrength");
        }
        if (clientPacket || this.isVirtual()) {
            if (nbt.method_10545("ComputerSignal")) {
                byte[] encodedComputerSignal = nbt.method_10547("ComputerSignal");
                if (this.computerSignal == null) {
                    this.computerSignal = new ComputerSignal();
                }
                this.computerSignal.decode(encodedComputerSignal);
            } else {
                this.computerSignal = null;
            }
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(class_2487 nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.customText.isPresent()) {
            nbt.method_10569("CustomTextIndex", this.nixieIndex);
            this.customText.get().write(nbt);
        } else {
            nbt.method_10569("RedstoneStrength", this.redstoneStrength);
        }
        if (clientPacket && this.computerSignal != null) {
            nbt.method_10570("ComputerSignal", this.computerSignal.encode());
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    public static final class ComputerSignal {
        @NotNull
        public TubeDisplay first = new TubeDisplay();
        @NotNull
        public TubeDisplay second = new TubeDisplay();

        public void decode(byte[] encoded) {
            this.first.decode(encoded, 0);
            this.second.decode(encoded, 7);
        }

        public byte[] encode() {
            byte[] encoded = new byte[14];
            this.first.encode(encoded, 0);
            this.second.encode(encoded, 7);
            return encoded;
        }

        public static final class TubeDisplay {
            public static final int ENCODED_SIZE = 7;
            public byte r = (byte)63;
            public byte g = (byte)63;
            public byte b = (byte)63;
            public byte blinkPeriod = 0;
            public byte blinkOffTime = 0;
            public byte glowWidth = 1;
            public byte glowHeight = 1;

            public void decode(byte[] data, int offset) {
                this.r = data[offset];
                this.g = data[offset + 1];
                this.b = data[offset + 2];
                this.blinkPeriod = data[offset + 3];
                this.blinkOffTime = data[offset + 4];
                this.glowWidth = data[offset + 5];
                this.glowHeight = data[offset + 6];
            }

            public void encode(byte[] data, int offset) {
                data[offset] = this.r;
                data[offset + 1] = this.g;
                data[offset + 2] = this.b;
                data[offset + 3] = this.blinkPeriod;
                data[offset + 4] = this.blinkOffTime;
                data[offset + 5] = this.glowWidth;
                data[offset + 6] = this.glowHeight;
            }
        }
    }
}

