/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort.frogport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.compat.computercraft.events.PackageEvent;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportSounds;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.TooltipHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class FrogportBlockEntity
extends PackagePortBlockEntity
implements IHaveHoveringInformation {
    public class_1799 animatedPackage;
    public LerpedFloat manualOpenAnimationProgress;
    public LerpedFloat animationProgress;
    public LerpedFloat anticipationProgress;
    public boolean currentlyDepositing;
    public boolean goggles = false;
    public boolean sendAnticipate;
    public float passiveYaw;
    private boolean failedLastExport;
    private FrogportSounds sounds = new FrogportSounds();
    private class_1799 deferAnimationStart;
    private boolean deferAnimationInward;
    private AdvancementBehaviour advancements;
    public AbstractComputerBehaviour computerBehaviour;

    public FrogportBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.animationProgress = LerpedFloat.linear();
        this.anticipationProgress = LerpedFloat.linear();
        this.manualOpenAnimationProgress = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.35, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.advancements = new AdvancementBehaviour(this, AllAdvancements.FROGPORT);
        behaviours.add(this.advancements);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
        super.addBehaviours(behaviours);
    }

    public boolean isAnimationInProgress() {
        return this.animationProgress.getChaseTarget() == 1.0f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_238 getRenderBoundingBox() {
        class_238 bb = super.getRenderBoundingBox().method_1012(0.0, 1.0, 0.0);
        if (this.target != null) {
            bb = bb.method_991(new class_238(class_2338.method_49638((class_2374)this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867)))).method_1014(0.5);
        }
        return bb;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.method_8608() || this.isAnimationInProgress()) {
            return;
        }
        boolean prevFail = this.failedLastExport;
        this.tryPushingToAdjacentInventories();
        this.tryPullingFromOwnAndAdjacentInventories();
        if (this.failedLastExport != prevFail) {
            this.sendData();
        }
    }

    public void sendAnticipate() {
        if (this.isAnimationInProgress()) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            if (!this.inventory.getStackInSlot(i).method_7960()) continue;
            this.sendAnticipate = true;
            this.sendData();
            return;
        }
    }

    public void anticipate() {
        this.anticipationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.deferAnimationStart != null) {
            this.startAnimation(this.deferAnimationStart, this.deferAnimationInward);
            this.deferAnimationStart = null;
        }
        if (this.anticipationProgress.getValue() == 1.0f) {
            this.anticipationProgress.startWithValue(0.0);
        }
        this.manualOpenAnimationProgress.updateChaseTarget(this.openTracker.openCount > 0 ? 1.0f : 0.0f);
        boolean wasOpen = this.manualOpenAnimationProgress.getValue() > 0.0f;
        this.anticipationProgress.tickChaser();
        this.manualOpenAnimationProgress.tickChaser();
        if (this.field_11863.method_8608() && wasOpen && this.manualOpenAnimationProgress.getValue() == 0.0f) {
            this.sounds.close(this.field_11863, this.field_11867);
        }
        if (!this.isAnimationInProgress()) {
            return;
        }
        this.animationProgress.tickChaser();
        float value = this.animationProgress.getValue();
        if (this.currentlyDepositing) {
            if (!this.field_11863.method_8608() || this.isVirtual()) {
                if ((double)value > 0.5 && this.animatedPackage != null) {
                    if (this.target == null || !this.target.depositImmediately() && !this.target.export((class_1936)this.field_11863, this.field_11867, this.animatedPackage, false)) {
                        this.drop(this.animatedPackage);
                    } else {
                        this.computerBehaviour.prepareComputerEvent(new PackageEvent(this.animatedPackage, "package_sent"));
                    }
                    this.animatedPackage = null;
                }
            } else {
                if ((double)value > 0.7 && this.animatedPackage != null) {
                    this.animatedPackage = null;
                }
                if ((double)this.animationProgress.getValue(0.0f) < 0.2 && (double)value > 0.2) {
                    class_243 v = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867);
                    this.field_11863.method_8486(v.field_1352, v.field_1351, v.field_1350, class_3417.field_24064, class_3419.field_15245, 0.25f, 1.2f, false);
                }
            }
        }
        if (value < 1.0f) {
            return;
        }
        this.anticipationProgress.startWithValue(0.0);
        this.animationProgress.startWithValue(0.0);
        if (this.field_11863.method_8608()) {
            this.animatedPackage = null;
            return;
        }
        if (!this.currentlyDepositing) {
            long inserted = TransferUtil.insertItem((Storage)this.inventory, (class_1799)this.animatedPackage.method_7972());
            if (inserted <= 0L) {
                this.drop(this.animatedPackage);
            } else {
                this.computerBehaviour.prepareComputerEvent(new PackageEvent(this.animatedPackage, "package_received"));
            }
        }
        this.animatedPackage = null;
    }

    public void startAnimation(class_1799 box, boolean deposit) {
        if (!PackageItem.isPackage(box)) {
            return;
        }
        if (deposit && (this.target == null || this.target.depositImmediately() && !this.target.export((class_1936)this.field_11863, this.field_11867, box.method_7972(), false))) {
            return;
        }
        this.animationProgress.startWithValue(0.0);
        this.animationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
        this.animatedPackage = box;
        this.currentlyDepositing = deposit;
        if (this.field_11863 != null && !deposit && !this.field_11863.method_8608()) {
            this.advancements.awardPlayer(AllAdvancements.FROGPORT);
        }
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            this.sounds.open(this.field_11863, this.field_11867);
            if (this.currentlyDepositing) {
                this.sounds.depositPackage(this.field_11863, this.field_11867);
            } else {
                this.sounds.catchPackage(this.field_11863, this.field_11867);
                class_243 vec = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867);
                if (vec != null) {
                    for (int i = 0; i < 5; ++i) {
                        this.field_11863.method_8406((class_2394)new class_2388(class_2398.field_11217, AllBlocks.ROPE.getDefaultState()), vec.field_1352, vec.field_1351 - (double)this.field_11863.field_9229.method_43057() * 0.25, vec.field_1350, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8524(this.field_11867);
            this.sendData();
        }
    }

    protected void tryPushingToAdjacentInventories() {
        this.failedLastExport = false;
        Storage inventory = this.exposedInventory;
        if (inventory == null) {
            return;
        }
        if (!inventory.nonEmptyViews().iterator().hasNext()) {
            return;
        }
        Storage<ItemVariant> handler = this.getAdjacentInventory(class_2350.field_11033);
        if (handler == null) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            boolean failed = false;
            for (StorageView view : inventory.nonEmptyViews()) {
                long inserted;
                ItemVariant resource;
                long extracted = view.extract((Object)(resource = (ItemVariant)view.getResource()), view.getAmount(), (TransactionContext)t);
                if (extracted <= 0L || (inserted = handler.insert((Object)resource, extracted, (TransactionContext)t)) == extracted) continue;
                failed = true;
                break;
            }
            if (failed) {
                this.failedLastExport = true;
            } else {
                t.commit();
                this.field_11863.method_8524(this.field_11867);
            }
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
    }

    public void tryPullingFromOwnAndAdjacentInventories() {
        if (this.isAnimationInProgress()) {
            return;
        }
        if (this.target == null || !this.target.export((class_1936)this.field_11863, this.field_11867, PackageStyles.getDefaultBox(), true)) {
            return;
        }
        if (this.tryPullingFrom((Storage<ItemVariant>)this.inventory)) {
            return;
        }
        for (class_2350 side : Iterate.directions) {
            Storage<ItemVariant> handler;
            if (side != class_2350.field_11033 || (handler = this.getAdjacentInventory(side)) == null || !this.tryPullingFrom(handler)) continue;
            return;
        }
    }

    public boolean tryPullingFrom(Storage<ItemVariant> handler) {
        class_1799 extract = ItemHelper.extract(handler, stack -> {
            if (!PackageItem.isPackage(stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || handler instanceof PackagerItemHandler || !PackageItem.matchAddress(stack, filterString);
        }, false);
        if (extract.method_7960()) {
            return false;
        }
        this.startAnimation(extract, true);
        return true;
    }

    protected Storage<ItemVariant> getAdjacentInventory(class_2350 side) {
        return (Storage)ItemStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(side), (Object)side.method_10153());
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10548("PlacedYaw", this.passiveYaw);
        if (this.animatedPackage != null && this.isAnimationInProgress()) {
            tag.method_10566("AnimatedPackage", this.animatedPackage.serializeNBT());
            tag.method_10556("Deposit", this.currentlyDepositing);
        }
        if (this.sendAnticipate) {
            this.sendAnticipate = false;
            tag.method_10556("Anticipate", true);
        }
        if (this.failedLastExport) {
            NBTHelper.putMarker((class_2487)tag, (String)"FailedLastExport");
        }
        if (this.goggles) {
            NBTHelper.putMarker((class_2487)tag, (String)"Goggles");
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.passiveYaw = tag.method_10583("PlacedYaw");
        this.failedLastExport = tag.method_10577("FailedLastExport");
        this.goggles = tag.method_10577("Goggles");
        if (!clientPacket) {
            this.animatedPackage = null;
        }
        if (tag.method_10545("AnimatedPackage")) {
            this.deferAnimationInward = tag.method_10577("Deposit");
            this.deferAnimationStart = class_1799.method_7915((class_2487)tag.method_10562("AnimatedPackage"));
        }
        if (clientPacket && tag.method_10545("Anticipate")) {
            this.anticipate();
        }
    }

    public float getYaw() {
        if (this.target == null) {
            return this.passiveYaw;
        }
        class_243 diff = this.target.getExactTargetLocation(this, (class_1936)this.field_11863, this.field_11867).method_1020(class_243.method_24953((class_2382)this.field_11867));
        return (float)(class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350) * 57.2957763671875) + 180.0f;
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean superTip = IHaveHoveringInformation.super.addToTooltip(tooltip, isPlayerSneaking);
        if (!this.failedLastExport) {
            return superTip;
        }
        TooltipHelper.addHint(tooltip, "hint.blocked_frogport", new Object[0]);
        return true;
    }

    @Override
    protected void onOpenedManually() {
        if (this.field_11863.method_8608()) {
            this.sounds.open(this.field_11863, this.field_11867);
        }
    }

    @Override
    public class_1269 use(class_1657 player) {
        if (player == null) {
            return class_1269.field_5811;
        }
        class_1799 mainHandItem = player.method_6047();
        if (!this.goggles && AllItems.GOGGLES.isIn(mainHandItem)) {
            this.goggles = true;
            if (!this.field_11863.method_8608()) {
                this.notifyUpdate();
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14761, class_3419.field_15245, 0.5f, 1.0f);
            }
            return class_1269.field_5812;
        }
        return super.use(player);
    }
}

