/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class BookAuthorAttribute
implements ItemAttribute {
    private String author;

    public BookAuthorAttribute(String author) {
        this.author = author;
    }

    private static String extractAuthor(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt != null && nbt.method_10545("author")) {
            return nbt.method_10558("author");
        }
        return "";
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return BookAuthorAttribute.extractAuthor(itemStack).equals(this.author);
    }

    @Override
    public String getTranslationKey() {
        return "book_author";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.author};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.BOOK_AUTHOR;
    }

    @Override
    public void save(class_2487 nbt) {
        nbt.method_10582("author", this.author);
    }

    @Override
    public void load(class_2487 nbt) {
        this.author = nbt.method_10558("author");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new BookAuthorAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            String name = BookAuthorAttribute.extractAuthor(stack);
            if (!name.isEmpty()) {
                list.add(new BookAuthorAttribute(name));
            }
            return list;
        }
    }
}

