/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1920;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class FactoryPanelSupportBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<FactoryPanelSupportBehaviour> TYPE = new BehaviourType();
    private List<FactoryPanelPosition> linkedPanels;
    private boolean changed;
    private Supplier<Boolean> outputPower;
    private Supplier<Boolean> isOutput;
    private Runnable onNotify;

    public FactoryPanelSupportBehaviour(SmartBlockEntity be, Supplier<Boolean> isOutput, Supplier<Boolean> outputPower, Runnable onNotify) {
        super(be);
        this.isOutput = isOutput;
        this.outputPower = outputPower;
        this.onNotify = onNotify;
        this.linkedPanels = new ArrayList<FactoryPanelPosition>();
    }

    public boolean shouldPanelBePowered() {
        return this.isOutput() && this.outputPower.get() != false;
    }

    public boolean isOutput() {
        return this.isOutput.get();
    }

    public void notifyLink() {
        this.onNotify.run();
    }

    @Override
    public void destroy() {
        for (FactoryPanelPosition panelPos : this.linkedPanels) {
            if (!this.getWorld().method_8477(panelPos.pos())) continue;
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((class_1920)this.getWorld(), panelPos);
            behaviour.targetedByLinks.remove(this.getPos());
            behaviour.blockEntity.notifyUpdate();
        }
        super.destroy();
    }

    public void notifyPanels() {
        if (this.getWorld().method_8608()) {
            return;
        }
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getWorld().method_8477(panelPos.pos())) continue;
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((class_1920)this.getWorld(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            behaviour.checkForRedstoneInput();
        }
    }

    @Nullable
    public Boolean shouldBePoweredTristate() {
        Iterator<FactoryPanelPosition> iterator = this.linkedPanels.iterator();
        while (iterator.hasNext()) {
            FactoryPanelPosition panelPos = iterator.next();
            if (!this.getWorld().method_8477(panelPos.pos())) {
                return null;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((class_1920)this.getWorld(), panelPos);
            if (behaviour == null) {
                iterator.remove();
                this.changed = true;
                continue;
            }
            if (!behaviour.isActive() || !behaviour.satisfied || behaviour.count == 0) continue;
            return true;
        }
        return false;
    }

    public List<FactoryPanelPosition> getLinkedPanels() {
        return this.linkedPanels;
    }

    public void connect(FactoryPanelBehaviour panel) {
        FactoryPanelPosition panelPosition = panel.getPanelPosition();
        if (this.linkedPanels.contains(panelPosition)) {
            return;
        }
        this.linkedPanels.add(panelPosition);
        this.changed = true;
    }

    public void disconnect(FactoryPanelBehaviour panel) {
        this.linkedPanels.remove(panel.getPanelPosition());
        this.changed = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.changed) {
            this.changed = false;
            if (!this.isOutput()) {
                this.notifyLink();
            }
            this.blockEntity.method_5431();
        }
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        if (!this.linkedPanels.isEmpty()) {
            nbt.method_10566("LinkedGauges", (class_2520)NBTHelper.writeCompoundList(this.linkedPanels, FactoryPanelPosition::write));
        }
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.linkedPanels.clear();
        this.linkedPanels.addAll(NBTHelper.readCompoundList((class_2499)nbt.method_10554("LinkedGauges", 10), FactoryPanelPosition::read));
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }
}

