/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crank;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlock;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class ValveHandleBlockEntity
extends HandCrankBlockEntity {
    public ScrollValueBehaviour angleInput;
    public int cooldown;
    protected int startAngle;
    protected int targetAngle;
    protected int totalUseTicks;

    public ValveHandleBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.angleInput = new ValveHandleScrollValueBehaviour(this).between(-180, 180);
        behaviours.add(this.angleInput);
        this.angleInput.onlyActiveWhen(this::showValue);
        this.angleInput.setValue(45);
    }

    @Override
    protected boolean clockwise() {
        return this.angleInput.getValue() < 0 ^ this.backwards;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("TotalUseTicks", this.totalUseTicks);
        compound.method_10569("StartAngle", this.startAngle);
        compound.method_10569("TargetAngle", this.targetAngle);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.totalUseTicks = compound.method_10550("TotalUseTicks");
        this.startAngle = compound.method_10550("StartAngle");
        this.targetAngle = compound.method_10550("TargetAngle");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inUse == 0 && this.cooldown > 0) {
            --this.cooldown;
        }
        this.independentAngle = this.field_11863.method_8608() ? this.getIndependentAngle(0.0f) : 0.0f;
    }

    @Override
    public float getIndependentAngle(float partialTicks) {
        if (this.inUse == 0 && this.source != null && this.getSpeed() != 0.0f) {
            return KineticBlockEntityRenderer.getAngleForBe(this, this.field_11867, KineticBlockEntityRenderer.getRotationAxisOf(this));
        }
        int step = this.method_11010().method_28500((class_2769)ValveHandleBlock.FACING).orElse(class_2350.field_11035).method_10171().method_10181();
        return (this.inUse > 0 && this.totalUseTicks > 0 ? class_3532.method_16439((float)(Math.min((float)this.totalUseTicks, (float)(this.totalUseTicks - this.inUse) + partialTicks) / (float)this.totalUseTicks), (float)this.startAngle, (float)this.targetAngle) : (float)this.targetAngle) * ((float)Math.PI / 180) * (float)(this.backwards ? -1 : 1) * (float)step;
    }

    public boolean showValue() {
        return this.inUse == 0;
    }

    public boolean activate(boolean sneak) {
        if (this.getTheoreticalSpeed() != 0.0f) {
            return false;
        }
        if (this.inUse > 0 || this.cooldown > 0) {
            return false;
        }
        if (this.field_11863.field_9236) {
            return true;
        }
        int value = this.angleInput.getValue();
        int target = Math.abs(value);
        int rotationSpeed = ((ValveHandleBlock)AllBlocks.COPPER_VALVE_HANDLE.get()).getRotationSpeed();
        double degreesPerTick = KineticBlockEntity.convertToAngular(rotationSpeed);
        this.inUse = (int)Math.ceil((double)target / degreesPerTick) + 2;
        this.startAngle = (int)(this.independentAngle % 90.0f + 360.0f) % 90;
        this.targetAngle = Math.round((float)(this.startAngle + (target > 135 ? 180 : 90) * class_3532.method_17822((double)value)) / 90.0f) * 90;
        this.totalUseTicks = this.inUse;
        this.backwards = sneak;
        this.sequenceContext = SequencedGearshiftBlockEntity.SequenceContext.fromGearshift(SequencerInstructions.TURN_ANGLE, rotationSpeed, target);
        this.updateGeneratedRotation();
        this.cooldown = 4;
        return true;
    }

    @Override
    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        return CachedBuffers.block((class_2680)this.method_11010());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean shouldRenderShaft() {
        return false;
    }

    public static class ValveHandleScrollValueBehaviour
    extends ScrollValueBehaviour {
        public ValveHandleScrollValueBehaviour(SmartBlockEntity be) {
            super((class_2561)CreateLang.translateDirect("kinetics.valve_handle.rotated_angle", new Object[0]), be, new ValveHandleValueBox());
            this.withFormatter(v -> String.valueOf(Math.abs(v)) + CreateLang.translateDirect("generic.unit.degrees", new Object[0]).getString());
        }

        @Override
        public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
            ImmutableList rows = ImmutableList.of((Object)class_2561.method_43470((String)"\u27f3").method_27692(class_124.field_1067), (Object)class_2561.method_43470((String)"\u27f2").method_27692(class_124.field_1067));
            return new ValueSettingsBoard(this.label, 180, 45, (List<class_2561>)rows, new ValueSettingsFormatter(this::formatValue));
        }

        @Override
        public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlHeld) {
            int value = Math.max(1, valueSetting.value());
            if (!valueSetting.equals(this.getValueSettings())) {
                this.playFeedbackSound(this);
            }
            this.setValue(valueSetting.row() == 0 ? -value : value);
        }

        @Override
        public ValueSettingsBehaviour.ValueSettings getValueSettings() {
            return new ValueSettingsBehaviour.ValueSettings(this.value < 0 ? 0 : 1, Math.abs(this.value));
        }

        public class_5250 formatValue(ValueSettingsBehaviour.ValueSettings settings) {
            return CreateLang.number(Math.max(1, Math.abs(settings.value()))).add(CreateLang.translateDirect("generic.unit.degrees", new Object[0])).component();
        }

        @Override
        public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side, class_3965 hitResult) {
            if (this.getWorld().field_9236) {
                return;
            }
            class_2680 blockState = this.blockEntity.method_11010();
            class_2248 class_22482 = blockState.method_26204();
            if (class_22482 instanceof ValveHandleBlock) {
                ValveHandleBlock vhb = (ValveHandleBlock)class_22482;
                vhb.clicked(this.getWorld(), this.getPos(), blockState, player, hand);
            }
        }
    }

    public static class ValveHandleValueBox
    extends ValueBoxTransform.Sided {
        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return direction == state.method_11654((class_2769)ValveHandleBlock.FACING);
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)4.5);
        }

        @Override
        public boolean testHit(class_1936 level, class_2338 pos, class_2680 state, class_243 localHit) {
            class_243 offset = this.getLocalOffset(level, pos, state);
            if (offset == null) {
                return false;
            }
            return localHit.method_1022(offset) < (double)(this.scale / 1.5f);
        }
    }
}

