/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.vault;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.foundation.utility.SameSizeCombinedInvWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class ItemVaultBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected LazyOptional<IItemHandler> itemCapability;
    protected InventoryIdentifier invId;
    protected ItemStackHandler inventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius;
    protected int length;

    public ItemVaultBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ItemVaultBlockEntity.this.updateComparators();
                ItemVaultBlockEntity.this.f_58857_.m_151543_(ItemVaultBlockEntity.this.f_58858_);
            }
        };
        this.itemCapability = LazyOptional.empty();
        this.radius = 1;
        this.length = 1;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti(this);
    }

    protected void updateComparators() {
        ItemVaultBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.f_58857_.m_151543_(controllerBE.f_58858_);
        BlockPos pos = controllerBE.m_58899_();
        int radius = controllerBE.radius;
        int length = controllerBE.length;
        Direction.Axis axis = controllerBE.getMainConnectionAxis();
        int zMax = axis == Direction.Axis.X ? radius : length;
        int xMax = axis == Direction.Axis.Z ? radius : length;
        BlockPos.MutableBlockPos updatePos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos provokingPos = new BlockPos.MutableBlockPos();
        for (int y = 0; y < radius; ++y) {
            for (int z = 0; z < zMax; ++z) {
                for (int x = 0; x < xMax; ++x) {
                    int sectionZ;
                    int sectionX = SectionPos.m_123171_((int)(pos.m_123341_() + x));
                    if (!this.f_58857_.m_7232_(sectionX, sectionZ = SectionPos.m_123171_((int)(pos.m_123343_() + z)))) continue;
                    provokingPos.m_122154_((Vec3i)pos, x, y, z);
                    Block provokingBlock = this.f_58857_.m_8055_((BlockPos)provokingPos).m_60734_();
                    if (y == 0) {
                        ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.DOWN);
                    }
                    if (y == radius - 1) {
                        ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.UP);
                    }
                    if (z == 0) {
                        ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.NORTH);
                    }
                    if (z == zMax - 1) {
                        ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.SOUTH);
                    }
                    if (x == 0) {
                        ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.WEST);
                    }
                    if (x != xMax - 1) continue;
                    ItemVaultBlockEntity.updateComaratorsInner(this.f_58857_, provokingBlock, (BlockPos)provokingPos, updatePos, Direction.EAST);
                }
            }
        }
    }

    private static void updateComaratorsInner(Level level, Block provokingBlock, BlockPos provokingPos, BlockPos.MutableBlockPos updatePos, Direction direction) {
        updatePos.m_122159_((Vec3i)provokingPos, direction);
        int sectionX = SectionPos.m_123171_((int)updatePos.m_123341_());
        int sectionZ = SectionPos.m_123171_((int)updatePos.m_123343_());
        if (!level.m_7232_(sectionX, sectionZ)) {
            return;
        }
        BlockState blockstate = level.m_8055_((BlockPos)updatePos);
        blockstate.onNeighborChange((LevelReader)level, (BlockPos)updatePos, provokingPos);
        if (blockstate.m_60796_((BlockGetter)level, (BlockPos)updatePos)) {
            updatePos.m_122173_(direction);
            blockstate = level.m_8055_((BlockPos)updatePos);
            if (blockstate.getWeakChanges((LevelReader)level, (BlockPos)updatePos)) {
                level.m_213960_(blockstate, (BlockPos)updatePos, provokingBlock, provokingPos, false);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    @Override
    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    @Override
    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public ItemVaultBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof ItemVaultBlockEntity) {
            return (ItemVaultBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    public void removeController(boolean keepContents) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (ItemVaultBlock.isVault(state)) {
            state = (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    @Override
    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    @Override
    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public InventoryIdentifier getInvId() {
        this.initCapability();
        return this.invId;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            ItemVaultBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            this.invId = controllerBE.invId;
            return;
        }
        boolean alongZ = ItemVaultBlock.getVaultBlockAxis(this.m_58900_()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.f_58858_.m_7918_(xOffset, zOffset, yOffset) : this.f_58858_.m_7918_(yOffset, xOffset, zOffset);
                    ItemVaultBlockEntity vaultAt = (ItemVaultBlockEntity)ConnectivityHandler.partAt((BlockEntityType)AllBlockEntityTypes.ITEM_VAULT.get(), (BlockGetter)this.f_58857_, vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)SameSizeCombinedInvWrapper.create(invs));
        this.itemCapability = LazyOptional.of(() -> ItemVaultBlockEntity.lambda$initCapability$0((IItemHandler)itemHandler));
        BlockPos farCorner = alongZ ? this.f_58858_.m_7918_(this.radius, this.radius, this.length) : this.f_58858_.m_7918_(this.length, this.radius, this.radius);
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)this.f_58858_, (Vec3i)farCorner);
        this.invId = new InventoryIdentifier.Bounds(bounds);
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    @Override
    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    @Override
    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (ItemVaultBlock.isVault(state)) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
    }

    @Override
    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf(this);
    }

    @Override
    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ItemVaultBlockEntity.getMaxLength(width);
    }

    @Override
    public int getMaxWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return this.length;
    }

    @Override
    public int getWidth() {
        return this.radius;
    }

    @Override
    public void setHeight(int height) {
        this.length = height;
    }

    @Override
    public void setWidth(int width) {
        this.radius = width;
    }

    @Override
    public boolean hasInventory() {
        return true;
    }

    private static /* synthetic */ IItemHandler lambda$initCapability$0(IItemHandler itemHandler) {
        return itemHandler;
    }
}

