/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.tunnel;

import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class BrassTunnelItemHandler
implements IItemHandler {
    private BrassTunnelBlockEntity blockEntity;

    public BrassTunnelItemHandler(BrassTunnelBlockEntity be) {
        this.blockEntity = be;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.blockEntity.stackToDistribute;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.blockEntity.hasDistributionBehaviour()) {
            LazyOptional<IItemHandler> beltCapability = this.blockEntity.getBeltCapability();
            if (!beltCapability.isPresent()) {
                return stack;
            }
            return ((IItemHandler)beltCapability.orElse(null)).insertItem(slot, stack, simulate);
        }
        if (!this.blockEntity.canTakeItems()) {
            return stack;
        }
        ItemStack remainder = ItemHelper.limitCountToMaxStackSize(stack, simulate);
        if (!simulate) {
            this.blockEntity.setStackToDistribute(stack, null);
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        LazyOptional<IItemHandler> beltCapability = this.blockEntity.getBeltCapability();
        if (!beltCapability.isPresent()) {
            return ItemStack.f_41583_;
        }
        return ((IItemHandler)beltCapability.orElse(null)).extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.blockEntity.stackToDistribute.m_41619_() ? 64 : this.blockEntity.stackToDistribute.m_41741_();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

