/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.spells;

import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.spells.TargetBlockCastData;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.smeltery.block.entity.CastingBlockEntity;

@AutoSpellConfig
public class FreezeSpell
extends AbstractSpell {
    private final ResourceLocation id = ConstructsCasting.id("freeze");
    private final DefaultConfig config = new DefaultConfig().setMaxLevel(1).setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setCooldownSeconds(7.0).build();

    public FreezeSpell() {
        this.baseManaCost = 50;
        this.castTime = 15;
    }

    public ResourceLocation getSpellResource() {
        return this.id;
    }

    public DefaultConfig getDefaultConfig() {
        return this.config;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FROSTWAVE_PREPARE.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        CastingBlockEntity cbe;
        FluidStack fluidStack;
        BlockHitResult hitResult = Utils.raycastForBlock((Level)level, (Vec3)entity.m_146892_(), (Vec3)entity.m_146892_().m_82549_(entity.m_20154_().m_82490_(4.5)), (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = hitResult.m_82425_();
        playerMagicData.setAdditionalCastData((ICastData)new TargetBlockCastData(pos, hitResult.m_82434_()));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CastingBlockEntity && (fluidStack = (cbe = (CastingBlockEntity)blockEntity).getTank().getFluid()).getAmount() > 0 && fluidStack.getFluid().getFluidType().getTemperature() > 700) {
            return true;
        }
        playerMagicData.resetAdditionalCastData();
        FreezeSpell.sendInvalidMessage((Entity)entity);
        return false;
    }

    private static void sendInvalidMessage(Entity e) {
        if (e instanceof Player) {
            Player player = (Player)e;
            player.m_5661_((Component)Component.m_237115_((String)"spell.constructs_casting.freeze.invalid_target").m_130940_(ChatFormatting.RED), true);
        }
    }

    public SchoolType getSchoolType() {
        return (SchoolType)SchoolRegistry.ICE.get();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        TargetBlockCastData data;
        ConstructsCasting.LOGGER.info("freeze cast");
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetBlockCastData && level.m_7702_((data = (TargetBlockCastData)iCastData).getTargetPos()) instanceof CastingBlockEntity) {
            BlockPos pos = data.getTargetPos();
            CompoundTag tag = level.m_7702_(pos).m_5995_();
            tag.m_128405_("timer", 0x7FFFFFFA);
            level.m_7702_(pos).m_142466_(tag);
            MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.0), (double)((double)pos.m_123343_() + 0.5), (int)15, (double)0.1, (double)0.1, (double)0.1, (double)0.1, (boolean)true);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_RAISED_HAND;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.ANIMATION_INSTANT_CAST;
    }
}

