/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class CastingModifier
extends NoLevelsModifier
implements GeneralInteractionModifierHook {
    protected void registerHooks(ModuleHookMap.Builder builder) {
        builder.addHook((Object)this, ModifierHooks.GENERAL_INTERACT);
    }

    public InteractionResult onToolUse(IToolStackView iToolStackView, ModifierEntry modifierEntry, Player player, InteractionHand interactionHand, InteractionSource interactionSource) {
        String castingSlot;
        if (interactionSource == InteractionSource.LEFT_CLICK) {
            return InteractionResult.FAIL;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        SpellSelectionManager spellSelectionManager = new SpellSelectionManager(player);
        SpellSelectionManager.SelectionOption selectionOption = spellSelectionManager.getSelection();
        if (selectionOption == null || selectionOption.spellData.equals((Object)SpellData.EMPTY)) {
            return InteractionResult.PASS;
        }
        SpellData spellData = selectionOption.spellData;
        if (player.m_9236_().m_5776_()) {
            if (ClientMagicData.isCasting()) {
                return InteractionResult.CONSUME;
            }
            if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellData.getLevel()) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                return InteractionResult.PASS;
            }
            return InteractionResult.CONSUME;
        }
        String string = castingSlot = interactionHand.ordinal() == 0 ? SpellSelectionManager.MAINHAND : SpellSelectionManager.OFFHAND;
        if (spellData.getSpell().attemptInitiateCast(itemStack, spellData.getLevel(), player.m_9236_(), player, selectionOption.getCastSource(), true, castingSlot)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 7200;
    }

    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return UseAnim.BOW;
    }

    public void onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        GeneralInteractionModifierHook.finishUsing((IToolStackView)tool);
        Utils.releaseUsingHelper((LivingEntity)entity, (ItemStack)tool.getItem().m_7968_(), (int)timeLeft);
    }

    public int getPriority() {
        return 150;
    }
}

