/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.modifiers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public class AntifrostModifier
extends Modifier
implements MeleeDamageModifierHook,
TooltipModifierHook {
    private static final float DAMAGE_PER_LEVEL = 3.0f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP);
        super.registerHooks(hookBuilder);
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        return damage + AntifrostModifier.calculateBonus(modifier, context);
    }

    private static float calculateBonus(ModifierEntry modifier, ToolAttackContext context) {
        LivingEntity target = context.getLivingTarget();
        int level = modifier.getLevel();
        boolean isFrozen = target.m_146888_() > target.m_146891_();
        return 3.0f * (float)level * (float)isFrozen;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float dmgBonus = 3.0f * (float)modifier.getLevel();
        tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.BONUS_FORMAT.format(dmgBonus) + " ")).m_7220_((Component)Component.m_237115_((String)"modifier.constructs_casting.antifrost.damage_boost"))));
    }
}

