/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.fluids;

import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.fluids.CCFluidEffects;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.datagen.MantleTags;
import slimeknights.mantle.fluid.UnplaceableFluid;
import slimeknights.mantle.fluid.texture.AbstractFluidTextureProvider;
import slimeknights.mantle.fluid.tooltip.AbstractFluidTooltipProvider;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;
import slimeknights.mantle.registration.object.FlowingFluidObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.data.FluidBucketModelProvider;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;

public class CCFluids {
    public static final FluidDeferredRegister FLUIDS = new FluidDeferredRegister("constructs_casting");
    public static final FluidObject<UnplaceableFluid> arcaneEssence = CCFluids.essence("arcane_essence");
    public static final FluidObject<UnplaceableFluid> fireEssence = CCFluids.essence("fire_essence");
    public static final FluidObject<UnplaceableFluid> iceEssence = CCFluids.essence("ice_essence");
    public static final FluidObject<UnplaceableFluid> lightningEssence = CCFluids.essence("lightning_essence");
    public static final FluidObject<UnplaceableFluid> enderEssence = CCFluids.essence("ender_essence");
    public static final FluidObject<UnplaceableFluid> holyEssence = CCFluids.essence("holy_essence");
    public static final FluidObject<UnplaceableFluid> bloodEssence = CCFluids.essence("blood_essence");
    public static final FluidObject<UnplaceableFluid> evocationEssence = CCFluids.essence("evocation_essence");
    public static final FluidObject<UnplaceableFluid> natureEssence = CCFluids.essence("nature_essence");
    public static final FluidObject<UnplaceableFluid> liquidLightning = FLUIDS.register("liquid_lightning").type(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)).unplacable();
    public static final FluidObject<UnplaceableFluid> cinderEssence = CCFluids.essence("cinder_essence");
    public static FlowingFluidObject<ForgeFlowingFluid> potatoStew = FLUIDS.register("potato_stew").type(CCFluids.cool().temperature(400)).bucket().block(MapColor.f_283864_, 0).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> poisonousPotatoStew = FLUIDS.register("poisonous_potato_stew").type(CCFluids.cool().temperature(400)).bucket().block(MapColor.f_283864_, 0).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> moltenArcanium = FLUIDS.register("molten_arcanium").type(CCFluids.hot()).bucket().block(MapColor.f_283750_, 12).flowing();
    public static FlowingFluidObject<ForgeFlowingFluid> moltenExilite = FLUIDS.register("molten_exilite").type(CCFluids.hot()).bucket().block(MapColor.f_283750_, 12).flowing();
    public static final FluidObject<UnplaceableFluid> squidInk = FLUIDS.register("squid_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/squid").bucket().unplacable();
    public static final FluidObject<UnplaceableFluid> commonInk = FLUIDS.register("common_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/common").bucket().unplacable();
    public static final FluidObject<UnplaceableFluid> uncommonInk = FLUIDS.register("uncommon_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/uncommon").bucket().unplacable();
    public static final FluidObject<UnplaceableFluid> rareInk = FLUIDS.register("rare_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/rare").bucket().unplacable();
    public static final FluidObject<UnplaceableFluid> epicInk = FLUIDS.register("epic_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/epic").bucket().unplacable();
    public static final FluidObject<UnplaceableFluid> legendaryInk = FLUIDS.register("legendary_ink").type(CCFluids.cool().temperature(100)).commonTag("ink/legendary").bucket().unplacable();
    public static final FlowingFluidObject<ForgeFlowingFluid> moltenArcaneSalvage = FLUIDS.register("molten_arcane_salvage").type(CCFluids.hot()).bucket().block(MapColor.f_283919_, 12).flowing();

    public static FluidObject<UnplaceableFluid> getInkFluidForRarity(SpellRarity rarity) {
        return switch (rarity) {
            case SpellRarity.UNCOMMON -> uncommonInk;
            case SpellRarity.RARE -> rareInk;
            case SpellRarity.EPIC -> epicInk;
            case SpellRarity.LEGENDARY -> legendaryInk;
            default -> commonInk;
        };
    }

    public static FluidObject<UnplaceableFluid> essence(String name) {
        return FLUIDS.register(name).bucket().type(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)).unplacable();
    }

    private static FluidType.Properties cool() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_);
    }

    private static FluidType.Properties hot() {
        return FluidType.Properties.create().density(2000).viscosity(10000).temperature(1000).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_);
    }

    @SubscribeEvent
    void registerSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            ConstructsCasting.LOGGER.info("recipe serializer event");
            FluidEffect.ENTITY_EFFECTS.register(ConstructsCasting.id("deplete_mana"), CCFluidEffects.DEPLETE_MANA.getLoader());
            FluidEffect.ENTITY_EFFECTS.register(ConstructsCasting.id("add_mana"), CCFluidEffects.ADD_MANA.getLoader());
        }
    }

    public static class Tags
    extends FluidTagsProvider {
        public static final TagKey<Fluid> MOLTEN_ARCANIUM = FluidTags.create((ResourceLocation)ConstructsCasting.id("molten_arcanium"));
        public static final TagKey<Fluid> MOLTEN_EXILITE = FluidTags.create((ResourceLocation)ConstructsCasting.id("molten_exilite"));
        public static final TagKey<Fluid> POTATO_STEW = FluidTags.create((ResourceLocation)ConstructsCasting.id("potato_stew"));
        public static final TagKey<Fluid> POISONOUS_POTATO_STEW = FluidTags.create((ResourceLocation)ConstructsCasting.id("poisonous_potato_stew"));
        public static final TagKey<Fluid> LIQUID_LIGHTNING = FluidTags.create((ResourceLocation)ConstructsCasting.id("liquid_lightning"));
        public static final TagKey<Fluid> BLOOD_ESSENCE_INGREDIENTS = FluidTags.create((ResourceLocation)ConstructsCasting.id("blood_essence_ingredients"));
        public static final TagKey<Fluid> ARCANIUM_BASE = FluidTags.create((ResourceLocation)ConstructsCasting.id("arcanium_base"));
        public static final TagKey<Fluid> BOTTLE_TOOLTIP = FluidTags.create((ResourceLocation)ConstructsCasting.id("bottle_tooltip"));

        public Tags(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider) {
            super(pOutput, pProvider);
        }

        public static TagKey<Fluid> essenceOf(String type) {
            return FluidTags.create((ResourceLocation)new ResourceLocation("constructs_casting", "essence/" + type));
        }

        public static TagKey<Fluid> ink(String rarity) {
            return FluidTags.create((ResourceLocation)new ResourceLocation("constructs_casting", "ink/" + rarity));
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(MOLTEN_ARCANIUM).m_255245_((Object)moltenArcanium.get());
            this.m_206424_(MOLTEN_EXILITE).m_255245_((Object)moltenExilite.get());
            this.m_206424_(POTATO_STEW).m_255245_((Object)potatoStew.get());
            this.m_206424_(POISONOUS_POTATO_STEW).m_255245_((Object)poisonousPotatoStew.get());
            this.m_206424_(LIQUID_LIGHTNING).m_255245_((Object)liquidLightning.get());
            this.m_206424_(ARCANIUM_BASE).m_255245_((Object)TinkerFluids.moltenCopper.get()).m_255245_((Object)TinkerFluids.moltenIron.get()).m_255245_((Object)TinkerFluids.moltenGold.get());
            this.m_206424_(Tags.essenceOf("arcane")).m_255245_((Object)arcaneEssence.get());
            this.m_206424_(Tags.essenceOf("fire")).m_255245_((Object)fireEssence.get());
            this.m_206424_(Tags.essenceOf("ice")).m_255245_((Object)iceEssence.get());
            this.m_206424_(Tags.essenceOf("lightning")).m_255245_((Object)lightningEssence.get());
            this.m_206424_(Tags.essenceOf("ender")).m_255245_((Object)enderEssence.get());
            this.m_206424_(Tags.essenceOf("holy")).m_255245_((Object)holyEssence.get());
            this.m_206424_(Tags.essenceOf("blood")).m_255245_((Object)bloodEssence.get());
            this.m_206424_(Tags.essenceOf("evocation")).m_255245_((Object)evocationEssence.get());
            this.m_206424_(Tags.essenceOf("nature")).m_255245_((Object)natureEssence.get());
            this.m_206424_(Tags.ink("squid")).m_255245_((Object)squidInk.get());
            this.m_206424_(TagKey.m_203882_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("forge:fluid_type")), (ResourceLocation)new ResourceLocation("forge:ink"))).m_255245_((Object)squidInk.get());
            this.m_206424_(Tags.ink("common")).m_255245_((Object)commonInk.get()).m_176839_(new ResourceLocation("create_wizardry:common_ink"));
            this.m_206424_(Tags.ink("uncommon")).m_255245_((Object)uncommonInk.get()).m_176839_(new ResourceLocation("create_wizardry:uncommon_ink"));
            this.m_206424_(Tags.ink("rare")).m_255245_((Object)rareInk.get()).m_176839_(new ResourceLocation("create_wizardry:rare_ink"));
            this.m_206424_(Tags.ink("epic")).m_255245_((Object)epicInk.get()).m_176839_(new ResourceLocation("create_wizardry:epic_ink"));
            this.m_206424_(Tags.ink("legendary")).m_255245_((Object)legendaryInk.get()).m_176839_(new ResourceLocation("create_wizardry:legendary_ink"));
            this.m_206424_(BLOOD_ESSENCE_INGREDIENTS).m_255245_((Object)TinkerFluids.meatSoup.get()).m_176839_(new ResourceLocation("create_wizardry:blood"));
            this.m_206424_(TinkerTags.Fluids.METAL_TOOLTIPS).m_255245_((Object)moltenArcanium.get()).m_255245_((Object)moltenExilite.get()).m_255245_((Object)moltenArcaneSalvage.get());
            this.m_206424_(BOTTLE_TOOLTIP).m_255245_((Object)arcaneEssence.get()).m_255245_((Object)cinderEssence.get()).m_255245_((Object)fireEssence.get()).m_255245_((Object)iceEssence.get()).m_255245_((Object)lightningEssence.get()).m_255245_((Object)enderEssence.get()).m_255245_((Object)holyEssence.get()).m_255245_((Object)bloodEssence.get()).m_255245_((Object)evocationEssence.get()).m_255245_((Object)natureEssence.get()).m_255245_((Object)liquidLightning.get()).m_255245_((Object)squidInk.get()).m_255245_((Object)commonInk.get()).m_255245_((Object)uncommonInk.get()).m_255245_((Object)rareInk.get()).m_255245_((Object)epicInk.get()).m_255245_((Object)legendaryInk.get());
            this.m_206424_(MantleTags.Fluids.SOUP).m_255245_((Object)potatoStew.get()).m_255245_((Object)poisonousPotatoStew.get());
        }

        public static class CCFluidTooltipProvider
        extends AbstractFluidTooltipProvider {
            public CCFluidTooltipProvider(PackOutput generator, String modId) {
                super(generator, modId);
            }

            protected void addFluids() {
                this.add("bottle", BOTTLE_TOOLTIP).addUnit("bottle", 250);
            }

            public String m_6055_() {
                return "Construct's Casting Fluid Tooltips";
            }
        }
    }

    public static class CCBucketModels
    extends FluidBucketModelProvider {
        public CCBucketModels(PackOutput packOutput, String modId) {
            super(packOutput, modId);
        }
    }

    public static class CCFluidTextures
    extends AbstractFluidTextureProvider {
        public CCFluidTextures(PackOutput generator, @Nullable String modId) {
            super(generator, modId);
        }

        public void addTextures() {
            ResourceLocation potion = new ResourceLocation("tconstruct:fluid/potion/");
            this.texture(arcaneEssence).textures(potion, false, false).color(-8797965);
            this.texture(fireEssence).textures(potion, false, false).color(-224663);
            this.texture(iceEssence).textures(potion, false, false).color(-9047572);
            this.texture(lightningEssence).textures(potion, false, false).color(-8227872);
            this.texture(enderEssence).textures(potion, false, false).color(-2067460);
            this.texture(holyEssence).textures(potion, false, false).color(-202391);
            this.texture(bloodEssence).textures(potion, false, false).color(-2722967);
            this.texture(evocationEssence).textures(potion, false, false).color(-9044871);
            this.texture(natureEssence).textures(potion, false, false).color(-5179287);
            this.texture(cinderEssence).textures(potion, false, false).color(-9819392);
            this.texture(liquidLightning).textures(potion, false, false).color(-2625803);
            this.texture((FluidObject)potatoStew).textures(new ResourceLocation("tconstruct:fluid/food/stew/"), false, false).color(-1459615);
            this.texture((FluidObject)poisonousPotatoStew).textures(new ResourceLocation("tconstruct:fluid/food/stew/"), false, false).color(-1185183);
            this.texture((FluidObject)moltenArcanium).textures(new ResourceLocation("tconstruct:fluid/molten/"), false, false).color(-8797965);
            this.texture((FluidObject)moltenExilite).textures(new ResourceLocation("tconstruct:fluid/molten/"), false, false).color(-10855588);
            this.texture((FluidObject)moltenArcaneSalvage).textures(new ResourceLocation("tconstruct:fluid/molten/"), false, false).color(-1);
            this.texture(squidInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-15204304);
            this.texture(commonInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-13816531);
            this.texture(uncommonInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-15580416);
            this.texture(rareInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-15779772);
            this.texture(epicInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-12309155);
            this.texture(legendaryInk).textures(new ResourceLocation("tconstruct:fluid/slime/venom/"), false, false).color(-2711040);
        }

        public String m_6055_() {
            return "Construct's Casting's Fluid Textures";
        }
    }
}

