/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.snackpirate.constructscasting.fluids.CCFluidEffects;
import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.materials.CCMaterials;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.spells.CCSpells;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class CCLang
extends LanguageProvider {
    public CCLang(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.constructs_casting.constructs_casting", "Construct's Casting");
        this.addMaterial(CCMaterials.arcanium, "Arcanium", "Yer a wizard, Harry!", "Gives the wielder +25 max mana per part.");
        this.addMaterial(CCMaterials.exilite, "Exilite", "#1 Wizard Hater", "Deals greater damage to magic-wielding enemies.");
        this.addMaterial(CCMaterials.arcaneCloth, "Arcane Cloth", "Mage essential!", "Empowers the wielder with greater spell power.");
        this.addMaterial(CCMaterials.frozenBone, "Frozen Bone", "Ice, ice, baby", "Deals greater damage to frozen enemies");
        this.addMaterial(CCMaterials.frostRod, "Frosted", "Cold, cold heart", "Empowers ice-based magic");
        this.add("material.constructs_casting.exilite.armor", "Protects against damage inflicted by spells.");
        this.addMaterial(CCMaterials.hogskin, "Arcane Hide", "", "");
        this.addMaterial(CCMaterials.rainbowSlime, "Rainbowslime", "How are you seeing this?", "Happy pride month!");
        this.addModifier(CCModifiers.CASTING.getId(), "Casting", "Not for fish, unfortunately.", "Allows the tool to cast spells on right click.");
        this.addModifier(CCModifiers.SWIFTCASTING, "Swiftcasting", "Run 'n' Gun!", "Allows the user to retain their full movement speed while casting spells.");
        this.addMaterial(CCMaterials.cosmichalcum, "Cosmichalcum", "Template flavor text", "Template description");
        this.add("constructs_casting.modifier.swiftcasting.requirement", "Requires the Casting ability to be applied first.");
        this.addModifier(CCModifiers.IMBUED.getId(), "Imbued", "", "Allows the tool to be imbued with a spell. Disallowed on swords, since they can already be imbued.");
        this.addModifier(CCModifiers.ENCYCLOPEDIC.getId(), "Encyclopedic", "Well read", "Allows the Slimy Spell Book to function as an encyclopedia.");
        this.addModifier(CCModifiers.ARCANE, "Arcane", "Mana-licious!", "Grants +25 max mana.");
        this.addModifier(CCModifiers.ANTIMAGIC.getId(), "Antimagic", "Self-explanatory.", "Grants +2 damage against magic users.");
        this.add("modifier.constructs_casting.antimagic.damage_boost", "Antimagic Damage");
        this.addModifier(CCModifiers.SPELL_PROTECTION, "Spell Protection", "Diabolical!", "Grants +10% resistance against spells. (Different from Magic Protection)");
        this.add("modifier.constructs_casting.spell_protection.resistance", "Spell Resistance");
        this.addModifier(CCModifiers.ANTIFROST.getId(), "Antifrost", "Don't drink it!", "Grants +3 damage per level to frozen targets.");
        this.add("modifier.constructs_casting.antifrost.damage_boost", "Antifrost Damage");
        this.addModifier(CCModifiers.SPELLBOUND, "Spellbound", "Jack of all trades!", "Grants +7.5% power to all types of spells.");
        this.addModifier(CCModifiers.MANA_UPGRADE, "Mana Upgrade", "Mana-rific!", "Grants +80 max mana.");
        this.addModifier(CCModifiers.COOLDOWN_UPGRADE, "Cooldown Upgrade", "I am speed!", "Grants +8% Cooldown Reduction.");
        this.addModifier(CCModifiers.FIRE_UPGRADE, "Fire Upgrade", "Hot hot hot!", "Grants +5% Fire Spell Power.");
        this.addModifier(CCModifiers.ICE_UPGRADE, "Ice Upgrade", "Ice ice baby!", "Grants +5% Ice Spell Power.");
        this.addModifier(CCModifiers.LIGHTNING_UPGRADE, "Lightning Upgrade", "Electrifying!", "Grants +5% Lightning Spell Power.");
        this.addModifier(CCModifiers.ENDER_UPGRADE, "Ender Upgrade", "Space-y!", "Grants +5% Ender Spell Power.");
        this.addModifier(CCModifiers.HOLY_UPGRADE, "Holy Upgrade", "Great heavens!", "Grants +5% Holy Spell Power.");
        this.addModifier(CCModifiers.BLOOD_UPGRADE, "Blood Upgrade", "Bloody hell!", "Grants +5% Blood Spell Power.");
        this.addModifier(CCModifiers.EVOCATION_UPGRADE, "Evocation Upgrade", "Hrmmm?", "Grants +5% Evocation Spell Power.");
        this.addModifier(CCModifiers.NATURE_UPGRADE, "Nature Upgrade", "All natural!", "Grants +5% Nature Spell Power.");
        this.addModifier(CCModifiers.ELDRITCH_UPGRADE, "Eldritch Upgrade", "Man-made modifiers beyond your comprehension", "Grants +5% Eldritch Spell Power");
        this.addFluid(CCFluids.arcaneEssence, "Arcane Essence");
        this.addFluid(CCFluids.fireEssence, "Fire Essence");
        this.addFluid(CCFluids.iceEssence, "Ice Essence");
        this.addFluid(CCFluids.lightningEssence, "Lightning Essence");
        this.addFluid(CCFluids.enderEssence, "Ender Essence");
        this.addFluid(CCFluids.holyEssence, "Holy Essence");
        this.addFluid(CCFluids.bloodEssence, "Blood Essence");
        this.addFluid(CCFluids.evocationEssence, "Evocation Essence");
        this.addFluid(CCFluids.natureEssence, "Nature Essence");
        this.addFluid(CCFluids.cinderEssence, "Cinder Essence");
        this.addFluid(CCFluids.liquidLightning, "Lightning");
        this.addFluid((FluidObject<?>)CCFluids.potatoStew, "Potato Stew");
        this.addFluid((FluidObject<?>)CCFluids.poisonousPotatoStew, "Poisonous Potato Stew");
        this.addFluid((FluidObject<?>)CCFluids.moltenArcanium, "Molten Arcanium");
        this.addFluid((FluidObject<?>)CCFluids.moltenExilite, "Molten Exilite");
        this.addFluid((FluidObject<?>)CCFluids.moltenArcaneSalvage, "Molten Arcane Salvage");
        this.addFluid(CCFluids.squidInk, "Squid Ink");
        this.addFluid(CCFluids.commonInk, "Common Ink");
        this.addFluid(CCFluids.uncommonInk, "Uncommon Ink");
        this.addFluid(CCFluids.rareInk, "Rare Ink");
        this.addFluid(CCFluids.epicInk, "Epic Ink");
        this.addFluid(CCFluids.legendaryInk, "Legendary Ink");
        this.addItem((Supplier)CCItems.potatoStewBowl, "Potato Stew");
        this.addItem((Supplier)CCItems.poisonousPotatoStewBowl, "Poisonous Potato Stew");
        this.addItem((Supplier)CCItems.exiliteIngot, "Exilite Ingot");
        this.addItem((Supplier)CCItems.exiliteNugget, "Exilite Nugget");
        this.addItem((Supplier)CCItems.exiliteReinforcement, "Exilite Reinforcement");
        this.addItem((Supplier)CCItems.travellersSpellbook, "Traveller's Spell Book");
        this.addItem((Supplier)CCItems.platedSpellbook, "Plated Spell Book");
        this.addItem((Supplier)CCItems.slimySpellbook, "Slimy Spell Book");
        this.addItem((Supplier)CCItems.eldritchStaff, "Sculk Staff");
        this.add("gui.constructs_casting.fluid.bottle", "%s Bottles");
        this.addItem((Supplier)CCItems.wizardslimeBall, "Wizardslime Ball");
        this.add("school.constructs_casting.slime", "Slime");
        this.addSpell((Supplier<AbstractSpell>)CCSpells.FREEZE_SPELL, "Freeze", "Rapidly cools down the targeted Casting Table or Basin, instantly finishing the casting process. Only works on molten metals.");
        this.add("spell.constructs_casting.freeze.invalid_target", "Invalid target!");
        this.add("ui.constructs_casting.slimeball.max_bounces", "%s Bounces");
        this.add("ui.constructs_casting.enderference_anti_teleport", "Your current affliction prevents you from teleporting...");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.bloodEmpowerment, "Blood Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.enderEmpowerment, "Ender Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.evocationEmpowerment, "Evocation Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.fireEmpowerment, "Fire Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.holyEmpowerment, "Holy Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.iceEmpowerment, "Ice Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.lightningEmpowerment, "Lightning Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.natureEmpowerment, "Nature Empowerment");
        this.addEffect((Supplier)CCFluidEffects.MobEffects.recoveryEmpowerment, "Recovery Empowerment");
    }

    public void addMaterial(MaterialId material, String name, String flavour, String desc) {
        String id = material.m_135815_();
        this.add("material.constructs_casting." + id, name);
        if (!flavour.isEmpty()) {
            this.add("material.constructs_casting." + id + ".flavor", flavour);
        }
        if (!desc.isEmpty()) {
            this.add("material.constructs_casting." + id + ".encyclopedia", desc);
        }
    }

    public void addModifier(ModifierId modifier, String name, String flavour, String desc) {
        String id = modifier.m_135815_();
        this.add("modifier.constructs_casting." + id, name);
        this.add("modifier.constructs_casting." + id + ".flavor", flavour);
        this.add("modifier.constructs_casting." + id + ".description", desc);
    }

    public void addFluid(FluidObject<?> fluid, String name) {
        this.add("fluid_type.constructs_casting." + fluid.getId().m_135815_(), name);
        this.add("item.constructs_casting." + fluid.getId().m_135815_() + "_bucket", name + " Bucket");
    }

    public void addSpell(Supplier<AbstractSpell> spell, String name, String desc) {
        this.add("spell.constructs_casting." + spell.get().getSpellName(), name);
        this.add("spell.constructs_casting." + spell.get().getSpellName() + ".guide", desc);
    }
}

