/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.spells.CCEntities;
import com.snackpirate.constructscasting.spells.slime.slimeball.SlimeballProjectileRenderer;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.render.SpellBookCurioRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.util.ConstantFluidContainerWrapper;
import slimeknights.tconstruct.library.events.ToolEquipmentChangeEvent;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CCEvents {
    private static AttachCapabilitiesEvent<ItemStack> event;

    @SubscribeEvent
    static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        CCEvents.event = event;
        ItemStack stack = (ItemStack)event.getObject();
        CCEvents.itemPouring(stack, (Item)ItemRegistry.LIGHTNING_BOTTLE.get(), CCFluids.liquidLightning, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(stack, (Item)ItemRegistry.INK_COMMON.get(), CCFluids.commonInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(stack, (Item)ItemRegistry.INK_UNCOMMON.get(), CCFluids.uncommonInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(stack, (Item)ItemRegistry.INK_RARE.get(), CCFluids.rareInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(stack, (Item)ItemRegistry.INK_EPIC.get(), CCFluids.epicInk, 250, Items.f_42590_.m_7968_());
        CCEvents.itemPouring(stack, (Item)ItemRegistry.INK_LEGENDARY.get(), CCFluids.legendaryInk, 250, Items.f_42590_.m_7968_());
    }

    public static void itemPouring(ItemStack itemStack, Item input, FluidObject<? extends Fluid> fluidObject, int amount, ItemStack output) {
        if (itemStack.m_41720_().equals(input)) {
            event.addCapability(fluidObject.getId(), (ICapabilityProvider)new ConstantFluidContainerWrapper(new FluidStack(fluidObject.get(), amount), itemStack, output));
        }
    }

    @SubscribeEvent
    static void enderferenceAntiSpell(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity.m_21023_((MobEffect)TinkerEffects.enderference.get())) {
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 2.0f, 0.2f + Utils.random.m_188501_() * 0.2f);
            entity.m_5661_((Component)Component.m_237115_((String)"ui.constructs_casting.enderference_anti_teleport").m_130940_(ChatFormatting.RED), true);
            String spellId = event.getSpellId();
            event.setCanceled(spellId.equals("irons_spellbooks:teleport") || spellId.equals("irons_spellbooks:blood_step") || spellId.equals("irons_spellbooks:frost_step"));
        }
    }

    @SubscribeEvent
    static void imbueSlotOnSwords(ToolEquipmentChangeEvent event) {
        ItemStack replacement = event.getContext().getReplacement();
        if (replacement.m_41720_() instanceof ModifiableSwordItem && !ISpellContainer.isSpellContainer((ItemStack)replacement)) {
            ISpellContainer container = ISpellContainer.create((int)1, (boolean)true, (boolean)false);
            container.save(replacement);
        } else {
            ModifiableArmorItem armor;
            Item container = replacement.m_41720_();
            if (container instanceof ModifiableArmorItem && (armor = (ModifiableArmorItem)container).m_40402_() == EquipmentSlot.CHEST && !ISpellContainer.isSpellContainer((ItemStack)replacement)) {
                container = ISpellContainer.create((int)1, (boolean)true, (boolean)true);
                container.save(replacement);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModClientEvents {
        @SubscribeEvent
        static void registerCurioRenderers(FMLClientSetupEvent e) {
            CuriosRendererRegistry.register((Item)((Item)CCItems.slimySpellbook.get()), SpellBookCurioRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)CCItems.platedSpellbook.get()), SpellBookCurioRenderer::new);
        }

        @SubscribeEvent
        static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)CCEntities.SLIMEBALL_PROJECTILE.get(), SlimeballProjectileRenderer::new);
        }
    }

    @Mod.EventBusSubscriber(modid="constructs_casting", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        static void swiftcastingHandleInput(MovementInputUpdateEvent event) {
            if (ClientMagicData.isCasting() && ModifierUtil.getModifierLevel((ItemStack)event.getEntity().m_21120_(InteractionHand.MAIN_HAND), (ModifierId)CCModifiers.SWIFTCASTING) > 0) {
                event.getInput().f_108566_ *= 5.0f;
                event.getInput().f_108567_ *= 5.0f;
            }
        }
    }
}

