/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatstructures.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Supplier;
import net.fixerlink.compatstructures.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.fml.ModList;

public class ConditionalJigsawStructure
extends Structure {
    private final Holder<StructureTemplatePool> startPool;
    private final boolean enabled;
    private final StructureType<?> type;
    private final VerticalAnchor startHeight;
    private final Optional<Heightmap.Types> projectToHeightmap;

    public ConditionalJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, boolean enabled, StructureType<?> type, VerticalAnchor startHeight, Optional<Heightmap.Types> projectToHeightmap) {
        super(settings);
        this.startPool = startPool;
        this.enabled = enabled;
        this.type = type;
        this.startHeight = startHeight;
        this.projectToHeightmap = projectToHeightmap;
    }

    public static Codec<ConditionalJigsawStructure> createCodec(String modId, Supplier<StructureType<ConditionalJigsawStructure>> typeSupplier) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.f_226688_.fieldOf("settings").forGetter(s -> s.getModifiedStructureSettings()), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(s -> s.getStartPool()), (App)VerticalAnchor.f_158914_.fieldOf("start_height").forGetter(s -> s.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(s -> s.projectToHeightmap)).apply((Applicative)instance, (arg_0, arg_1, arg_2, arg_3) -> ConditionalJigsawStructure.lambda$createCodec$4(modId, (Supplier)typeSupplier, arg_0, arg_1, arg_2, arg_3)));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!this.enabled) {
            return Optional.empty();
        }
        int hardBlocks = Config.spawnExclusionRadius();
        int softBlocks = Config.spawnSoftRadius();
        float baseChance = Config.baseSpawnChance();
        if (hardBlocks > 0) {
            int cx = context.f_226628_().f_45578_;
            int cz = context.f_226628_().f_45579_;
            double dChunks = Math.hypot(cx, cz);
            int hardChunks = hardBlocks >> 4;
            int softChunks = Math.max(softBlocks >> 4, hardChunks);
            if (dChunks < (double)hardChunks) {
                return Optional.empty();
            }
            float chance = baseChance;
            if (dChunks < (double)softChunks) {
                double t = (dChunks - (double)hardChunks) / Math.max(1.0, (double)(softChunks - hardChunks));
                chance = (float)((double)baseChance * t);
            }
            if (context.f_226626_().m_188501_() > chance) {
                return Optional.empty();
            }
        } else if (context.f_226626_().m_188501_() > baseChance) {
            return Optional.empty();
        }
        WorldGenerationContext worldGenContext = new WorldGenerationContext(context.f_226622_(), context.f_226629_());
        BlockPos origin = new BlockPos(context.f_226628_().m_45604_() + 8, this.startHeight.m_142322_(worldGenContext), context.f_226628_().m_45605_() + 8);
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)1, (BlockPos)origin, (boolean)false, this.projectToHeightmap, (int)80);
    }

    public StructureType<?> m_213658_() {
        return this.type;
    }

    public Holder<StructureTemplatePool> getStartPool() {
        return this.startPool;
    }

    private static /* synthetic */ ConditionalJigsawStructure lambda$createCodec$4(String modId, Supplier typeSupplier, Structure.StructureSettings settings, Holder pool, VerticalAnchor height, Optional heightmap) {
        boolean isModLoaded = ModList.get().isLoaded(modId);
        boolean isEnabledByConfig = Config.isEnabled(modId);
        return new ConditionalJigsawStructure(settings, (Holder<StructureTemplatePool>)pool, isModLoaded && isEnabledByConfig, (StructureType)typeSupplier.get(), height, heightmap);
    }
}

