/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatdelight.compat.botaniadelight.item.tier;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaItem;

public class ManaKnifeItem
extends SwordItem
implements ManaItem {
    private static final int MANA_PER_DAMAGE = 100;
    private int mana;
    private final int maxMana;

    public ManaKnifeItem(Tiers tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties, int maxMana) {
        super((Tier)tier, attackDamageModifier, attackSpeedModifier, properties);
        this.maxMana = maxMana;
        this.mana = 0;
    }

    public int getMana() {
        return this.mana;
    }

    public int getMaxMana() {
        return this.maxMana;
    }

    public void addMana(int amount) {
        this.mana = Math.min(this.mana + amount, this.maxMana);
    }

    public boolean canReceiveManaFromPool(BlockEntity pool) {
        return true;
    }

    public boolean canReceiveManaFromItem(ItemStack stack) {
        return true;
    }

    public boolean canExportManaToPool(BlockEntity pool) {
        return false;
    }

    public boolean canExportManaToItem(ItemStack stack) {
        return false;
    }

    public boolean isNoExport() {
        return true;
    }

    public void repairWithMana(ItemStack stack) {
        if (stack.m_41768_() && this.mana > 0) {
            int damageToRepair = Math.min(stack.m_41773_(), this.mana / 100);
            stack.m_41721_(stack.m_41773_() - damageToRepair);
            this.mana -= damageToRepair * 100;
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!level.f_46443_ && stack.m_41768_()) {
            this.repairWithMana(stack);
        }
    }
}

