/*
 * Decompiled with CFR 0.152.
 */
package com.Portality.ccomunityboxes.mixins;

import com.Portality.ccomunityboxes.fluid.ModFluids;
import com.Portality.ccomunityboxes.painter.PainterBE;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpoutBlockEntity.class})
public abstract class MixinSpoutBe {
    @Shadow(remap=false)
    private int processingTicks;
    @Shadow
    private SmartFluidTankBehaviour tank;
    @Shadow
    @Final
    public static int FILLING_TIME;

    @Shadow
    protected abstract FluidStack getCurrentFluidInTank();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tick(CallbackInfo ci) {
        BlockPos filling;
        BlockEntity blockEntity;
        SpoutBlockEntity be = (SpoutBlockEntity)this;
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (this.processingTicks == -1 && (be.isVirtual() || !level.m_5776_()) && (blockEntity = level.m_7702_(filling = pos.m_7495_())) instanceof PainterBE) {
            PainterBE painterBE = (PainterBE)blockEntity;
            if (currentFluidInTank.getFluid().getFluidType() == Fluids.f_76193_.getFluidType() && currentFluidInTank.getAmount() >= 500) {
                this.splash(pos, level, currentFluidInTank, (BlockEntity)be, painterBE, false);
            } else if (currentFluidInTank.getFluid().getFluidType() == ModFluids.INK_TYPE.get() && currentFluidInTank.getAmount() >= 100) {
                this.splash(pos, level, currentFluidInTank, (BlockEntity)be, painterBE, true);
            }
        }
    }

    private void splash(BlockPos pos, Level level, FluidStack currentFluidInTank, BlockEntity be, PainterBE painterBE, boolean rareMode) {
        if (painterBE.craftProgress == 5) {
            if (rareMode) {
                painterBE.splashed = true;
                painterBE.rareSplashed = true;
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - 100)));
            } else {
                painterBE.splashed = true;
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)currentFluidInTank, (int)(currentFluidInTank.getAmount() - 500)));
            }
            this.processingTicks = FILLING_TIME;
            AllSoundEvents.SPOUTING.playOnServer(level, (Vec3i)pos);
            ((SpoutBlockEntity)be).notifyUpdate();
        }
    }
}

