/*
 * Decompiled with CFR 0.152.
 */
package net.mattias.capybara.core.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mattias.capybara.core.entity.animations.CapybaraAnimations;
import net.mattias.capybara.core.entity.custom.CapybaraEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CapybaraModel<T extends CapybaraEntity>
extends HierarchicalModel<T> {
    private final ModelPart Capybara;
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Legs;
    private final ModelPart backLegs;
    private final ModelPart backlegLeft;
    private final ModelPart backlegRight;
    private final ModelPart frontLegs;
    private final ModelPart frontlegRight;
    private final ModelPart frontlegLeft;
    private final ModelPart bone;
    private final ModelPart bone2;

    public CapybaraModel(ModelPart root) {
        this.Capybara = root.m_171324_("Capybara");
        this.Body = this.Capybara.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.Legs = this.Body.m_171324_("Legs");
        this.backLegs = this.Legs.m_171324_("backLegs");
        this.backlegLeft = this.backLegs.m_171324_("backlegLeft");
        this.backlegRight = this.backLegs.m_171324_("backlegRight");
        this.frontLegs = this.Legs.m_171324_("frontLegs");
        this.frontlegRight = this.frontLegs.m_171324_("frontlegRight");
        this.frontlegLeft = this.frontLegs.m_171324_("frontlegLeft");
        this.bone = this.Body.m_171324_("bone");
        this.bone2 = this.Body.m_171324_("bone2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Capybara2 = partdefinition.m_171599_("Capybara", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)20.0f, (float)-3.0f));
        PartDefinition Body = Capybara2.m_171599_("Body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)-8.5f, (float)2.5f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(1, 30).m_171488_(-2.6631f, -3.5f, -8.8333f, 6.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(100, 6).m_171488_(-2.6631f, -9.5f, -2.8333f, 6.0f, 7.0f, 5.0f, new CubeDeformation(-0.01f)).m_171514_(17, 48).m_171488_(-2.6631f, -5.5f, 1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(23, 48).m_171488_(1.3369f, -5.5f, 1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.3369f, (float)-6.0f, (float)-1.8922f));
        PartDefinition Legs = Body.m_171599_("Legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)10.5f, (float)0.5f));
        PartDefinition backLegs = Legs.m_171599_("backLegs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-6.0f, (float)0.0f, (float)10.0f));
        PartDefinition backlegLeft = backLegs.m_171599_("backlegLeft", CubeListBuilder.m_171558_().m_171514_(35, 46).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)1.0f));
        PartDefinition backlegRight = backLegs.m_171599_("backlegRight", CubeListBuilder.m_171558_().m_171514_(1, 48).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-2.0f, (float)1.0f));
        PartDefinition frontLegs = Legs.m_171599_("frontLegs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontlegRight = frontLegs.m_171599_("frontlegRight", CubeListBuilder.m_171558_().m_171514_(35, 38).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition frontlegLeft = frontLegs.m_171599_("frontlegLeft", CubeListBuilder.m_171558_().m_171514_(35, 30).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-2.0f, (float)0.0f));
        PartDefinition bone = Body.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(1, 0).m_171488_(-6.0f, -4.5f, -3.5f, 12.0f, 13.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 87).m_171488_(-5.0f, -3.5f, -2.5f, 10.0f, 12.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(30, 38).m_171488_(6.0f, 8.5f, -3.5f, 0.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(36, 62).m_171488_(-6.0f, 8.49f, -3.49f, 12.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(35, 60).m_171488_(-6.0f, 8.5f, 13.51f, 12.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(30, 40).m_171488_(-6.0f, 8.5f, -3.5f, 0.0f, 2.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone2 = Body.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(71, 118).m_171488_(-5.0f, -1.5f, -2.5f, 10.0f, 6.0f, 4.0f, new CubeDeformation(0.1f)).m_171514_(112, 117).m_171488_(-8.0f, -1.0f, -3.0f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(37, 117).m_171488_(5.0f, -1.0f, -3.0f, 3.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(CapybaraEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.m_6162_()) {
            float headScale;
            this.Head.f_233553_ = headScale = 1.45f;
            this.Head.f_233554_ = headScale;
            this.Head.f_233555_ = headScale;
        } else {
            this.Head.f_233553_ = 1.0f;
            this.Head.f_233554_ = 1.0f;
            this.Head.f_233555_ = 1.0f;
        }
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        if (entity.isSitting()) {
            this.m_233385_(entity.idleAnimationState, CapybaraAnimations.Sit, ageInTicks, 1.0f);
        } else {
            this.m_267799_(CapybaraAnimations.Walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            this.m_233385_(entity.idleAnimationState, CapybaraAnimations.Idle, ageInTicks, 1.0f);
        }
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.Head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.Head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Capybara.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.Capybara;
    }

    public ModelPart getHead() {
        return this.Head;
    }

    public ModelPart getBody() {
        return this.Body;
    }
}

