/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.world.tick_scheduler;

import com.abdelaziz.canary.common.world.scheduler.OrderedTickQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ReferenceAVLTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelChunkTicks.class})
public class LevelChunkTicksMixin<T> {
    private static volatile Reference2IntOpenHashMap<Object> TYPE_2_INDEX = new Reference2IntOpenHashMap();
    private final Long2ReferenceAVLTreeMap<OrderedTickQueue<T>> tickQueuesByTimeAndPriority = new Long2ReferenceAVLTreeMap();
    private OrderedTickQueue<T> nextTickQueue;
    private final IntOpenHashSet allTicks = new IntOpenHashSet();
    @Shadow
    @Nullable
    private BiConsumer<LevelChunkTicks<T>, ScheduledTick<T>> f_193166_;
    @Mutable
    @Shadow
    @Final
    private Set<ScheduledTick<?>> f_193165_;
    @Shadow
    @Nullable
    private List<SavedTick<T>> f_193164_;
    @Mutable
    @Shadow
    @Final
    private Queue<ScheduledTick<T>> f_193163_;

    @Inject(method={"<init>()V", "<init>(Ljava/util/List;)V"}, at={@At(value="RETURN")})
    private void reinit(CallbackInfo ci) {
        if (this.f_193164_ != null) {
            for (SavedTick<T> orderedTick : this.f_193164_) {
                this.allTicks.add(LevelChunkTicksMixin.tickToInt(orderedTick.f_193312_(), orderedTick.f_193311_()));
            }
        }
        this.f_193165_ = null;
        this.f_193163_ = null;
    }

    private static int tickToInt(BlockPos pos, Object type) {
        int typeIndex = TYPE_2_INDEX.getInt(type);
        if (typeIndex == -1) {
            typeIndex = LevelChunkTicksMixin.fixMissingType2Index(type);
        }
        int ret = (pos.m_123341_() & 0xF) << 16 | (pos.m_123342_() & 0xFFF) << 4 | pos.m_123343_() & 0xF;
        return ret |= typeIndex << 20;
    }

    private static synchronized int fixMissingType2Index(Object type) {
        int typeIndex = TYPE_2_INDEX.getInt(type);
        if (typeIndex == -1) {
            Reference2IntOpenHashMap clonedType2Index = TYPE_2_INDEX.clone();
            typeIndex = clonedType2Index.size();
            clonedType2Index.put(type, typeIndex);
            TYPE_2_INDEX = clonedType2Index;
            if (typeIndex >= 4096) {
                throw new IllegalStateException("Canary Tick Scheduler assumes at most 4096 different block types that receive scheduled ticks exist! Add mixin.world.tick_scheduler=false to the lithium properties/config to disable the optimization!");
            }
        }
        return typeIndex;
    }

    @Overwrite
    public void m_183393_(ScheduledTick<T> orderedTick) {
        int intTick = LevelChunkTicksMixin.tickToInt(orderedTick.f_193377_(), orderedTick.f_193376_());
        if (this.allTicks.add(intTick)) {
            this.queueTick(orderedTick);
        }
    }

    private static long getBucketKey(long time, TickPriority priority) {
        return time << 4 | (long)(priority.ordinal() & 0xF);
    }

    private void updateNextTickQueue(boolean checkEmpty) {
        OrderedTickQueue removed;
        if (checkEmpty && this.nextTickQueue != null && this.nextTickQueue.isEmpty() && (removed = (OrderedTickQueue)this.tickQueuesByTimeAndPriority.remove(this.tickQueuesByTimeAndPriority.firstLongKey())) != this.nextTickQueue) {
            throw new IllegalStateException("Next tick queue doesn't have the lowest key!");
        }
        if (this.tickQueuesByTimeAndPriority.isEmpty()) {
            this.nextTickQueue = null;
            return;
        }
        long firstKey = this.tickQueuesByTimeAndPriority.firstLongKey();
        this.nextTickQueue = (OrderedTickQueue)this.tickQueuesByTimeAndPriority.get(firstKey);
    }

    @Overwrite
    @Nullable
    public ScheduledTick<T> m_193189_() {
        if (this.nextTickQueue == null) {
            return null;
        }
        return this.nextTickQueue.peek();
    }

    @Overwrite
    @Nullable
    public ScheduledTick<T> m_193195_() {
        ScheduledTick<T> orderedTick = this.nextTickQueue.poll();
        if (orderedTick != null) {
            if (this.nextTickQueue.isEmpty()) {
                this.updateNextTickQueue(true);
            }
            this.allTicks.remove(LevelChunkTicksMixin.tickToInt(orderedTick.f_193377_(), orderedTick.f_193376_()));
            return orderedTick;
        }
        return null;
    }

    private void queueTick(ScheduledTick<T> orderedTick) {
        OrderedTickQueue tickQueue = (OrderedTickQueue)this.tickQueuesByTimeAndPriority.computeIfAbsent(LevelChunkTicksMixin.getBucketKey(orderedTick.f_193378_(), orderedTick.f_193379_()), key -> new OrderedTickQueue());
        if (tickQueue.isEmpty()) {
            this.updateNextTickQueue(false);
        }
        tickQueue.offer(orderedTick);
        if (this.f_193166_ != null) {
            this.f_193166_.accept((LevelChunkTicks)this, orderedTick);
        }
    }

    @Overwrite
    public boolean m_183582_(BlockPos pos, T type) {
        return this.allTicks.contains(LevelChunkTicksMixin.tickToInt(pos, type));
    }

    @Overwrite
    public void m_193183_(Predicate<ScheduledTick<T>> predicate) {
        ObjectIterator tickQueueIterator = this.tickQueuesByTimeAndPriority.values().iterator();
        while (tickQueueIterator.hasNext()) {
            OrderedTickQueue nextTickQueue = (OrderedTickQueue)tickQueueIterator.next();
            nextTickQueue.sort();
            boolean removed = false;
            for (int i = 0; i < nextTickQueue.size(); ++i) {
                ScheduledTick nextTick = nextTickQueue.getTickAtIndex(i);
                if (!predicate.test(nextTick)) continue;
                nextTickQueue.setTickAtIndex(i, null);
                this.allTicks.remove(LevelChunkTicksMixin.tickToInt(nextTick.f_193377_(), nextTick.f_193376_()));
                removed = true;
            }
            if (removed) {
                nextTickQueue.removeNullsAndConsumed();
            }
            if (!nextTickQueue.isEmpty()) continue;
            tickQueueIterator.remove();
        }
        this.updateNextTickQueue(false);
    }

    @Overwrite
    public Stream<ScheduledTick<T>> m_193196_() {
        return this.tickQueuesByTimeAndPriority.values().stream().flatMap(Collection::stream);
    }

    @Overwrite
    public int m_183574_() {
        return this.allTicks.size();
    }

    @Overwrite
    public ListTag m_183237_(long l, Function<T, String> function) {
        ListTag nbtList = new ListTag();
        if (this.f_193164_ != null) {
            for (SavedTick savedTick : this.f_193164_) {
                nbtList.add((Object)savedTick.m_193343_(function));
            }
        }
        for (OrderedTickQueue orderedTickQueue : this.tickQueuesByTimeAndPriority.values()) {
            for (ScheduledTick orderedTick : orderedTickQueue) {
                nbtList.add((Object)SavedTick.m_193331_(orderedTick, function, (long)l));
            }
        }
        return nbtList;
    }

    @Overwrite
    public void m_193171_(long time) {
        if (this.f_193164_ != null) {
            int i = -this.f_193164_.size();
            for (SavedTick<T> tick : this.f_193164_) {
                this.queueTick(tick.m_193328_(time, (long)i++));
            }
        }
        this.f_193164_ = null;
    }

    static {
        TYPE_2_INDEX.defaultReturnValue(-1);
    }
}

