/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.util;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.LastMessageHolder;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.level.ChunkPos;

public class ModUtils {
    public static void displayTeamName(ServerPlayer player, ChunkPos pos) {
        Component greeting;
        Component lastMessage;
        if (!(player instanceof LastMessageHolder)) {
            return;
        }
        LastMessageHolder holder = (LastMessageHolder)player;
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), player.m_146902_());
        Component displayName = null;
        if (claimData != null) {
            displayName = TeamHelper.getTeamName((String)claimData.getFirst(), player.f_8924_);
        }
        if ((lastMessage = holder.cadmus$getLastMessage()) == null && !(greeting = (Component)AdminClaimHandler.getFlag((ServerLevel)player.m_9236_(), player.m_146902_(), "greeting")).getString().isBlank()) {
            player.m_5661_(greeting, false);
        }
        if (Objects.equals(displayName, lastMessage)) {
            return;
        }
        holder.cadmus$setLastMessage(displayName);
        if (displayName == null) {
            player.m_5661_(ConstantComponents.WILDERNESS, true);
            Component farewell = (Component)AdminClaimHandler.getFlag(player.m_284548_(), pos, "farewell");
            if (!farewell.getString().isBlank()) {
                player.m_5661_(farewell, false);
            }
        } else {
            boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
            ChatFormatting teamColor = TeamHelper.getTeamColor((String)claimData.getFirst(), player.m_20194_());
            ChatFormatting color = isMember ? teamColor : ChatFormatting.DARK_RED;
            player.m_5661_((Component)displayName.m_6881_().m_130940_(color), true);
        }
    }

    public static GameProfileCache getProfileCache(MinecraftServer server) {
        return Objects.requireNonNull(server.m_129927_());
    }

    public static Component translatableWithStyle(String key, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            ChatFormatting color;
            MutableComponent component;
            Object object = args[i];
            if (!(object instanceof MutableComponent) || (component = (MutableComponent)object).m_7383_().m_131135_() == null || (color = ChatFormatting.m_126657_((String)component.m_7383_().m_131135_().toString())) == null) continue;
            args[i] = "\u00a7" + color.m_178510_() + component.getString();
        }
        return Component.m_237113_((String)CommonUtils.serverTranslatable((String)key, (Object[])args).getString());
    }

    public static boolean isAdmin(String id) {
        return id.charAt(0) == 'a';
    }

    public static boolean isPlayer(String id) {
        return id.charAt(0) == 'p';
    }

    public static boolean isTeam(String id) {
        return id.charAt(0) == 't';
    }
}

