/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProviderApi;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import earth.terrarium.cadmus.common.claims.ClaimSettings;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CadmusDataHandler
extends SaveHandler {
    private final Map<String, IntIntPair> maxClaimsById = new HashMap<String, IntIntPair>();
    private final Map<String, ClaimSettings> settings = new HashMap<String, ClaimSettings>();
    private final Set<UUID> bypassPlayers = new HashSet<UUID>();
    private ClaimSettings defaultSettings = ClaimSettings.ofFalse();
    private final Map<String, Set<ResourceLocation>> allowedBlocks = new HashMap<String, Set<ResourceLocation>>();

    public void loadData(CompoundTag tag) {
        String maxClaimProvider;
        CompoundTag maxClaimsTag = tag.m_128469_("max_claims");
        maxClaimsTag.m_128431_().forEach(id -> {
            CompoundTag maxClaimTag = maxClaimsTag.m_128469_(id);
            int maxClaims = maxClaimTag.m_128451_("maxClaims");
            int maxChunkLoaded = maxClaimTag.m_128451_("maxChunkLoaded");
            this.maxClaimsById.put((String)id, IntIntPair.of((int)maxClaims, (int)maxChunkLoaded));
        });
        CompoundTag settings = tag.m_128469_("settings");
        settings.m_128431_().forEach(id -> this.settings.put((String)id, ClaimSettings.read(settings.m_128469_(id))));
        CompoundTag bypassTag = tag.m_128469_("bypass");
        bypassTag.m_128431_().forEach(uuid -> this.bypassPlayers.add(UUID.fromString(uuid)));
        String teamProvider = tag.m_128461_("team_provider");
        if (!teamProvider.isEmpty()) {
            TeamProviderApi.API.setSelected(new ResourceLocation(teamProvider));
        }
        if (!(maxClaimProvider = tag.m_128461_("max_claim_provider")).isEmpty()) {
            MaxClaimProviderApi.API.setSelected(new ResourceLocation(maxClaimProvider));
        }
        if (tag.m_128441_("defaultSettings")) {
            this.defaultSettings = ClaimSettings.read(tag.m_128469_("defaultSettings"));
        }
        if (tag.m_128441_("allowedBlocks")) {
            CompoundTag allowedBlocksTag = tag.m_128469_("allowedBlocks");
            allowedBlocksTag.m_128431_().forEach(id -> {
                ListTag blockTag = allowedBlocksTag.m_128437_(id, 8);
                HashSet blocks = new HashSet();
                blockTag.forEach(tagEntry -> blocks.add(new ResourceLocation(tagEntry.m_7916_())));
                this.allowedBlocks.put((String)id, blocks);
            });
        }
    }

    public void saveData(CompoundTag tag) {
        ResourceLocation maxClaimSelectedId;
        CompoundTag maxClaimsTag = new CompoundTag();
        this.maxClaimsById.forEach((id, maxClaims) -> {
            CompoundTag maxClaimTag = new CompoundTag();
            maxClaimTag.m_128405_("maxClaims", maxClaims.firstInt());
            maxClaimTag.m_128405_("maxChunkLoaded", maxClaims.secondInt());
            maxClaimsTag.m_128365_(id, (Tag)maxClaimTag);
        });
        tag.m_128365_("max_claims", (Tag)maxClaimsTag);
        CompoundTag settings = new CompoundTag();
        this.settings.forEach((id, claimSettings) -> settings.m_128365_(id, (Tag)claimSettings.write(new CompoundTag())));
        tag.m_128365_("settings", (Tag)settings);
        CompoundTag bypassTag = new CompoundTag();
        this.bypassPlayers.forEach(uuid -> bypassTag.m_128365_(uuid.toString(), (Tag)new CompoundTag()));
        tag.m_128365_("bypass", (Tag)bypassTag);
        ResourceLocation selectedId = TeamProviderApi.API.getSelectedId();
        if (selectedId != null) {
            tag.m_128359_("team_provider", selectedId.toString());
        }
        if ((maxClaimSelectedId = MaxClaimProviderApi.API.getSelectedId()) != null) {
            tag.m_128359_("max_claim_provider", maxClaimSelectedId.toString());
        }
        tag.m_128365_("defaultSettings", (Tag)this.defaultSettings.write(new CompoundTag()));
        CompoundTag allowedBlocksTag = new CompoundTag();
        this.allowedBlocks.forEach((id, blocks) -> {
            ListTag blockTag = new ListTag();
            blocks.forEach(block -> blockTag.add((Object)StringTag.m_129297_((String)block.toString())));
            allowedBlocksTag.m_128365_(id, (Tag)blockTag);
        });
        tag.m_128365_("allowedBlocks", (Tag)allowedBlocksTag);
    }

    public static boolean canBypass(MinecraftServer server, UUID player) {
        return CadmusDataHandler.read((MinecraftServer)server).bypassPlayers.contains(player);
    }

    public static void toggleBypass(MinecraftServer server, UUID player) {
        CadmusDataHandler data = CadmusDataHandler.read(server);
        if (data.bypassPlayers.contains(player)) {
            data.bypassPlayers.remove(player);
        } else {
            data.bypassPlayers.add(player);
        }
    }

    public static CadmusDataHandler read(MinecraftServer server) {
        return (CadmusDataHandler)CadmusDataHandler.read((DimensionDataStorage)server.m_129783_().m_8895_(), CadmusDataHandler::new, (String)"cadmus_data");
    }

    public static Map<String, IntIntPair> getMaxTeamClaims(MinecraftServer server) {
        return CadmusDataHandler.read((MinecraftServer)server).maxClaimsById;
    }

    public static ClaimSettings getClaimSettings(MinecraftServer server, String id) {
        return CadmusDataHandler.read((MinecraftServer)server).settings.computeIfAbsent(id, ignored -> ClaimSettings.ofUndefined());
    }

    public static ClaimSettings getDefaultClaimSettings(MinecraftServer server) {
        return CadmusDataHandler.read((MinecraftServer)server).defaultSettings;
    }

    public boolean m_77764_() {
        return true;
    }

    public static void addAllowedBlock(MinecraftServer server, String player, Block block) {
        CadmusDataHandler data = CadmusDataHandler.read(server);
        data.allowedBlocks.computeIfAbsent(player, ignored -> new HashSet()).add(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    public static void removeAllowedBlock(MinecraftServer server, String player, Block block) {
        CadmusDataHandler data = CadmusDataHandler.read(server);
        data.allowedBlocks.computeIfAbsent(player, ignored -> new HashSet()).remove(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    public static boolean isBlockAllowed(MinecraftServer server, String player, Block block) {
        CadmusDataHandler data = CadmusDataHandler.read(server);
        return data.allowedBlocks.computeIfAbsent(player, ignored -> new HashSet()).contains(BuiltInRegistries.f_256975_.m_7981_((Object)block));
    }

    public static Set<ResourceLocation> getAllowedBlocks(MinecraftServer server, String player) {
        return CadmusDataHandler.read((MinecraftServer)server).allowedBlocks.computeIfAbsent(player, ignored -> new HashSet());
    }
}

