/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.client;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.cadmus.common.network.NetworkHandler;
import earth.terrarium.cadmus.common.network.messages.ServerboundListenToChunksPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public final class ClientClaims {
    public static final Map<ResourceKey<Level>, ClientClaims> CLAIMS = new HashMap<ResourceKey<Level>, ClientClaims>();
    private final ResourceKey<Level> dimension;
    private final Map<ChunkPos, Entry> claims = new HashMap<ChunkPos, Entry>();
    private final Map<String, Consumer<Map<ChunkPos, Entry>>> listeners = new HashMap<String, Consumer<Map<ChunkPos, Entry>>>();

    public ClientClaims(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public void addListener(String id, Consumer<Map<ChunkPos, Entry>> listener) {
        if (this.listeners.isEmpty()) {
            this.claims.clear();
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundListenToChunksPacket(this.dimension, true));
        }
        this.listeners.put(id, listener);
    }

    public void removeListener(String id) {
        this.listeners.remove(id);
        if (this.listeners.isEmpty()) {
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundListenToChunksPacket(this.dimension, false));
            this.claims.clear();
        }
    }

    public void update(Component displayName, int color, Map<ChunkPos, Boolean> claims) {
        Entry entry = new Entry(displayName, color);
        claims.forEach((chunkPos, isClaimed) -> {
            if (isClaimed.booleanValue()) {
                this.claims.put((ChunkPos)chunkPos, entry);
            } else {
                this.claims.remove(chunkPos);
            }
        });
        this.listeners.values().forEach(l -> l.accept(this.claims));
    }

    public static ClientClaims get(ResourceKey<Level> dimension) {
        return CLAIMS.computeIfAbsent(dimension, ClientClaims::new);
    }

    public record Entry(Component name, int color) {
    }
}

