/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.nixie.foundation.DoubleOrientedBlockModel;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlockEntity;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayTarget;
import com.kipti.bnb.content.nixie.nixie_board.NixieBoardBlockNixie;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.BlockHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class GenericNixieDisplayBlock
extends DirectionalBlock
implements IWrenchable {
    public static final DirectionProperty ORIENTATION = DirectionProperty.m_156003_((String)"orientation");

    public GenericNixieDisplayBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)ORIENTATION, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_52588_, ORIENTATION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement;
        Direction surface = context.m_43719_();
        Direction facing = context.m_7820_();
        if (facing.m_122434_() == surface.m_122434_()) {
            facing = Arrays.stream(Direction.values()).filter(dir -> dir.m_122434_() != surface.m_122434_()).min(Comparator.comparingDouble(dir -> Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82557_(Objects.requireNonNull(context.m_43723_()).m_20154_()))).orElse(Direction.NORTH);
        }
        return (stateForPlacement = super.m_5573_(context)) == null ? null : (BlockState)((BlockState)stateForPlacement.m_61124_((Property)f_52588_, (Comparable)surface)).m_61124_((Property)ORIENTATION, (Comparable)facing.m_122424_());
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        GenericNixieDisplayBlockEntity be = (GenericNixieDisplayBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions currentOption = be.getCurrentDisplayOption();
        List<GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions> options = be.getPossibleDisplayOptions();
        int currentIndex = options.indexOf((Object)currentOption);
        if (currentIndex < 0) {
            CreateBitsnBobs.LOGGER.warn("No valid display option found for {}", (Object)be.m_58899_());
            return InteractionResult.PASS;
        }
        int nextIndex = (currentIndex + 1) % options.size();
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions nextOption = options.get(nextIndex);
        be.applyToEachElementOfThisStructure(display -> {});
        GenericNixieDisplayTarget.walkNixies(context.m_43725_(), context.m_8083_(), (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, blockEntity) -> {
            blockEntity.setPositionOffset((int)consumedCharsOnRow);
            blockEntity.setDisplayOption(nextOption);
        }));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(interactionHand);
        boolean display = stack.m_41720_() == Items.f_42656_ && stack.m_41788_() || AllBlocks.CLIPBOARD.isIn(stack);
        DyeColor dye = DyeColor.getColor((ItemStack)stack);
        if (!display && dye == null || !((blockEntity = level.m_7702_(pos)) instanceof GenericNixieDisplayBlockEntity)) {
            return InteractionResult.PASS;
        }
        GenericNixieDisplayBlockEntity startBlockEntity = (GenericNixieDisplayBlockEntity)blockEntity;
        if (dye != null) {
            GenericNixieDisplayTarget.walkNixies(level, pos, (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, initialBE) -> {
                BlockState coloredState = GenericNixieDisplayBlock.withColor(initialBE.m_58900_(), dye);
                level.m_7731_(currentPos, coloredState, 3);
                BlockEntity be = level.m_7702_(currentPos);
                if (be instanceof GenericNixieDisplayBlockEntity) {
                    GenericNixieDisplayBlockEntity currentBe = (GenericNixieDisplayBlockEntity)be;
                    currentBe.inheritDataFrom((GenericNixieDisplayBlockEntity)((Object)initialBE));
                }
            }));
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41737_("display");
        String tagElement = tag != null && tag.m_128425_("Name", 8) ? tag.m_128461_("Name") : null;
        MutableComponent component = tagElement == null ? Component.m_237119_() : Component.Serializer.m_130701_(tagElement);
        MutableComponent secondRowComponent = null;
        boolean forceFromTop = false;
        if (AllBlocks.CLIPBOARD.isIn(stack)) {
            List entries = ClipboardEntry.getLastViewedEntries((ItemStack)stack);
            MutableComponent mutableComponent = component = !entries.isEmpty() ? ((ClipboardEntry)entries.get((int)0)).text : Component.m_237119_();
            if (entries.size() > 1) {
                secondRowComponent = ((ClipboardEntry)entries.get((int)1)).text;
                forceFromTop = true;
            }
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        String tagUsed = Component.Serializer.m_130703_((Component)component);
        @Nullable String secondRowTagUsed = secondRowComponent == null ? null : Component.Serializer.m_130703_(secondRowComponent);
        int startLine = forceFromTop ? 0 : this.getLineForPlacement(state, pos, hitResult, level);
        GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions currentDisplay = startBlockEntity.getCurrentDisplayOption();
        GenericNixieDisplayTarget.walkNixies(level, pos, (TriConsumer<BlockPos, Integer, GenericNixieDisplayBlockEntity>)((TriConsumer)(currentPos, consumedCharsOnRow, displayBlockEntity) -> {
            if (displayBlockEntity.getCurrentDisplayOption() != currentDisplay && displayBlockEntity.getPossibleDisplayOptions().contains((Object)currentDisplay)) {
                displayBlockEntity.setDisplayOption(currentDisplay);
            }
            displayBlockEntity.displayCustomText(tagUsed, (int)consumedCharsOnRow, startLine);
            if (secondRowTagUsed != null && startLine == 0) {
                displayBlockEntity.displayCustomText(secondRowTagUsed, (int)consumedCharsOnRow, 1);
            }
        }));
        return InteractionResult.SUCCESS;
    }

    private static BlockState withColor(BlockState state, DyeColor color) {
        if (GenericNixieDisplayBlock.isLargeNixieTube(state.m_60734_())) {
            Block block = color == null ? (Block)BnbBlocks.LARGE_NIXIE_TUBE.get() : (Block)BnbBlocks.DYED_LARGE_NIXIE_TUBE.get(color).get();
            return BlockHelper.copyProperties((BlockState)state, (BlockState)block.m_49966_());
        }
        if (GenericNixieDisplayBlock.isNixieBoard(state.m_60734_())) {
            Block block = color == null ? (Block)BnbBlocks.NIXIE_BOARD.get() : (Block)BnbBlocks.DYED_NIXIE_BOARD.get(color).get();
            return BlockHelper.copyProperties((BlockState)state, (BlockState)block.m_49966_());
        }
        return state;
    }

    public static boolean isLargeNixieTube(Block block) {
        return BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(block) || BnbBlocks.LARGE_NIXIE_TUBE.is((Object)block);
    }

    public static boolean isNixieBoard(Block block) {
        return BnbBlocks.DYED_NIXIE_BOARD.contains(block) || BnbBlocks.NIXIE_BOARD.is((Object)block);
    }

    private int getLineForPlacement(BlockState state, BlockPos blockPos, BlockHitResult hitResult, Level level) {
        if (!(state.m_60734_() instanceof NixieBoardBlockNixie)) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof GenericNixieDisplayBlockEntity)) {
            return 0;
        }
        if (((GenericNixieDisplayBlockEntity)blockEntity).currentDisplayOption.lines == 1) {
            return 0;
        }
        Matrix4f rotation = DoubleOrientedBlockModel.getRotation((Direction)state.m_61143_((Property)f_52588_), (Direction)state.m_61143_((Property)ORIENTATION));
        Vec3 globalPos = hitResult.m_82450_().m_82546_(blockPos.m_252807_());
        Vector4f localPos = rotation.invert().transform(new Vector4f((Vector3fc)globalPos.m_252839_(), 1.0f));
        if (localPos.y < 0.0f) {
            return 1;
        }
        return 0;
    }
}

