/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockItem;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class GirderStrutPlacementEffects {
    private static final float PARTICLE_DENSITY = 0.1f;

    public static void tick(LocalPlayer player) {
        ItemStack heldItem;
        if (Minecraft.m_91087_().m_91104_() || Minecraft.m_91087_().f_91077_ == null) {
            return;
        }
        Object object = player.m_21205_().m_41720_() instanceof GirderStrutBlockItem ? player.m_21205_() : (heldItem = player.m_21206_().m_41720_() instanceof GirderStrutBlockItem ? player.m_21206_() : null);
        if (heldItem != null) {
            GirderStrutPlacementEffects.display(player, heldItem);
        }
    }

    private static void display(LocalPlayer player, ItemStack heldItem) {
        BlockHitResult hit;
        Direction fromFace;
        BlockPos fromPos;
        ClientLevel level;
        block10: {
            block9: {
                level = Minecraft.m_91087_().f_91073_;
                if (level == null) {
                    return;
                }
                Pair<BlockPos, Direction> placementData = GirderStrutBlockItem.getPlacement(heldItem);
                fromPos = (BlockPos)placementData.getFirst();
                fromFace = (Direction)placementData.getSecond();
                if (fromPos == null) {
                    return;
                }
                HitResult genericHit = Minecraft.m_91087_().f_91077_;
                if (!(genericHit instanceof BlockHitResult)) break block9;
                hit = (BlockHitResult)genericHit;
                if (genericHit.m_6662_() == HitResult.Type.BLOCK) break block10;
            }
            return;
        }
        BlockPos targetPos = GirderStrutPlacementEffects.resolvePlacementPos(level, hit.m_82425_(), hit.m_82434_());
        if (targetPos == null || targetPos.m_123331_((Vec3i)fromPos) > 96.0) {
            return;
        }
        Direction targetFace = hit.m_82434_();
        BlockState targetState = level.m_8055_(targetPos);
        if (targetState.m_60734_() instanceof GirderStrutBlock) {
            targetFace = (Direction)targetState.m_61143_((Property)GirderStrutBlock.FACING);
        }
        Vec3 renderFrom = Vec3.m_82512_((Vec3i)fromPos);
        Vec3 renderTo = Vec3.m_82512_((Vec3i)targetPos);
        Vec3 delta = renderTo.m_82546_(renderFrom);
        double length = delta.m_82553_();
        if (length < 0.001 || length > 24.0) {
            return;
        }
        boolean valid = GirderStrutBlockItem.isValidConnection((Level)level, fromPos, fromFace, targetPos, targetFace);
        Vec3 dir = delta.m_82541_();
        double step = 0.25;
        Vector3f color = valid ? new Vector3f(0.3f, 0.9f, 0.5f) : new Vector3f(0.9f, 0.3f, 0.5f);
        Vector3f outlinerColor = valid ? new Vector3f(0.35f, 0.85f, 0.55f) : new Vector3f(0.85f, 0.35f, 0.55f);
        for (double t = 0.0; t <= length; t += 0.25) {
            Vec3 lerped = renderFrom.m_82549_(dir.m_82490_(t));
            if (level.m_213780_().m_188501_() > 0.1f) continue;
            level.m_6493_((ParticleOptions)new DustParticleOptions(color, 1.0f), true, lerped.f_82479_, lerped.f_82480_, lerped.f_82481_, 0.0, 0.0, 0.0);
        }
        level.m_6493_((ParticleOptions)new DustParticleOptions(color, 1.0f), true, renderTo.f_82479_, renderTo.f_82480_, renderTo.f_82481_, 0.0, 0.0, 0.0);
        GirderStrutPlacementEffects.showAnchorBox(fromPos, fromFace.m_122424_(), "from", (int)(outlinerColor.x * 256.0f), (int)(outlinerColor.y * 256.0f), (int)(outlinerColor.z * 256.0f));
        GirderStrutPlacementEffects.showAnchorBox(targetPos, targetFace.m_122424_(), "to", (int)(outlinerColor.x * 256.0f), (int)(outlinerColor.y * 256.0f), (int)(outlinerColor.z * 256.0f));
    }

    private static void showAnchorBox(BlockPos targetPos, Direction targetFace, String id, int r, int g, int b) {
        AABB box = new AABB(0.0, 0.0, 0.0, (double)((targetFace.m_122429_() == 0 ? 0.25f : 0.0f) + 0.25f), (double)((targetFace.m_122430_() == 0 ? 0.25f : 0.0f) + 0.25f), (double)((targetFace.m_122431_() == 0 ? 0.25f : 0.0f) + 0.25f));
        box = box.m_82386_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_()).m_82386_(-box.m_82362_() * 0.5 + 0.5, -box.m_82376_() * 0.5 + 0.5, -box.m_82385_() * 0.5 + 0.5).m_82386_((double)((float)targetFace.m_122429_() * 0.5f), (double)((float)targetFace.m_122430_() * 0.5f), (double)((float)targetFace.m_122431_() * 0.5f));
        Outliner.getInstance().showAABB((Object)id, box).colored(new Color(r, g, b)).lineWidth(0.0625f);
    }

    private static BlockPos resolvePlacementPos(ClientLevel level, BlockPos clickedPos, Direction face) {
        BlockPos pos = clickedPos;
        if (!(level.m_8055_(pos).m_60734_() instanceof GirderStrutBlock || level.m_8055_(pos = pos.m_121945_(face)).m_247087_() || level.m_8055_(pos).m_60734_() instanceof GirderStrutBlock)) {
            return null;
        }
        return pos;
    }
}

