/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.RenderedChainPathNode;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogwheelChainGeometryBuilder {
    public static List<RenderedChainPathNode> buildFullChainFromPathNodes(List<PathedCogwheelNode> pathNodes) {
        PathedCogwheelNode nextNode;
        PathedCogwheelNode currentNode;
        PathedCogwheelNode previousNode;
        int i;
        ArrayList<RenderedChainPathNode> resultNodes = new ArrayList<RenderedChainPathNode>();
        ArrayList<Pair<Vec3, Vec3>> offsetsAtNodes = new ArrayList<Pair<Vec3, Vec3>>();
        int n = pathNodes.size();
        for (i = 0; i < n; ++i) {
            previousNode = pathNodes.get((n + i - 1) % n);
            currentNode = pathNodes.get(i);
            nextNode = pathNodes.get((i + 1) % n);
            Pair<Vec3, Vec3> inOutPositionsAtThisNode = CogwheelChainGeometryBuilder.calculateOffsets(previousNode, currentNode, nextNode);
            offsetsAtNodes.add(inOutPositionsAtThisNode);
        }
        for (i = 0; i < n; ++i) {
            previousNode = pathNodes.get((n + i - 1) % n);
            currentNode = pathNodes.get(i);
            nextNode = pathNodes.get((i + 1) % n);
            Pair previousOffsets = (Pair)offsetsAtNodes.get((i - 1 + n) % n);
            Pair currentOffsets = (Pair)offsetsAtNodes.get(i);
            Pair nextOffsets = (Pair)offsetsAtNodes.get((i + 1) % n);
            resultNodes.add(new RenderedChainPathNode(currentNode.localPos(), (Vec3)currentOffsets.getFirst()));
            resultNodes.addAll(CogwheelChainGeometryBuilder.wrappedArcBetweenPoints(currentNode, ((Vec3)previousOffsets.getSecond()).m_82549_(previousNode.center()), ((Vec3)currentOffsets.getFirst()).m_82549_(currentNode.center()), ((Vec3)currentOffsets.getSecond()).m_82549_(currentNode.center()), ((Vec3)nextOffsets.getFirst()).m_82549_(nextNode.center())));
            resultNodes.add(new RenderedChainPathNode(currentNode.localPos(), (Vec3)currentOffsets.getSecond()));
        }
        return resultNodes;
    }

    private static List<RenderedChainPathNode> wrappedArcBetweenPoints(PathedCogwheelNode currentNode, Vec3 outPreviousPositionWorld, Vec3 inCurrentOffsetWorld, Vec3 outCurrentOffsetWorld, Vec3 inNextPositionWorld) {
        Vec3 center = currentNode.localPos().m_252807_();
        Vec3 prevLocal = outPreviousPositionWorld.m_82546_(center);
        Vec3 startLocal = inCurrentOffsetWorld.m_82546_(center);
        Vec3 endLocal = outCurrentOffsetWorld.m_82546_(center);
        Vec3 nextLocal = inNextPositionWorld.m_82546_(center);
        double r = startLocal.m_82553_();
        if (r <= 1.0E-9) {
            return List.of();
        }
        Vec3 inDirection = startLocal.m_82546_(prevLocal);
        if (inDirection.m_82553_() < 1.0E-9) {
            inDirection = nextLocal.m_82546_(startLocal);
        }
        inDirection = inDirection.m_82541_();
        Vec3 outDirection = endLocal.m_82546_(nextLocal);
        if (outDirection.m_82553_() < 1.0E-9) {
            outDirection = prevLocal.m_82546_(endLocal);
        }
        outDirection = outDirection.m_82541_();
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode).m_82541_();
        if (axis == null) {
            throw new IllegalStateException("axis null for chainNode " + currentNode);
        }
        Vec3 u = startLocal.m_82541_();
        Vec3 w = endLocal.m_82541_();
        double crossDot = axis.m_82526_(u.m_82537_(w));
        double dot = Math.max(-1.0, Math.min(1.0, u.m_82526_(w)));
        double signedAngle = Math.atan2(crossDot, dot);
        Vec3 tangentAtStart = axis.m_82537_(startLocal);
        double tangentLen = tangentAtStart.m_82553_();
        double tangentDot = 0.0;
        if (tangentLen > 1.0E-9) {
            tangentAtStart = tangentAtStart.m_82490_(1.0 / tangentLen);
            tangentDot = inDirection.m_82526_(tangentAtStart);
        } else {
            tangentDot = inDirection.m_82526_(u) > 0.0 ? 1.0 : -1.0;
        }
        double EPS = 1.0E-9;
        if (Math.abs(tangentDot) > 1.0E-9) {
            double desiredSign;
            double angleSign = Math.signum(signedAngle);
            double d = desiredSign = tangentDot > 0.0 ? 1.0 : -1.0;
            if (angleSign == 0.0) {
                signedAngle = dot > 0.999999 ? 0.0 : desiredSign * Math.PI;
            } else if (angleSign != desiredSign) {
                signedAngle -= Math.signum(signedAngle) * 2.0 * Math.PI;
            }
        }
        double absAngle = Math.abs(signedAngle);
        double approxArcLength = r * absAngle;
        int segments = Math.max(1, (int)(Math.ceil(approxArcLength) * 3.0));
        ArrayList<RenderedChainPathNode> result = new ArrayList<RenderedChainPathNode>();
        for (int i = 1; i < segments; ++i) {
            double t = (double)i / (double)segments;
            double theta = signedAngle * t;
            Vec3 rotatedLocal = CogwheelChainGeometryBuilder.rotateAroundAxis(startLocal, axis, theta);
            result.add(new RenderedChainPathNode(currentNode.localPos(), rotatedLocal));
        }
        return result;
    }

    private static Vec3 rotateAroundAxis(Vec3 v, Vec3 axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return v.m_82490_(cos).m_82549_(axis.m_82537_(v).m_82490_(sin)).m_82549_(axis.m_82490_(axis.m_82526_(v) * (1.0 - cos)));
    }

    private static int getLooped(int[] concavities, int i) {
        return concavities[(i + concavities.length) % concavities.length];
    }

    public static Pair<Vec3, Vec3> calculateOffsets(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode, PathedCogwheelNode nextNode) {
        Vec3 incomingPointOnCircle = CogwheelChainGeometryBuilder.getTangentPointOnCircle(previousNode, currentNode, true);
        Vec3 outgoingPointOnCircle = CogwheelChainGeometryBuilder.getTangentPointOnCircle(nextNode, currentNode, false);
        return Pair.of((Object)incomingPointOnCircle, (Object)outgoingPointOnCircle);
    }

    @NotNull
    private static Vec3 getDirectionOfAxis(PathedCogwheelNode currentNode) {
        return Vec3.m_82528_((Vec3i)Direction.m_122387_((Direction.Axis)currentNode.rotationAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).m_122436_());
    }

    @NotNull
    private static Vec3 getConnectionDirection(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode) {
        Vec3 incomingADiff = currentNode.center().m_82546_(previousNode.center());
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            Vec3 previousAxis = CogwheelChainGeometryBuilder.getDirectionOfAxis(previousNode);
            incomingADiff = incomingADiff.m_82546_(previousAxis.m_82490_(incomingADiff.m_82526_(previousAxis)));
        }
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode);
        return incomingADiff.m_82546_(axis.m_82490_(axis.m_82526_(incomingADiff)));
    }

    public static Vec3 getTangentPointOnCircle(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode, boolean isIncoming) {
        double currentRadius;
        double previousRadius;
        Vec3 incoming;
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode);
        Vec3 vec3 = incoming = isIncoming ? CogwheelChainGeometryBuilder.getConnectionDirection(previousNode, currentNode) : CogwheelChainGeometryBuilder.getConnectionDirection(currentNode, previousNode);
        double d = previousNode.isLarge() ? 1.0 : (previousRadius = (double)(0.5f + (previousNode.offsetForSmallCogwheel() ? 0.125f : 0.0f)));
        double d2 = currentNode.isLarge() ? 1.0 : (currentRadius = (double)(0.5f + (currentNode.offsetForSmallCogwheel() ? 0.125f : 0.0f)));
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            return CogwheelChainGeometryBuilder.getDirectionOfAxis(previousNode).m_82490_((double)previousNode.localPos().m_121996_((Vec3i)currentNode.localPos()).m_123304_(previousNode.rotationAxis()));
        }
        if (previousNode.side() == currentNode.side()) {
            return incoming.m_82541_().m_82537_(axis).m_82490_(-currentRadius * (double)currentNode.side());
        }
        double factor = previousRadius / (previousRadius + currentRadius);
        Vec3 tangentOrigin = incoming.m_82490_(factor);
        double distance = (double)(isIncoming ? 1 : -1) * tangentOrigin.m_82553_();
        double sineRatio = previousRadius / distance;
        double cosRatio = Math.sqrt(1.0 - sineRatio * sineRatio);
        double perpendicularHeight = cosRatio * currentRadius;
        double lengthAlongIncoming = sineRatio * currentRadius;
        return incoming.m_82541_().m_82537_(axis).m_82490_(-perpendicularHeight * (double)currentNode.side()).m_82549_(incoming.m_82541_().m_82490_(-lengthAlongIncoming));
    }
}

