/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectOrbit
extends AbstractEffect {
    public static EffectOrbit INSTANCE = new EffectOrbit();

    private EffectOrbit() {
        super(GlyphLib.EffectOrbitID, "Orbit");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        if (spellContext.getRemainingSpell().isEmpty()) {
            return;
        }
        int total = 3 + stats.getBuffCount(AugmentSplit.INSTANCE);
        SpellContext newContext = resolver.spellContext.makeChildContext();
        Spell spell = newContext.getSpell();
        spell.recipe.add(0, MethodProjectile.INSTANCE);
        spellContext.setCanceled(true);
        for (int i = 0; i < total; ++i) {
            EntityOrbitProjectile wardProjectile = new EntityOrbitProjectile(world, resolver.getNewResolver(newContext), rayTraceResult.m_82450_());
            wardProjectile.setOffset(i);
            wardProjectile.setAccelerates((int)stats.getAccMultiplier());
            wardProjectile.setAoe((float)stats.getAoeMultiplier());
            wardProjectile.extendTimes = (int)stats.getDurationMultiplier();
            wardProjectile.setTotal(total);
            wardProjectile.setColor(resolver.spellContext.getColors());
            world.m_7967_((Entity)wardProjectile);
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        if (spellContext.getRemainingSpell().isEmpty()) {
            return;
        }
        int total = 3 + stats.getBuffCount(AugmentSplit.INSTANCE);
        Spell newSpell = spellContext.getRemainingSpell();
        newSpell.recipe.add(0, MethodProjectile.INSTANCE);
        SpellContext newContext = resolver.spellContext.makeChildContext().withSpell(newSpell);
        spellContext.setCanceled(true);
        for (int i = 0; i < total; ++i) {
            EntityOrbitProjectile wardProjectile = new EntityOrbitProjectile(world, resolver.getNewResolver(newContext), rayTraceResult.m_82443_());
            wardProjectile.setOffset(i);
            wardProjectile.setAccelerates((int)stats.getAccMultiplier());
            wardProjectile.setAoe((float)stats.getAoeMultiplier());
            wardProjectile.extendTimes = (int)stats.getDurationMultiplier();
            wardProjectile.setTotal(total);
            wardProjectile.setColor(resolver.spellContext.getColors());
            world.m_7967_((Entity)wardProjectile);
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    @Override
    public String getBookDescription() {
        return "Summons three orbiting projectiles around the target that will cast a spell on any entities it may hit. Additional projectiles, their speed, radius, and duration may be augmented. Sensitive will cause Orbit to hit blocks.";
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAccelerate.INSTANCE, AugmentDecelerate.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentSensitive.INSTANCE);
    }
}

