/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalMeleeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.ConditionalWaterAvoidingGoal;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenGuardian
extends Monster
implements GeoEntity {
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int armorCooldown;
    public int armorTimeRemaining;
    public static final EntityDataAccessor<Boolean> IS_ARMORED = SynchedEntityData.m_135353_(WildenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    AnimationController<WildenGuardian> controller;
    AnimationController<WildenGuardian> runController;
    AnimationController<WildenGuardian> idleController;

    public WildenGuardian(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public WildenGuardian(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_GUARDIAN.get()), worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new ConditionalMeleeGoal((PathfinderMob)this, 1.2, true, () -> !this.isArmored()));
        this.f_21345_.m_25352_(8, (Goal)new ConditionalWaterAvoidingGoal((PathfinderMob)this, 1.0, () -> !this.isArmored()));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.GUARDIAN_ATTACK_ANIMALS.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
    }

    public boolean isArmored() {
        return (Boolean)this.f_19804_.m_135370_(IS_ARMORED);
    }

    public void setArmored(boolean isArmored) {
        this.f_19804_.m_135381_(IS_ARMORED, (Object)isArmored);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (!this.f_19853_.f_46443_ && this.armorCooldown == 0) {
            this.setArmored(true);
            this.armorCooldown = 200;
            this.armorTimeRemaining = 100;
            this.f_21344_.m_26573_();
        }
        if (!this.f_19853_.f_46443_ && this.isArmored() && !damageSrc.m_269533_(DamageTypeTags.f_268490_)) {
            damageAmount = (float)((double)damageAmount * 0.75);
            if (damageSrc.m_7639_() != null && BlockUtil.distanceFrom(damageSrc.m_7639_().f_19825_, this.f_19825_) <= 2.0 && !damageSrc.m_269415_().f_268677_().equals("thorns")) {
                damageSrc.m_7639_().m_6469_(this.f_19853_.m_269111_().m_269374_((Entity)this), 3.0f);
            }
        }
        super.m_6475_(damageSrc, damageAmount);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.armorTimeRemaining > 0) {
                --this.armorTimeRemaining;
            }
            if (this.armorTimeRemaining == 0 && this.isArmored()) {
                this.setArmored(false);
                this.explodeSpikes();
            }
            if (this.armorCooldown > 0) {
                --this.armorCooldown;
            }
        }
        if (this.isArmored() && !this.f_19853_.f_46443_) {
            this.m_21573_().m_26573_();
        }
    }

    public void explodeSpikes() {
        for (int i = 0; i < 20; ++i) {
            EntityChimeraProjectile entity = new EntityChimeraProjectile(this.f_19853_);
            entity.m_37251_((Entity)this, this.f_19853_.f_46441_.m_188503_(360), this.f_19853_.f_46441_.m_188503_(360), 0.0f, (float)(1.0 + ParticleUtil.inRange(0.0, 0.5)), 1.0f);
            entity.m_6034_(this.f_19825_.f_82479_, this.f_19825_.f_82480_ + 1.0, this.f_19825_.f_82481_);
            this.f_19853_.m_7967_((Entity)entity);
        }
        if (this.m_5448_() != null) {
            EntityChimeraProjectile abstractarrowentity = new EntityChimeraProjectile(this.f_19853_);
            abstractarrowentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            double d0 = this.m_5448_().m_20185_() - this.m_20185_();
            double d1 = this.m_5448_().m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
            double d2 = this.m_5448_().m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
            this.f_19853_.m_7967_((Entity)abstractarrowentity);
        }
    }

    private <T extends GeoAnimatable> PlayState runPredicate(AnimationState<T> tAnimationState) {
        if (this.isArmored()) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState idlePredicate(AnimationState<T> tAnimationState) {
        if (this.isArmored()) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            return PlayState.STOP;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ARMORED, (Object)false);
    }

    private PlayState defendPredicate(AnimationState<?> event) {
        if (this.isArmored()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("defending"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        this.controller = new AnimationController((GeoAnimatable)this, "attackController", 1, this::defendPredicate);
        this.runController = new AnimationController((GeoAnimatable)this, "runController", 1, this::runPredicate);
        this.idleController = new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate);
        animatableManager.add(new AnimationController[]{this.controller});
        animatableManager.add(new AnimationController[]{this.runController});
        animatableManager.add(new AnimationController[]{this.idleController});
    }

    public int getAttackDuration() {
        return 80;
    }

    public boolean m_20223_(CompoundTag compound) {
        compound.m_128405_("armorCooldown", this.armorCooldown);
        compound.m_128405_("armorTimeRemaining", this.armorTimeRemaining);
        return super.m_20223_(compound);
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.armorCooldown = compound.m_128451_("armorCooldown");
        this.armorTimeRemaining = compound.m_128451_("armorTimeRemaining");
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 4.5).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected float m_6108_() {
        return 0.98f;
    }
}

