/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityHomingProjectileSpell
extends EntityProjectileSpell {
    List<Predicate<LivingEntity>> ignore;
    LivingEntity target;

    public EntityHomingProjectileSpell(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    public EntityHomingProjectileSpell(Level world, SpellResolver resolver) {
        super((EntityType<? extends EntityProjectileSpell>)((EntityType)ModEntities.SPELL_PROJ_HOM.get()), world, resolver);
    }

    @Override
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.SPELL_PROJ_HOM.get();
    }

    public void setIgnored(List<Predicate<LivingEntity>> ignore) {
        this.ignore = ignore;
    }

    public List<Predicate<LivingEntity>> getIgnored() {
        return this.ignore;
    }

    @Override
    public void tickNextPosition() {
        if (!this.m_213877_()) {
            if (this.target != null && (!this.target.m_6084_() || this.target.m_20280_((Entity)this) > 50.0)) {
                this.target = null;
            }
            if (this.target == null && this.f_19797_ % 3 == 0) {
                List entities = this.m_19749_() instanceof Player ? this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), this::shouldTarget) : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(4.0), this::shouldTarget);
                if (entities.isEmpty() && this.target == null) {
                    super.tickNextPosition();
                } else if (!entities.isEmpty()) {
                    this.target = entities.stream().filter(e -> e.m_20280_((Entity)this) < 75.0).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)this))).orElse(this.target);
                }
            }
            if (this.target != null) {
                this.homeTo(this.target.m_20183_());
            } else {
                super.tickNextPosition();
            }
        }
    }

    private void homeTo(BlockPos dest) {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double motionX = this.m_20184_().f_82479_;
        double motionY = this.m_20184_().f_82480_;
        double motionZ = this.m_20184_().f_82481_;
        if (dest.m_123341_() != 0 || dest.m_123342_() != 0 || dest.m_123343_() != 0) {
            double targetX = (double)dest.m_123341_() + 0.5;
            double targetY = (double)dest.m_123342_() + 0.75;
            double targetZ = (double)dest.m_123343_() + 0.5;
            Vec3 targetVector = new Vec3(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.m_82553_();
            targetVector = targetVector.m_82490_(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = (3.0 - length) * 0.3;
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.f_82479_;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.f_82480_;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.f_82481_;
        }
        this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
        this.m_20334_(motionX, motionY, motionZ);
    }

    @Override
    protected boolean m_5603_(Entity entity) {
        boolean b = super.m_5603_(entity);
        if (entity instanceof LivingEntity) {
            b &= this.shouldTarget((LivingEntity)entity);
        }
        return b;
    }

    private boolean shouldTarget(LivingEntity e) {
        if (this.ignore == null) {
            return false;
        }
        for (Predicate<LivingEntity> p : this.getIgnored()) {
            if (!p.test(e)) continue;
            return false;
        }
        return true;
    }
}

