/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.common.datagen.BiomeTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.BiomeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.registry.WorldgenRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WorldgenProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_256911_, WorldgenRegistry::bootstrapConfiguredFeatures).m_254916_(Registries.f_256988_, WorldgenRegistry::bootstrapPlacedFeatures).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifierRegistry::bootstrap).m_254916_(ForgeRegistries.Keys.BIOMES, BiomeRegistry::bootstrap);

    public WorldgenProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("ars_nouveau"));
    }

    public static class BiomeModifierRegistry {
        public static final ResourceKey<BiomeModifier> STARBUNCLE_SPAWN = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("starbuncle_spawn"));
        public static final ResourceKey<BiomeModifier> GIFT_STARBUNCLE_SPAWN = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("gift_starbuncle_spawn"));
        public static final ResourceKey<BiomeModifier> DRYGMY_SPAWN = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("drygmy_spawn"));
        public static final ResourceKey<BiomeModifier> WHIRLISPRIG_SPAWN = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("whirlisprig_spawn"));
        public static final ResourceKey<BiomeModifier> ARCHWOOD_MIX_RARE = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("rare_archwood_mix"));
        public static final ResourceKey<BiomeModifier> BERRY_COMMON = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BiomeModifierRegistry.prefix("common_source_berry"));

        public static void bootstrap(BootstapContext<BiomeModifier> context) {
            HolderSet.Named OVERWORLD_TAG = context.m_255420_(Registries.f_256952_).m_254956_(BiomeTags.f_215817_);
            HolderSet.Named BERRY_BIOMES = context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagProvider.BERRY_SPAWN);
            Holder.Reference BERRY_SET = (Holder.Reference)context.m_255420_(Registries.f_256988_).m_254902_(WorldgenRegistry.PLACED_BERRY_BUSH).get();
            Holder.Reference TREE_SET = (Holder.Reference)context.m_255420_(Registries.f_256988_).m_254902_(WorldgenRegistry.PLACED_MIX_ARCHWOODS).get();
            context.m_255272_(STARBUNCLE_SPAWN, (Object)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.STARBUNCLE_TYPE.get(), 5, 1, 2)));
            context.m_255272_(GIFT_STARBUNCLE_SPAWN, (Object)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GIFT_STARBY.get(), 1, 1, 1)));
            context.m_255272_(DRYGMY_SPAWN, (Object)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ENTITY_DRYGMY.get(), 3, 1, 2)));
            context.m_255272_(WHIRLISPRIG_SPAWN, (Object)ForgeBiomeModifiers.AddSpawnsBiomeModifier.singleSpawn((HolderSet)OVERWORLD_TAG, (MobSpawnSettings.SpawnerData)new MobSpawnSettings.SpawnerData((EntityType)ModEntities.WHIRLISPRIG_TYPE.get(), 5, 1, 2)));
            context.m_255272_(BERRY_COMMON, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)BERRY_BIOMES, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{BERRY_SET}), GenerationStep.Decoration.VEGETAL_DECORATION));
            context.m_255272_(ARCHWOOD_MIX_RARE, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)OVERWORLD_TAG, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{TREE_SET}), GenerationStep.Decoration.VEGETAL_DECORATION));
        }

        @NotNull
        private static ResourceLocation prefix(String path) {
            return new ResourceLocation("ars_nouveau", path);
        }
    }
}

