/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.google.common.collect.Maps;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.PerkSlot;
import com.hollingsworth.arsnouveau.api.perk.StackPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.AlterationTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class AlterationTableRenderer
extends GeoBlockRenderer<AlterationTile> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    public final ArmorStandArmorModel innerModel;
    public final ArmorStandArmorModel outerModel;

    public AlterationTableRenderer(BlockEntityRendererProvider.Context p_i226006_1_) {
        super((GeoModel)new GenericModel("alteration_table").withEmptyAnim());
        this.innerModel = new ArmorStandArmorModel(p_i226006_1_.m_173582_(ModelLayers.f_171208_));
        this.outerModel = new ArmorStandArmorModel(p_i226006_1_.m_173582_(ModelLayers.f_171261_));
    }

    public void renderArmorStack(AlterationTile tile, PoseStack matrixStack, float ticks, MultiBufferSource iRenderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float partialTicks) {
        matrixStack.m_85836_();
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (!(state.m_60734_() instanceof AlterationTable)) {
            return;
        }
        Item item = tile.armorStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85837_(-2.1, 3.3, 0.0);
            double yOffset = Mth.m_144946_((double)((Math.sin(((float)ClientInfo.ticksInGame + ticks) / 20.0f) + 1.0) / 2.0)) * 0.0625;
            if (tile.newPerkTimer >= 0) {
                yOffset = 0.0;
                float percentage = (float)Mth.m_14040_((int)(tile.newPerkTimer - 20)) / 20.0f;
                double smooooooooth = Mth.m_14197_((double)percentage);
                double perkYOffset = 0.625 - smooooooooth * 0.625;
                matrixStack.m_252781_(Axis.f_252436_.m_252977_((float)(Mth.m_14197_((double)((float)tile.newPerkTimer / 40.0f)) * 360.0)));
                matrixStack.m_85837_(0.0, perkYOffset, 0.0);
            }
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_85837_(0.0, yOffset + (double)this.rotForSlot(armorItem.m_40402_()), 0.0);
            this.renderArmorPiece(tile, tile.armorStack, matrixStack, iRenderTypeBuffer, packedLightIn, this.getArmorModel(armorItem.m_40402_()));
        } else {
            Minecraft.m_91087_().m_91291_().m_269128_(tile.armorStack, ItemDisplayContext.FIXED, packedLightIn, packedOverlayIn, matrixStack, iRenderTypeBuffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
        }
        matrixStack.m_85849_();
    }

    public void renderPerks(AlterationTile tile, PoseStack matrixStack, float ticks, MultiBufferSource iRenderTypeBuffer, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float partialTicks) {
        if (tile.perkList.isEmpty()) {
            return;
        }
        for (int i = 0; i < Math.min(3, tile.perkList.size()); ++i) {
            ItemStack perkStack = tile.perkList.get(i);
            if (perkStack.m_41619_()) continue;
            matrixStack.m_85836_();
            matrixStack.m_85837_(-0.25, 0.74 - 0.175 * (double)i, -0.3 - 0.175 * (double)i);
            GeoBone bone = (GeoBone)this.model.getBone("display").get();
            if (bone.getRotZ() != 0.0f) {
                matrixStack.m_252781_(Axis.f_252403_.m_252961_(-bone.getRotZ()));
            }
            if (bone.getRotY() != 0.0f) {
                matrixStack.m_252781_(Axis.f_252436_.m_252961_(-bone.getRotY()));
            }
            if (bone.getRotX() != 0.0f) {
                matrixStack.m_252781_(Axis.f_252529_.m_252961_(-bone.getRotX()));
            }
            GeoBone locBone = (GeoBone)this.model.getBone("top_" + (i + 1)).get();
            RenderUtils.translateToPivotPoint((PoseStack)matrixStack, (CoreGeoBone)locBone);
            matrixStack.m_85841_(0.18f, 0.18f, 0.18f);
            Minecraft.m_91087_().m_91291_().m_269128_(perkStack, ItemDisplayContext.FIXED, packedLightIn, packedOverlayIn, matrixStack, iRenderTypeBuffer, tile.m_58904_(), (int)tile.m_58899_().m_121878_());
            matrixStack.m_85849_();
        }
    }

    public float rotForSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> 0.3f;
            case EquipmentSlot.LEGS -> -0.2f;
            case EquipmentSlot.FEET -> -0.6f;
            default -> 0.0f;
        };
    }

    private ArmorStandArmorModel getArmorModel(EquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private void renderArmorPiece(AlterationTile tile, ItemStack itemstack, PoseStack pPoseStack, MultiBufferSource pBuffer, int packedLightIn, ArmorStandArmorModel armorModel) {
        Item item = itemstack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armoritem = (ArmorItem)item;
        EquipmentSlot pSlot = armoritem.m_40402_();
        Model model = this.getArmorModelHook(itemstack, pSlot, (HumanoidModel)armorModel);
        boolean flag1 = itemstack.m_41790_();
        if (armoritem instanceof DyeableLeatherItem) {
            DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)armoritem;
            int i = dyeableLeatherItem.m_41121_(itemstack);
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            this.renderModel(pPoseStack, pBuffer, packedLightIn, flag1, model, f, f1, f2, this.getArmorResource(itemstack, pSlot, null));
            this.renderModel(pPoseStack, pBuffer, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource(itemstack, pSlot, "overlay"));
        } else {
            this.renderModel(pPoseStack, pBuffer, packedLightIn, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource(itemstack, pSlot, null));
        }
    }

    protected Model getArmorModelHook(ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)Minecraft.m_91087_().f_91074_, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int packedLight, boolean p_117111_, Model pModel, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)pBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        pModel.m_7695_(pPoseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    public ResourceLocation getArmorResource(ItemStack stack, EquipmentSlot slot, @javax.annotation.Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)Minecraft.m_91087_().f_91074_, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    public void actuallyRender(PoseStack stack, AlterationTile tile, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_60734_() != BlockRegistry.ALTERATION_TABLE.get()) {
            return;
        }
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)AlterationTable.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)AlterationTable.FACING);
        stack.m_85836_();
        if (direction == Direction.NORTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.SOUTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(-1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.WEST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(0.0f, 0.0f, -2.0f);
        }
        if (direction == Direction.EAST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(0.0f, 0.0f, 0.0f);
        }
        this.renderSlate(model, (AlterationTile)this.animatable);
        super.actuallyRender(stack, (BlockEntity)tile, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        stack.m_85849_();
    }

    public void renderFinal(PoseStack stack, AlterationTile animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(stack, (GeoAnimatable)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_58904_().m_8055_(animatable.m_58899_()).m_60734_() != BlockRegistry.ALTERATION_TABLE.get()) {
            return;
        }
        if (animatable.m_58904_().m_8055_(animatable.m_58899_()).m_61143_((Property)AlterationTable.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)animatable.m_58904_().m_8055_(animatable.m_58899_()).m_61143_((Property)AlterationTable.FACING);
        Vector3d perkTranslate = new Vector3d(0.0, 0.0, 0.0);
        Quaternionf perkQuat = Axis.f_252436_.m_252977_(-90.0f);
        Vector3d armorTranslate = new Vector3d(0.0, 0.0, 0.0);
        Quaternionf armorQuat = Axis.f_252436_.m_252977_(-90.0f);
        if (direction == Direction.NORTH) {
            perkQuat = Axis.f_252436_.m_252977_(-90.0f);
            perkTranslate = new Vector3d(1.55, 0.0, -0.5);
            armorQuat = Axis.f_252436_.m_252977_(90.0f);
            armorTranslate = new Vector3d(0.6, 0.2, 0.5);
        }
        if (direction == Direction.SOUTH) {
            perkQuat = Axis.f_252436_.m_252977_(90.0f);
            perkTranslate = new Vector3d(0.5, 0.0, 0.5);
            armorQuat = Axis.f_252436_.m_252977_(-90.0f);
            armorTranslate = new Vector3d(1.6, 0.2, -0.5);
        }
        if (direction == Direction.WEST) {
            perkQuat = Axis.f_252436_.m_252977_(0.0f);
            perkTranslate = new Vector3d(1.5, 0.0, 0.5);
            armorQuat = Axis.f_252436_.m_252977_(180.0f);
            armorTranslate = new Vector3d(0.6, 0.2, -0.5);
        }
        if (direction == Direction.EAST) {
            perkQuat = Axis.f_252436_.m_252977_(180.0f);
            perkTranslate = new Vector3d(0.5, 0.0, -0.5);
            armorQuat = Axis.f_252436_.m_252977_(0.0f);
            armorTranslate = new Vector3d(1.6, 0.2, 0.5);
        }
        double ticks = animatable.getTick(animatable);
        stack.m_85836_();
        stack.m_252781_(armorQuat);
        stack.m_85837_(armorTranslate.x, armorTranslate.y, armorTranslate.z);
        if (!(animatable.armorStack.m_41720_() instanceof ArmorItem)) {
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_85837_(-1.5, 1.95, 0.0);
        }
        this.renderArmorStack(animatable, stack, (float)ticks, bufferSource, buffer, packedLight, packedOverlay, partialTick);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252781_(perkQuat);
        stack.m_85837_(perkTranslate.x, perkTranslate.y, perkTranslate.z);
        this.renderPerks(animatable, stack, (float)ticks, bufferSource, buffer, packedLight, packedOverlay, partialTick);
        stack.m_85849_();
    }

    public void renderSlate(BakedGeoModel model, AlterationTile tile) {
        String[] rowNames = new String[]{"top", "mid", "bot"};
        if (tile.armorStack.m_41619_()) {
            for (String s2 : rowNames) {
                this.setSlateRow(model, s2, 0);
            }
            return;
        }
        IPerkHolder<ItemStack> iPerkHolder = PerkUtil.getPerkHolder(tile.armorStack);
        if (!(iPerkHolder instanceof StackPerkHolder)) {
            return;
        }
        StackPerkHolder armorPerkHolder = (StackPerkHolder)iPerkHolder;
        List<PerkSlot> perks = armorPerkHolder.getSlotsForTier();
        for (int i = 0; i < Math.min(perks.size(), rowNames.length); ++i) {
            PerkSlot perkSlot = perks.get(i);
            this.setSlateRow(model, rowNames[i], perkSlot.value);
        }
        List<String> remainingRows = List.of(rowNames);
        remainingRows.subList(perks.size(), remainingRows.size()).forEach(s -> this.setSlateRow(model, (String)s, 0));
    }

    public void setSlateRow(BakedGeoModel model, String loc, int tier) {
        for (int i = 0; i < 4; ++i) {
            if (tier != i) {
                model.getBone(loc + "_" + i).ifPresent(bone -> bone.setHidden(true));
                continue;
            }
            model.getBone(loc + "_" + i).ifPresent(bone -> bone.setHidden(false));
        }
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(new GenericModel("alteration_table").withEmptyAnim());
    }

    public RenderType getRenderType(AlterationTile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public boolean shouldRenderOffScreen(AlterationTile pBlockEntity) {
        return false;
    }
}

