/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.utils;

import com.google.common.primitives.UnsignedInteger;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.utils.forge.ModUtilsImpl;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class ModUtils {
    public static final UnsignedInteger UNSIGNED_TWO = UnsignedInteger.valueOf((long)2L);
    public static final Pattern SPECIAL_COLOR_PATTERN = Pattern.compile("&&([0-9a-fklmnor])");

    public static boolean areProfilesSame(GameProfile first, GameProfile second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getId() != null && second.getId() != null) {
            return first.getId().equals(second.getId());
        }
        return first.getName() != null && second.getName() != null && first.getName().equals(second.getName());
    }

    public static GlobalPos readGlobalPos(CompoundTag tag) {
        ResourceLocation key = ResourceLocation.m_135820_((String)tag.m_128461_("dimension"));
        if (key == null) {
            return null;
        }
        BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_("pos"));
        ResourceKey level = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)key);
        return GlobalPos.m_122643_((ResourceKey)level, (BlockPos)pos);
    }

    public static CompoundTag writeGlobalPos(GlobalPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("dimension", pos.m_122640_().m_135782_().toString());
        tag.m_128356_("pos", pos.m_122646_().m_121878_());
        return tag;
    }

    public static GameProfile readBasicProfile(CompoundTag tag) {
        return new GameProfile(UUID.fromString(tag.m_128461_("id")), tag.m_128461_("name"));
    }

    public static CompoundTag writeBasicProfile(GameProfile profile) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", profile.getId().toString());
        tag.m_128359_("name", profile.getName());
        return tag;
    }

    public static String formatTextColors(String text) {
        return SPECIAL_COLOR_PATTERN.matcher(text).replaceAll(result -> "\u00a7" + result.group(1));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Pair<UUID, Component>> getFakePlayers() {
        return ModUtilsImpl.getFakePlayers();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Component getParsedComponent(Component component, ServerPlayer player) {
        void var1_1;
        return ModUtilsImpl.getParsedComponent(component, (ServerPlayer)var1_1);
    }

    public static <T extends Packet<T>> void sendToAllClientPlayers(T packet, MinecraftServer server) {
        server.m_6846_().m_11314_().forEach(player -> {
            if (NetworkHandler.CHANNEL.canSendPlayerPackets((Player)player)) {
                NetworkHandler.CHANNEL.sendToPlayer(packet, (Player)player);
            }
        });
    }

    public static UUID parseUuidOrNull(String text) {
        try {
            return UUID.fromString(text);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

