/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.handlers.GroupType;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.base.members.Members;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ServerboundSetRolePacket(String role, GroupType type, UUID member) implements Packet<ServerboundSetRolePacket>
{
    public static final ResourceLocation ID = new ResourceLocation("argonauts", "set_role");
    public static final PacketHandler<ServerboundSetRolePacket> HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundSetRolePacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundSetRolePacket> {
        private Handler() {
        }

        public void encode(ServerboundSetRolePacket message, FriendlyByteBuf buffer) {
            buffer.m_130070_(message.role);
            buffer.m_130068_((Enum)message.type);
            buffer.m_130077_(message.member);
        }

        public ServerboundSetRolePacket decode(FriendlyByteBuf buffer) {
            return new ServerboundSetRolePacket(buffer.m_130277_(), (GroupType)buffer.m_130066_(GroupType.class), buffer.m_130259_());
        }

        public PacketContext handle(ServerboundSetRolePacket message) {
            return (player, level) -> CommandHelper.runNetworkAction(player, () -> {
                Group group = null;
                if (message.type == GroupType.GUILD) {
                    group = GuildApi.API.get((ServerPlayer)player);
                } else if (message.type == GroupType.PARTY) {
                    group = PartyApi.API.get(player);
                }
                if (group == null) {
                    return;
                }
                Object member = group.getMember(player);
                if (!((Member)member).hasPermission("roles.members")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                Object selected = ((Members)group.members()).get(message.member);
                if (selected != null && !((Member)selected).getState().isLeader()) {
                    ((Member)selected).setRole(message.role);
                }
            });
        }
    }
}

