/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.compat.cadmus;

import com.mojang.authlib.GameProfile;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMembers;
import earth.terrarium.cadmus.api.claims.InteractionType;
import earth.terrarium.cadmus.api.teams.TeamProvider;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import org.jetbrains.annotations.Nullable;

public class ArgonautsTeamProvider
implements TeamProvider {
    public Set<GameProfile> getTeamMembers(String id, MinecraftServer server) {
        Guild guild = GuildApi.API.get(server, UUID.fromString(id));
        if (guild == null) {
            return new HashSet<GameProfile>();
        }
        return ((GuildMembers)guild.members()).allMembers().stream().map(Member::profile).collect(Collectors.toUnmodifiableSet());
    }

    @Nullable
    public Component getTeamName(String id, MinecraftServer server) {
        Guild guild = GuildApi.API.get(server, UUID.fromString(id));
        return (Component)Optionull.m_269382_((Object)guild, Guild::displayName);
    }

    @Nullable
    public String getTeamId(MinecraftServer server, UUID player) {
        Guild guild = GuildApi.API.getPlayerGuild(server, player);
        return (String)Optionull.m_269382_((Object)guild, g -> "t:" + g.id().toString());
    }

    public boolean isMember(String id, MinecraftServer server, UUID player) {
        Guild guild = GuildApi.API.get(server, UUID.fromString(id));
        if (guild == null) {
            return id.equals(player.toString());
        }
        return ((GuildMembers)guild.members()).isMember(player) || ((GuildMembers)guild.members()).isAllied(player);
    }

    public ChatFormatting getTeamColor(String id, MinecraftServer server) {
        Guild guild = GuildApi.API.get(server, UUID.fromString(id));
        ChatFormatting result = (ChatFormatting)Optionull.m_269278_((Object)guild, Guild::color, (Object)ChatFormatting.AQUA);
        return result == ChatFormatting.RESET ? ChatFormatting.AQUA : result;
    }

    public boolean canBreakBlock(String id, MinecraftServer server, BlockPos pos, UUID player) {
        return this.hasPermission("cadmus.blocks.break", id, server, player);
    }

    public boolean canPlaceBlock(String id, MinecraftServer server, BlockPos pos, UUID player) {
        return this.hasPermission("cadmus.blocks.place", id, server, player);
    }

    public boolean canExplodeBlock(String id, MinecraftServer server, BlockPos pos, Explosion explosion, UUID player) {
        return this.hasPermission("cadmus.blocks.explode", id, server, player);
    }

    public boolean canInteractWithBlock(String id, MinecraftServer server, BlockPos pos, InteractionType type, UUID player) {
        return this.hasPermission("cadmus.blocks.interact", id, server, player);
    }

    public boolean canInteractWithEntity(String id, MinecraftServer server, Entity entity, UUID player) {
        return this.hasPermission("cadmus.entities.interact", id, server, player);
    }

    public boolean canDamageEntity(String id, MinecraftServer server, Entity entity, UUID player) {
        return this.hasPermission("cadmus.entities.damage", id, server, player);
    }

    private boolean hasPermission(String perm, String id, MinecraftServer server, UUID player) {
        if (TeamHelper.isMember((String)id, (MinecraftServer)server, (UUID)player)) {
            return true;
        }
        Guild guild = GuildApi.API.get(server, UUID.fromString(id.substring(2)));
        if (guild == null) {
            return false;
        }
        if (guild.settings().allowFakePlayers() && ((GuildMembers)guild.members()).fakePlayers().contains(player)) {
            return true;
        }
        Party party = PartyApi.API.getPlayerParty(player);
        if (party == null) {
            return false;
        }
        PartyMember member = (PartyMember)((PartyMembers)party.members()).get(player);
        if (member == null) {
            return false;
        }
        if (!member.hasPermission(perm)) {
            return false;
        }
        GuildMember guildMember = (GuildMember)((GuildMembers)guild.members()).get(((PartyMember)((PartyMembers)party.members()).getLeader()).profile().getId());
        if (guildMember == null) {
            return false;
        }
        return ((PartyMembers)party.members()).isMember(player) && guildMember.hasPermission("cadmus.temporary_guild_permissions");
    }

    public void onTeamChanged(MinecraftServer server, String id, UUID player) {
        super.onTeamChanged(server, id);
        server.m_129785_().forEach(l -> ClaimHandler.clear((ServerLevel)l, (String)("p:" + player.toString())));
    }

    public void onTeamRemoved(MinecraftServer server, String id) {
        super.onTeamRemoved(server, id);
        server.m_129785_().forEach(l -> ClaimHandler.clear((ServerLevel)l, (String)("t:" + id)));
    }

    public boolean canModifySettings(String id, Player player) {
        try {
            Guild guild = GuildApi.API.get(player.m_20194_(), UUID.fromString(id));
            if (guild == null) {
                return false;
            }
            GuildMember member = guild.getMember(player.m_20148_());
            return member != null && member.hasPermission("manage.settings");
        }
        catch (Exception e) {
            return true;
        }
    }
}

