/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.party;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.party.PartyCommandHelper;
import earth.terrarium.argonauts.common.constants.ConstantComponents;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.party.members.PartyMember;
import earth.terrarium.argonauts.common.handlers.party.settings.DefaultPartySettings;
import earth.terrarium.argonauts.common.menus.party.PartySettingsContent;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundOpenPartySettingsMenuPacket;
import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PartySettingsCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(PartySettingsCommands.settings())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").then(PartySettingsCommands.publicParty())).then(PartySettingsCommands.friendlyFire())).then(PartySettingsCommands.passiveTeleport())).then(PartySettingsCommands.list())));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> publicParty() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"publicParty").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                boolean publicParty = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                PartyMember member = (PartyMember)party.getMember((Player)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("public", publicParty);
                player.m_5661_(PartySettingsCommands.setCurrentComponent("publicParty", publicParty), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                boolean publicParty = party.settings().settings().contains("public");
                player.m_5661_(PartySettingsCommands.getCurrentComponent("publicParty", publicParty), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> friendlyFire() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"friendlyFire").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                boolean friendlyFire = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                PartyMember member = (PartyMember)party.getMember((Player)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("friendly_fire", friendlyFire);
                player.m_5661_(PartySettingsCommands.setCurrentComponent("friendlyFire", friendlyFire), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                boolean friendlyFire = party.settings().settings().contains("friendly_fire");
                player.m_5661_(PartySettingsCommands.getCurrentComponent("friendlyFire", friendlyFire), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> passiveTeleport() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"passiveTeleport").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                boolean passiveTeleport = BoolArgumentType.getBool((CommandContext)context, (String)"value");
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                PartyMember member = (PartyMember)party.getMember((Player)player);
                if (!member.hasPermission("manage.settings")) {
                    throw MemberException.NO_PERMISSIONS;
                }
                party.settings().set("passive_tp", passiveTeleport);
                player.m_5661_(PartySettingsCommands.setCurrentComponent("passiveTeleport", passiveTeleport), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Party party = PartyCommandHelper.getPartyOrThrow((Player)player, false);
                boolean passiveTeleport = party.settings().settings().contains("passive_tp");
                player.m_5661_(PartySettingsCommands.getCurrentComponent("passiveTeleport", passiveTeleport), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> list() {
        return Commands.m_82127_((String)"list").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> PartySettingsCommands.openSettingsScreen(player));
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> settings() {
        return Commands.m_82127_((String)"settings").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> PartySettingsCommands.openSettingsScreen(player));
            return 1;
        });
    }

    public static void openSettingsScreen(ServerPlayer player) throws MemberException {
        if (!NetworkHandler.CHANNEL.canSendPlayerPackets((Player)player)) {
            throw MemberException.NOT_INSTALLED_ON_CLIENT;
        }
        Party party = PartyApi.API.get((Player)player);
        if (party == null) {
            throw MemberException.YOU_ARE_NOT_IN_PARTY;
        }
        PartyMember member = (PartyMember)party.getMember((Player)player);
        if (!member.hasPermission("manage.settings")) {
            throw MemberException.NO_PERMISSIONS;
        }
        Object2BooleanLinkedOpenHashMap settings = new Object2BooleanLinkedOpenHashMap();
        HashSet<String> oldSettings = new HashSet<String>(party.settings().settings());
        for (String setting : DefaultPartySettings.PARTY_SETTINGS) {
            settings.put((Object)setting, oldSettings.contains(setting));
            oldSettings.remove(setting);
        }
        for (String setting : oldSettings) {
            settings.put((Object)setting, false);
        }
        NetworkHandler.CHANNEL.sendToPlayer((Packet)new ClientboundOpenPartySettingsMenuPacket(new PartySettingsContent(true, (Object2BooleanMap<String>)settings), ConstantComponents.PARTY_SETTING_TITLE), (Player)player);
    }

    private static Component getCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.current", (Object[])new Object[]{command, value});
    }

    private static Component setCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.set", (Object[])new Object[]{command, value});
    }
}

