/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.guild.GuildCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;

public final class GuildSettingsCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"guild").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").then(GuildSettingsCommands.hq())).then(GuildSettingsCommands.displayName())).then(GuildSettingsCommands.motd())).then(GuildSettingsCommands.color())).then(GuildSettingsCommands.allowFakePlayers())));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> hq() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"hq").then(Commands.m_82127_((String)"set").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                BlockPos pos = player.m_20183_();
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.m_20148_())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setHq(GlobalPos.m_122643_((ResourceKey)player.m_9236_().m_46472_(), (BlockPos)pos));
                player.m_5661_(GuildSettingsCommands.setCurrentComponent("hq", player.m_9236_().m_46472_().m_135782_() + ", " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_()), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                Optional<GlobalPos> hq = guild.settings().hq();
                if (hq.isEmpty()) {
                    throw MemberException.HQ_NOT_SET;
                }
                hq.ifPresent(hq1 -> player.m_5661_(GuildSettingsCommands.getCurrentComponent("hq", hq1.m_122640_().m_135782_() + ", " + hq1.m_122646_().m_123341_() + ", " + hq1.m_122646_().m_123342_() + ", " + hq1.m_122646_().m_123343_()), false));
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> displayName() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"displayName").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String displayName = ModUtils.formatTextColors(StringArgumentType.getString((CommandContext)context, (String)"value"));
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.m_20148_())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setDisplayName((Component)Component.m_237113_((String)displayName));
                player.m_5661_(GuildSettingsCommands.setCurrentComponent("displayName", displayName), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.m_5661_(GuildSettingsCommands.getCurrentComponent("displayName", guild.displayName()), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> motd() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"motd").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String name = ModUtils.formatTextColors(StringArgumentType.getString((CommandContext)context, (String)"value")).replace("\\n", "\n");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.m_20148_())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setMotd((Component)Component.m_237113_((String)name));
                player.m_5661_(GuildSettingsCommands.setCurrentComponent("motd", name), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.m_5661_(GuildSettingsCommands.getCurrentComponent("motd", guild.motd()), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> color() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"color").then(Commands.m_82129_((String)"value", (ArgumentType)ColorArgument.m_85463_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                ChatFormatting color = ColorArgument.m_85466_((CommandContext)context, (String)"value");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                if (!((GuildMembers)guild.members()).isLeader(player.m_20148_())) {
                    throw MemberException.YOU_ARE_NOT_THE_OWNER_OF_GUILD;
                }
                guild.settings().setColor(color);
                player.m_5661_(GuildSettingsCommands.setCurrentComponent("color", guild.color().name().toLowerCase(Locale.ROOT)), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                player.m_5661_(GuildSettingsCommands.getCurrentComponent("color", guild.color().name().toLowerCase(Locale.ROOT)), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> allowFakePlayers() {
        return Commands.m_82127_((String)"allowFakePlayers").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                guild.settings().setAllowFakePlayers(!guild.settings().allowFakePlayers());
                player.m_5661_(GuildSettingsCommands.getCurrentComponent("allowFakePlayers", String.valueOf(guild.settings().allowFakePlayers())), false);
            });
            return 1;
        });
    }

    private static Component getCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.current", (Object[])new Object[]{command, value});
    }

    private static Component setCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.argonauts.settings.set", (Object[])new Object[]{command, value});
    }
}

