/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.commands.guild;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.common.commands.base.CommandHelper;
import earth.terrarium.argonauts.common.commands.guild.GuildCommandHelper;
import earth.terrarium.argonauts.common.handlers.base.MemberException;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMember;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import earth.terrarium.argonauts.common.utils.ModUtils;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.server.level.ServerPlayer;

public class GuildFakePlayerCommands {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_165916_(ModUtils.getFakePlayers(), (SuggestionsBuilder)builder, pair -> ((UUID)pair.getFirst()).toString(), Pair::getSecond);
    private static final SuggestionProvider<CommandSourceStack> CURRENT_FAKE_PLAYERS_SUGGESTION_PROVIDER = (context, builder) -> {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
        return SharedSuggestionProvider.m_82981_(((GuildMembers)guild.members()).fakePlayers().stream().map(UUID::toString), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"guild").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"fakeplayers").then(GuildFakePlayerCommands.add())).then(GuildFakePlayerCommands.remove())));
    }

    public static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> add() {
        return Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests(SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                UUID id = UuidArgument.m_113853_((CommandContext)context, (String)"uuid");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                GuildMember guildMember = (GuildMember)((GuildMembers)guild.members()).get(player.m_20148_());
                if (guildMember == null) {
                    throw MemberException.YOU_ARE_NOT_IN_GUILD;
                }
                if (!guildMember.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                ((GuildMembers)guild.members()).fakePlayers().add(id);
            });
            return 1;
        }));
    }

    public static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> remove() {
        return Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).suggests(CURRENT_FAKE_PLAYERS_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                UUID id = UuidArgument.m_113853_((CommandContext)context, (String)"uuid");
                Guild guild = GuildCommandHelper.getGuildOrThrow(player, false);
                GuildMember guildMember = (GuildMember)((GuildMembers)guild.members()).get(player.m_20148_());
                if (guildMember == null) {
                    throw MemberException.YOU_ARE_NOT_IN_GUILD;
                }
                if (!guildMember.hasPermission("manage.members")) {
                    throw MemberException.YOU_CANT_MANAGE_MEMBERS_IN_GUILD;
                }
                ((GuildMembers)guild.members()).fakePlayers().remove(id);
            });
            return 1;
        }));
    }
}

