/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.embeds;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.Window;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.utils.WebUtils;
import earth.terrarium.argonauts.client.screens.chat.embeds.Embeder;
import earth.terrarium.argonauts.client.screens.chat.embeds.ImageEmbeder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class YoutubeVideoEmbeder
implements Embeder {
    private static final Map<String, YoutubeVideoInfo> INFO = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());

    @Override
    public void handle(GuiGraphics graphics, URI uri) {
        YoutubeVideoEmbeder.resolve(uri.toString());
        YoutubeVideoInfo info = INFO.get(uri.toString());
        if (info == null) {
            return;
        }
        String title = info.title;
        String author = info.author;
        String thumbnail = info.image;
        if (title == null || author == null || thumbnail == null || !info.future.isDone()) {
            return;
        }
        ResourceLocation texture = ImageEmbeder.resolveImage(thumbnail);
        MouseHandler mouse = Minecraft.m_91087_().f_91067_;
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        double mouseX = mouse.m_91589_() * (double)mainWindow.m_85445_() / (double)mainWindow.m_85443_();
        double mouseY = mouse.m_91594_() * (double)mainWindow.m_85446_() / (double)mainWindow.m_85444_();
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.m_85837_(mouseX, mouseY, 200.0);
            graphics.m_280163_(texture, 5, 5, 0.0f, 0.0f, info.width, info.height, info.width, info.height);
            graphics.m_280509_(5, 5 + info.height - 25, 5 + info.width, 5 + info.height, Integer.MIN_VALUE);
            try (CloseableScissorStack ignored = RenderUtils.createScissor((Minecraft)Minecraft.m_91087_(), (GuiGraphics)graphics, (int)5, (int)(5 + info.height - 25), (int)info.width, (int)25);){
                graphics.m_280056_(Minecraft.m_91087_().f_91062_, author, 8, 5 + info.height - 25 + 2, 0xFFFFFF, false);
                List split = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)title), info.width - 20);
                if (!split.isEmpty()) {
                    int draw = graphics.m_280649_(Minecraft.m_91087_().f_91062_, (FormattedCharSequence)split.get(0), 8, 5 + info.height - 25 + 13, 43247, false);
                    if (split.size() > 1) {
                        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "...", draw, 5 + info.height - 25 + 13, 43247, false);
                    }
                }
            }
        }
    }

    private static void resolve(String url) {
        if (INFO.containsKey(url)) {
            return;
        }
        INFO.put(url, new YoutubeVideoInfo(CompletableFuture.runAsync(() -> {
            try {
                JsonObject object = WebUtils.getJson((String)("https://www.youtube.com/oembed?url=" + url + "&format=json"), (boolean)true);
                if (object == null) {
                    return;
                }
                YoutubeVideoInfo info = INFO.get(url);
                if (info == null) {
                    return;
                }
                info.update(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, Util.m_183991_())));
    }

    private static class YoutubeVideoInfo {
        private final CompletableFuture<?> future;
        private String image;
        private String title;
        private String author;
        private int height;
        private int width;

        public YoutubeVideoInfo(CompletableFuture<?> future) {
            this.future = future;
        }

        public void update(JsonObject object) {
            this.title = object.get("title").getAsString();
            this.author = object.get("author_name").getAsString();
            this.image = object.get("thumbnail_url").getAsString();
            this.height = object.get("thumbnail_height").getAsInt();
            this.width = object.get("thumbnail_width").getAsInt();
            if (this.height > 200 || this.width > 250) {
                this.height = (int)((float)this.height * 0.5f);
                this.width = (int)((float)this.width * 0.5f);
            }
        }
    }
}

