/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat.embeds;

import com.mojang.blaze3d.platform.Window;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.argonauts.client.rendering.UrlTexture;
import earth.terrarium.argonauts.client.screens.chat.embeds.Embeder;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class ImageEmbeder
implements Embeder {
    @Override
    public void handle(GuiGraphics graphics, URI uri) {
        if (!ImageEmbeder.validPath(uri.getPath())) {
            return;
        }
        String url = uri.toString();
        ResourceLocation texture = ImageEmbeder.resolveImage(url);
        UrlTexture.Info info = UrlTexture.getInfo(url);
        MouseHandler mouse = Minecraft.m_91087_().f_91067_;
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        double mouseX = mouse.m_91589_() * (double)mainWindow.m_85445_() / (double)mainWindow.m_85443_();
        double mouseY = mouse.m_91594_() * (double)mainWindow.m_85446_() / (double)mainWindow.m_85444_();
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.m_85837_(mouseX, mouseY, 200.0);
            graphics.m_280163_(texture, 5, 5, 0.0f, 0.0f, info.displayWidth(), info.displayHeight(), info.displayWidth(), info.displayHeight());
        }
    }

    private static boolean validPath(String path) {
        if (path.endsWith(".png") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".gif")) {
            return true;
        }
        return !path.contains(".");
    }

    public static ResourceLocation resolveImage(String url) {
        ResourceLocation id = UrlTexture.getTextureId(url);
        TextureManager manager = Minecraft.m_91087_().m_91097_();
        AbstractTexture texture = manager.m_174786_(id, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (texture == MissingTextureAtlasSprite.m_118080_()) {
            manager.m_118495_(id, (AbstractTexture)new UrlTexture(url));
        }
        return id;
    }
}

