/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.client.screens.chat;

import com.google.common.primitives.UnsignedInteger;
import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.utils.MouseLocationFix;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.argonauts.client.screens.base.BaseScreen;
import earth.terrarium.argonauts.client.screens.chat.embeds.EmbedHandler;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatMemberList;
import earth.terrarium.argonauts.client.screens.chat.messages.ChatMessagesList;
import earth.terrarium.argonauts.client.utils.ClientUtils;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import earth.terrarium.argonauts.common.menus.ChatContent;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ServerboundChatWindowPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomChatScreen
extends BaseScreen<ChatContent> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("argonauts", "textures/gui/chat.png");
    private ChatMessagesList messages;
    private EditBox box;
    private String embedUrl = null;
    private final Logger logger = LoggerFactory.getLogger((String)"Argonauts Chat");

    public CustomChatScreen(ChatContent menuContent, Component displayName) {
        super(menuContent, displayName, 276, 166);
    }

    @Override
    protected void m_7856_() {
        MouseLocationFix.fix(((Object)((Object)this)).getClass());
        super.m_7856_();
        this.messages = (ChatMessagesList)this.m_142416_((GuiEventListener)new ChatMessagesList(this.leftPos + 8, this.topPos + 18));
        this.messages.update(((ChatContent)this.menuContent).messages());
        ((ChatMemberList)this.m_142416_((GuiEventListener)new ChatMemberList(this.leftPos + 198, this.topPos + 18))).update(((ChatContent)this.menuContent).usernames());
        this.box = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 9, this.topPos + 149, 183, 9, Component.m_130674_((String)"")));
        this.box.m_94199_(512);
        this.box.m_94182_(false);
    }

    public void addMessage(UnsignedInteger id, ChatMessage message) {
        int childrenSize;
        int amount = (int)this.messages.getScrollAmount();
        if (amount == (childrenSize = this.messages.m_6702_().size() * 10) - 120 && childrenSize >= 120 || amount == 0 && childrenSize < 120) {
            ListEntry entry = this.messages.addMessage(id, message);
            this.messages.ensureVisible(entry);
        } else {
            this.messages.addMessage(id, message);
        }
        if (!Minecraft.m_91087_().m_91090_()) {
            this.logger.info(String.format("[%s] <%s> %s", ((ChatContent)this.menuContent).type().name(), message.profile().getName(), message.message()));
        }
    }

    public void deleteMessage(UnsignedInteger id) {
        this.messages.deleteMessage(id);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics graphics, int i, int j, float f) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, i, j, f);
        if (this.embedUrl != null) {
            EmbedHandler.handle(graphics, this.embedUrl);
            this.embedUrl = null;
        }
    }

    @Override
    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280056_(this.f_96547_, "Chat", this.titleLabelX, this.titleLabelY, 0x404040, false);
        int online = ((ChatContent)this.menuContent).usernames().size();
        graphics.m_280056_(this.f_96547_, online + "/" + ((ChatContent)this.menuContent).maxUsers() + " Online", 198, this.titleLabelY, 0x404040, false);
        String charCount = ClientUtils.getSmallNumber(512 - this.box.m_94155_().length());
        graphics.m_280056_(this.f_96547_, charCount, 191 - this.f_96547_.m_92895_(charCount), 137, 0x404040, false);
    }

    @Override
    protected void renderBg(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int k = (this.f_96543_ - this.imageWidth) / 2;
        int l = (this.f_96544_ - this.imageHeight) / 2;
        graphics.m_280163_(CONTAINER_BACKGROUND, k, l, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
    }

    public void m_7861_() {
        super.m_7861_();
        MouseLocationFix.setFix(clas -> clas == CustomChatScreen.class);
    }

    public boolean m_7933_(int i, int j, int k) {
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof EditBox) {
            EditBox editBox = (EditBox)guiEventListener;
            if (i == 257 && !editBox.m_94155_().isEmpty()) {
                NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundChatWindowPacket(editBox.m_94155_(), ((ChatContent)this.menuContent).type()));
                editBox.m_94144_("");
                return true;
            }
        }
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(i, j)) {
            return true;
        }
        return super.m_7933_(i, j, k);
    }

    public void setEmbedUrl(String url) {
        this.embedUrl = url;
    }

    public static void open(ChatContent menuContent, Component displayName) {
        Minecraft.m_91087_().m_91152_((Screen)new CustomChatScreen(menuContent, displayName));
    }
}

