/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.DinosaurEggBlock;
import com.github.alexmodguy.alexscaves.server.block.MultipleDinosaurEggsBlock;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.SubterranodonEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class SubterranodonRoostFeature
extends Feature<NoneFeatureConfiguration> {
    public SubterranodonRoostFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomSource;
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        Direction direction = this.getCliffDirection(level, pos, randomSource = context.m_225041_());
        if (direction != null) {
            int centerLength = 2 + randomSource.m_188503_(1);
            int maxLeft = 2 + randomSource.m_188503_(5);
            int maxRight = 2 + randomSource.m_188503_(5);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutableCopy = new BlockPos.MutableBlockPos();
            mutableBlockPos.m_122190_((Vec3i)pos);
            mutableBlockPos.m_122175_(direction.m_122428_(), maxRight);
            float radius = (float)(maxLeft + maxRight) / 2.0f;
            for (int i = -maxRight; i < maxLeft; ++i) {
                float dist = (float)Math.abs(i) / radius;
                mutableBlockPos.m_122173_(direction.m_122427_());
                mutableCopy.m_122190_((Vec3i)mutableBlockPos);
                int length = (int)Math.round((double)centerLength * Math.sqrt(1.0f - dist));
                for (int j = 0; j < length + 1; ++j) {
                    this.fillCliff(level, mutableBlockPos, direction, length, j == 0, randomSource);
                    mutableBlockPos.m_122190_((Vec3i)mutableCopy);
                    mutableBlockPos.m_122184_(0, -j, 0);
                    mutableBlockPos.m_122175_(direction.m_122424_(), j);
                }
                mutableBlockPos.m_122190_((Vec3i)mutableCopy);
            }
            return true;
        }
        return false;
    }

    private void fillCliff(WorldGenLevel level, BlockPos.MutableBlockPos cliff, Direction direction, float length, boolean decorate, RandomSource randomSource) {
        int maxBack = (int)(Math.ceil(length) + 1.0);
        for (int distBack = 0; level.m_8055_((BlockPos)cliff).m_60795_() && distBack < maxBack; ++distBack) {
            cliff.m_122173_(direction.m_122424_());
        }
        BlockState behind = level.m_8055_((BlockPos)cliff);
        BlockState set = behind.m_60713_(Blocks.f_50062_) ? Blocks.f_50062_.m_49966_() : ((Block)ACBlockRegistry.LIMESTONE.get()).m_49966_();
        cliff.m_122173_(direction);
        int i = 0;
        while ((double)i < Math.ceil(length)) {
            if (level.m_8055_((BlockPos)cliff).m_60795_()) {
                if (decorate && randomSource.m_188503_(3) == 0 && i == 0) {
                    level.m_7731_((BlockPos)cliff, set, 3);
                    level.m_7731_(cliff.m_7494_(), ((Block)ACBlockRegistry.FERN_THATCH.get()).m_49966_(), 3);
                } else if (decorate && randomSource.m_188503_(7) == 0) {
                    BlockPos immutable = cliff.m_7949_();
                    level.m_7731_(immutable.m_7495_(), set, 3);
                    for (Direction direction1 : ACMath.HORIZONTAL_DIRECTIONS) {
                        BlockPos corner = immutable.m_121945_(direction1);
                        level.m_7731_(corner, ((Block)ACBlockRegistry.FERN_THATCH.get()).m_49966_(), 3);
                        level.m_7731_(corner.m_7495_(), set, 3);
                    }
                    level.m_7731_(immutable, ((Block)ACBlockRegistry.FERN_THATCH.get()).m_49966_(), 3);
                    level.m_7731_(immutable.m_7494_(), (BlockState)((BlockState)((Block)ACBlockRegistry.SUBTERRANODON_EGG.get()).m_49966_().m_61124_((Property)MultipleDinosaurEggsBlock.EGGS, (Comparable)Integer.valueOf(1 + randomSource.m_188503_(3)))).m_61124_((Property)DinosaurEggBlock.NEEDS_PLAYER, (Comparable)Boolean.valueOf(true)), 3);
                    Vec3 spawnMobAt = Vec3.m_82512_((Vec3i)immutable.m_121945_(direction).m_7494_());
                    SubterranodonEntity subterranodon = (SubterranodonEntity)((EntityType)ACEntityRegistry.SUBTERRANODON.get()).m_20615_((Level)level.m_6018_());
                    subterranodon.m_146884_(spawnMobAt);
                    subterranodon.m_21446_(immutable.m_7494_(), 20 + randomSource.m_188503_(20));
                    if (!level.m_186437_((Entity)subterranodon, subterranodon.m_20191_())) {
                        level.m_7967_((Entity)subterranodon);
                    }
                } else {
                    level.m_7731_((BlockPos)cliff, set, 3);
                    if (decorate && randomSource.m_188503_(5) == 0) {
                        level.m_7731_(cliff.m_7494_(), Blocks.f_152543_.m_49966_(), 3);
                    }
                }
            }
            cliff.m_122173_(direction);
            ++i;
        }
    }

    @Nullable
    private Direction getCliffDirection(WorldGenLevel level, BlockPos pos, RandomSource randomSource) {
        if (!level.m_8055_(pos.m_7495_()).m_60795_() || !level.m_8055_(pos.m_7494_()).m_60795_()) {
            return null;
        }
        ArrayList<Direction> possiblities = new ArrayList<Direction>();
        for (Direction possible : ACMath.HORIZONTAL_DIRECTIONS) {
            BlockState cliffState;
            BlockPos check = pos.m_121945_(possible);
            if (!this.isSameChunk(pos, check) || !(cliffState = level.m_8055_(check)).m_60783_((BlockGetter)level, check, possible.m_122424_()) || cliffState.m_204336_(ACTagRegistry.VOLCANO_BLOCKS)) continue;
            possiblities.add(possible.m_122424_());
        }
        return SubterranodonRoostFeature.selectDirection(possiblities, randomSource);
    }

    private boolean isSameChunk(BlockPos pos, BlockPos check) {
        return SectionPos.m_123171_((int)pos.m_123341_()) == SectionPos.m_123171_((int)check.m_123341_()) && SectionPos.m_123171_((int)pos.m_123343_()) == SectionPos.m_123171_((int)check.m_123343_());
    }

    private static Direction selectDirection(List<Direction> directionList, RandomSource randomSource) {
        if (directionList.size() <= 0) {
            return null;
        }
        if (directionList.size() <= 1) {
            return directionList.get(0);
        }
        return directionList.get(randomSource.m_188503_(directionList.size() - 1));
    }
}

