/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.TreeStarBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GiantAncientTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public GiantAncientTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        BlockPos treeBottom = context.m_159777_();
        int maxHeight = 20 + randomsource.m_188503_(10);
        int trunkThickness = 3;
        if (!this.checkCanTreePlace(level, treeBottom, maxHeight)) {
            return false;
        }
        BlockPos trunkRoot = treeBottom.m_6625_(2);
        int lastLeavesY = 0;
        for (int height = 0; height <= maxHeight; ++height) {
            trunkRoot = trunkRoot.m_7494_();
            double radShrink = 1.0 - 0.8 * Math.pow((float)height / (float)maxHeight, 2.0);
            double leavesShrink = 1.0f - 0.45f * ((float)height / (float)maxHeight);
            for (int width = -((int)Math.floor((float)trunkThickness / 2.0f)); width < (int)Math.ceil((float)trunkThickness / 2.0f); ++width) {
                for (int length = -((int)Math.floor((float)trunkThickness / 2.0f)); length < (int)Math.ceil((float)trunkThickness / 2.0f); ++length) {
                    BlockPos logPos = trunkRoot.m_7918_(width, 0, length);
                    if (!(trunkRoot.m_203202_((double)logPos.m_123341_(), (double)trunkRoot.m_123342_(), (double)logPos.m_123343_()) <= (double)(trunkThickness * trunkThickness) / 4.0 * radShrink) || !GiantAncientTreeFeature.canReplace(level.m_8055_(logPos))) continue;
                    level.m_7731_(logPos, Blocks.f_50002_.m_49966_(), 3);
                }
            }
            if (height != maxHeight && (height <= 3 || height - lastLeavesY <= 4 + randomsource.m_188503_(2) && randomsource.m_188503_(5) != 0)) continue;
            lastLeavesY = height;
            GiantAncientTreeFeature.drawLeafOrb(level, trunkRoot.m_7918_((int)((double)(randomsource.m_188503_(2) - 1) * radShrink), 0, (int)((double)(randomsource.m_188503_(2) - 1) * radShrink)), randomsource, ((Block)ACBlockRegistry.ANCIENT_LEAVES.get()).m_49966_(), (int)Math.ceil(4.0 * leavesShrink) + randomsource.m_188503_(2), 1 + randomsource.m_188503_(2), (int)Math.ceil(4.0 * leavesShrink) + randomsource.m_188503_(2));
        }
        return true;
    }

    private boolean checkCanTreePlace(WorldGenLevel level, BlockPos treeBottom, int height) {
        BlockState below = level.m_8055_(treeBottom.m_7495_());
        if (!below.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (GiantAncientTreeFeature.canReplace(level.m_8055_(treeBottom.m_6630_(i)))) continue;
            return false;
        }
        BlockPos treeTop = treeBottom.m_6630_(height);
        for (BlockPos checkLeaf : BlockPos.m_121940_((BlockPos)treeTop.m_7918_(-3, -1, -3), (BlockPos)treeTop.m_7918_(3, 3, 3))) {
            if (GiantAncientTreeFeature.canReplace(level.m_8055_(checkLeaf))) continue;
            return false;
        }
        return true;
    }

    private static void drawLeafOrb(WorldGenLevel level, BlockPos center, RandomSource random, BlockState blockState, int radiusX, int radiusY, int radiusZ) {
        double equalRadius = (double)(radiusX + radiusY + radiusZ) / 3.0;
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY / 3; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    Direction dir;
                    BlockPos starPos;
                    BlockPos fill = center.m_7918_(x, y, z);
                    if (!(fill.m_203202_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()) <= equalRadius * equalRadius - (double)(random.m_188501_() * 2.0f)) || !GiantAncientTreeFeature.canReplace(level.m_8055_(fill))) continue;
                    level.m_7731_(fill, blockState, 3);
                    if (random.m_188503_(5) != 0 || !level.m_8055_(starPos = fill.m_121945_(dir = Direction.m_235672_((RandomSource)random))).m_60795_()) continue;
                    level.m_7731_(starPos, (BlockState)((Block)ACBlockRegistry.TREE_STAR.get()).m_49966_().m_61124_((Property)TreeStarBlock.FACING, (Comparable)dir), 3);
                }
            }
        }
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_() || state.m_60713_((Block)ACBlockRegistry.ANCIENT_LEAVES.get()) || state.m_60713_((Block)ACBlockRegistry.TREE_STAR.get())) && state.m_60819_().m_76178_() && !state.m_204336_(ACTagRegistry.UNMOVEABLE);
    }
}

