/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.GumWormAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GumWormDestroyGobthumperGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GumWormDigRandomlyGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GumWormLeapRandomlyGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.GumWormRidingGoal;
import com.github.alexmodguy.alexscaves.server.entity.item.CandyCaneHookEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.server.entity.collision.ICustomCollisions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;

public class GumWormEntity
extends Monster
implements ICustomCollisions,
KaijuMob,
ShakesScreen {
    private static final EntityDataAccessor<Boolean> Z_ROT_DIRECTION = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEAPING = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BITING = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> TARGET_DIG_PITCH = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> TEMP_SUMMON = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> GOBTHUMPER_POS = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> RIDING_SEGMENT_ID = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> RIDING_SEGMENT_UUID = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> LEFT_HOOK_ID = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIGHT_HOOK_ID = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIDER_LEAP_TIME = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RIDER_LEAP_TIME_MAX = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> VALID_RIDER = SynchedEntityData.m_135353_(GumWormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private double surfaceY;
    private float prevZRot;
    private float zRot;
    private float prevMouthOpenProgress;
    private float mouthOpenProgress;
    private Vec3 surfacePosition;
    private Vec3 prevSurfacePosition;
    public int timeBetweenAttacks = 0;
    public int leapAttackCooldown = 0;
    private float prevDigPitch;
    private float digPitch;
    private float prevScreenShakeAmount;
    private float screenShakeAmount;
    private int ridingModeTicks;
    private int recentlyLeaptTicks;
    private int forceMouthOpenTicks;
    private Player ridingPlayer;
    private int attackNoiseCooldown;
    private int stopDiggingNoiseCooldown;
    private boolean wasDiggingLastTick;
    private int outOfGroundTime = 0;

    public GumWormEntity(EntityType type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveController();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new GumWormRidingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GumWormAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GumWormDestroyGobthumperGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GumWormLeapRandomlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GumWormDigRandomlyGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.15).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 9.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    public static boolean checkGumWormSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return GumWormEntity.m_219013_(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && randomSource.m_188503_(6) == 0;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(Z_ROT_DIRECTION, (Object)false);
        this.f_19804_.m_135372_(LEAPING, (Object)false);
        this.f_19804_.m_135372_(BITING, (Object)false);
        this.f_19804_.m_135372_(TARGET_DIG_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TEMP_SUMMON, (Object)false);
        this.f_19804_.m_135372_(GOBTHUMPER_POS, Optional.empty());
        this.f_19804_.m_135372_(RIDING_SEGMENT_ID, (Object)-1);
        this.f_19804_.m_135372_(RIDING_SEGMENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(LEFT_HOOK_ID, (Object)-1);
        this.f_19804_.m_135372_(RIGHT_HOOK_ID, (Object)-1);
        this.f_19804_.m_135372_(RIDER_LEAP_TIME_MAX, (Object)1);
        this.f_19804_.m_135372_(RIDER_LEAP_TIME, (Object)0);
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(VALID_RIDER, (Object)false);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.4f * dimensions.f_20378_;
    }

    protected PathNavigation m_6037_(Level level) {
        return new Navigator((Mob)this, level);
    }

    public float getMouthOpenProgress(float partialTicks) {
        return (this.prevMouthOpenProgress + (this.mouthOpenProgress - this.prevMouthOpenProgress) * partialTicks) * 0.1f;
    }

    public float getBodyZRot(float partialTicks) {
        return this.prevZRot + (this.zRot - this.prevZRot) * partialTicks;
    }

    public float m_146909_() {
        return this.digPitch;
    }

    public boolean m_6785_(double distanceSq) {
        return distanceSq < 65536.0;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevSurfacePosition = this.surfacePosition;
        this.prevScreenShakeAmount = this.screenShakeAmount;
        this.prevMouthOpenProgress = this.mouthOpenProgress;
        if (this.isMoving() || this.surfacePosition == null) {
            this.surfacePosition = this.calculateLightAbovePosition();
        }
        if (this.isMouthOpen() && this.mouthOpenProgress < 10.0f) {
            this.mouthOpenProgress += 1.0f;
        }
        if (!this.isMouthOpen() && this.mouthOpenProgress > 0.0f) {
            this.mouthOpenProgress -= 1.0f;
        }
        this.surfaceY = this.calculateSurfaceY();
        this.prevZRot = this.zRot;
        this.prevDigPitch = this.digPitch;
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        LivingEntity target = this.m_5448_();
        if (!(this.m_9236_().f_46443_ || this.isLeaping() && target != null && target.m_6084_() || this.isRidingMode())) {
            this.setTargetDigPitch((float)(-(Mth.m_14136_((double)this.m_20184_().f_82480_, (double)this.m_20184_().m_165924_()) * 57.2957763671875)));
        }
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
        }
        this.digPitch = Mth.m_14148_((float)this.digPitch, (float)this.getTargetDigPitch(), (float)5.0f);
        if (this.isMoving()) {
            this.zRot += (float)((Boolean)this.f_19804_.m_135370_(Z_ROT_DIRECTION) != false ? -10 : 10);
            if (this.f_19796_.m_188503_(300) == 0 && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(Z_ROT_DIRECTION, (Object)this.f_19796_.m_188499_());
            }
            this.screenShakeAmount = 1.5f;
        } else {
            this.zRot = Mth.m_14148_((float)this.zRot, (float)0.0f, (float)2.0f);
        }
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            if (this.isDigging() && this.m_6084_()) {
                AlexsCaves.PROXY.playWorldSound(this, (byte)17);
            }
            this.spawnDustParticles(false);
        } else {
            Entity ridingSegment = this.getRidingSegment();
            this.f_19804_.m_135381_(RIDING_SEGMENT_ID, (Object)(ridingSegment == null ? -1 : ridingSegment.m_19879_()));
            this.f_19804_.m_135381_(DIGGING, (Object)(this.isDigLogic() && !this.isLeaping() ? 1 : 0));
        }
        boolean flag = false;
        BlockState centralState = this.m_9236_().m_8055_(this.m_20183_());
        BlockState centralStateBelow = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if (!GumWormEntity.isSafeDig((BlockGetter)this.m_9236_(), this.m_20183_()) && !this.isLeaping()) {
            if (!GumWormEntity.canDigBlock(centralStateBelow)) {
                this.m_20334_(this.f_19796_.m_188501_() - 0.5f, 0.8f, this.f_19796_.m_188501_() - 0.5f);
                flag = true;
            }
        } else if ((this.surfaceY < this.m_20188_() || centralStateBelow.m_60795_() || this.isInFluidType()) && GumWormEntity.isSafeDig((BlockGetter)this.m_9236_(), this.m_20183_().m_7495_()) && !this.isRidingMode() && !this.isLeaping()) {
            if (this.outOfGroundTime++ > 10) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.5, 0.0));
            }
        } else {
            this.outOfGroundTime = 0;
        }
        if (this.isRidingMode()) {
            boolean flag1 = false;
            int worldHeight = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)this.m_20185_(), (int)this.m_20189_());
            if (this.isTouchingBedrock()) {
                this.f_19794_ = false;
                this.m_20256_(this.m_20184_().m_82490_(0.9).m_82520_(0.0, this.m_20186_() < (double)((float)worldHeight - 6.0f) ? (double)0.2f : (double)-0.2f, 0.0));
            } else if ((centralState.m_280296_() || this.f_19862_ || this.ridingPlayer != null && this.ridingPlayer.m_20186_() > this.m_20186_() + (double)this.m_20206_() + 4.0) && !this.isLeaping()) {
                float upOrDown = 0.4f;
                if (this.surfaceY < (double)((float)worldHeight + 1.0f)) {
                    upOrDown = 0.8f;
                } else if (this.m_20186_() > (double)((float)this.m_9236_().m_141937_() + 3.0f)) {
                    upOrDown = -0.1f;
                }
                this.m_20256_(this.m_20184_().m_82490_(0.9).m_82520_(0.0, (double)upOrDown, 0.0));
                flag = true;
                boolean bl = flag1 = !this.f_19862_;
            }
            if (!(this.isLeaping() || this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_280296_() || this.f_19862_)) {
                flag = true;
                this.m_20256_(this.m_20184_().m_82490_(0.9).m_82520_(0.0, (double)-0.8f, 0.0));
            }
            this.f_19794_ = flag1;
        }
        if (this.wasDiggingLastTick != this.isDigging()) {
            this.wasDiggingLastTick = this.isDigging();
            if (!this.isDigging()) {
                this.attemptPlayStopDiggingNoise();
            }
        }
        this.m_20242_(!this.m_21573_().m_26571_() && !this.isLeaping() && !flag && !this.m_5830_());
        if (this.timeBetweenAttacks > 0) {
            --this.timeBetweenAttacks;
        }
        if (this.leapAttackCooldown > 0) {
            --this.leapAttackCooldown;
        }
        if (this.ridingModeTicks > 0) {
            --this.ridingModeTicks;
        }
        if (this.recentlyLeaptTicks > 0 && !this.isLeaping()) {
            --this.recentlyLeaptTicks;
        }
        if (this.forceMouthOpenTicks > 0) {
            --this.forceMouthOpenTicks;
        }
        if (this.attackNoiseCooldown > 0) {
            --this.attackNoiseCooldown;
        }
        if (this.stopDiggingNoiseCooldown > 0) {
            --this.stopDiggingNoiseCooldown;
        }
    }

    private boolean isTouchingBedrock() {
        float f = 1.0f;
        float f1 = 1.0f;
        AABB aabb = this.m_20191_().m_82377_((double)f, (double)f1, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(collisionShape -> {
            BlockState blockstate = this.m_9236_().m_8055_(collisionShape);
            return blockstate.m_60713_(Blocks.f_50752_);
        });
    }

    public boolean isDigLogic() {
        float f = 4.0f;
        float f1 = 4.0f;
        AABB aabb = this.m_20191_().m_82377_((double)f, (double)f1, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(collisionShape -> {
            BlockState blockstate = this.m_9236_().m_8055_(collisionShape);
            return blockstate.m_280296_() && GumWormEntity.canDigBlock(blockstate);
        });
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_21515_() || this.m_20160_()) {
            this.m_19920_(this.m_6113_(), vec3d);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            this.m_267651_(false);
            this.m_20256_(delta.m_82490_(0.8));
        } else {
            super.m_7023_(vec3d);
        }
    }

    public void onMounted() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122178_(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        while (!this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60713_(Blocks.f_50752_) && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60795_() && mutableBlockPos.m_123342_() < this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_())) {
            mutableBlockPos.m_122184_(0, 1, 0);
        }
        this.m_6034_(this.m_20185_(), mutableBlockPos.m_123342_(), this.m_20189_());
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public float getStepHeight() {
        return this.isRidingMode() ? 5.0f : super.getStepHeight();
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    protected void m_6668_(DamageSource damageSource) {
        boolean flag;
        Entity entity = damageSource.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)damageSource);
        this.captureDrops(new ArrayList());
        boolean bl = flag = this.f_20889_ > 0;
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_7625_(damageSource, flag);
            this.m_7472_(damageSource, i, flag);
        }
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)damageSource, (Collection)drops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            drops.forEach(e -> this.dropItemAtSurface((ItemEntity)e));
        }
    }

    private void dropItemAtSurface(ItemEntity itementity) {
        BlockPos pos = itementity.m_20183_();
        while (this.m_9236_().m_8055_(pos).m_280296_() && pos.m_123342_() < this.m_9236_().m_151558_()) {
            pos = pos.m_7494_();
        }
        itementity.m_6034_(itementity.m_20185_(), (double)((float)pos.m_123342_() + 0.2f), itementity.m_20189_());
        itementity.m_146915_(true);
        itementity.m_32060_();
        this.m_9236_().m_7967_((Entity)itementity);
    }

    public boolean attackAllAroundMouth(float damageAmount, float knockbackAmount) {
        boolean attackedMainTarget = false;
        AABB hurtBox = this.m_20191_().m_82400_(this.isLeaping() ? 3.0 : 1.0);
        LivingEntity target = this.m_5448_();
        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, hurtBox, EntitySelector.f_20406_)) {
            if (living.m_7306_((Entity)this) || living.m_7307_((Entity)this) || this.isRidingPlayer((Entity)living) || living.m_6095_() == this.m_6095_()) continue;
            if (living.m_6469_(damageSource, damageAmount)) {
                living.m_147240_((double)knockbackAmount, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
            }
            if (target == null || !living.m_7306_((Entity)target)) continue;
            attackedMainTarget = true;
        }
        return attackedMainTarget;
    }

    public boolean isRidingPlayer(Entity player) {
        Entity entity;
        Entity entity2;
        Entity entity3 = this.getHook(true);
        if (entity3 instanceof CandyCaneHookEntity) {
            CandyCaneHookEntity hookEntity = (CandyCaneHookEntity)entity3;
            entity2 = hookEntity.m_19749_();
        } else {
            entity2 = null;
        }
        Entity owner1 = entity2;
        Entity entity4 = this.getHook(false);
        if (entity4 instanceof CandyCaneHookEntity) {
            CandyCaneHookEntity hookEntity = (CandyCaneHookEntity)entity4;
            entity = hookEntity.m_19749_();
        } else {
            entity = null;
        }
        Entity owner2 = entity;
        return owner1 != null && owner2 != null && player.m_7306_(owner1);
    }

    public boolean hasARidingHook() {
        return this.getHook(true) != null || this.getHook(false) != null;
    }

    public boolean isRidingMode() {
        return this.ridingModeTicks > 0;
    }

    public Player getRidingPlayer() {
        return this.ridingPlayer;
    }

    public void spawnDustParticles(boolean surface) {
        if (this.surfaceY < this.m_20227_(1.0) && this.m_20227_(1.0) - this.surfaceY < 4.0) {
            BlockPos lightPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.surfaceY - 1.0), (double)this.m_20189_());
            BlockState state = this.m_9236_().m_8055_(lightPos);
            if (!state.m_60795_()) {
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption((ParticleType)ACParticleRegistry.BIG_BLOCK_DUST.get(), state), true, this.m_20208_(0.8f), this.surfaceY + (double)this.f_19796_.m_188501_(), this.m_20262_(0.8f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f), (double)((this.f_19796_.m_188501_() - 0.5f) * 0.2f));
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public boolean getZRotDirection() {
        return (Boolean)this.f_19804_.m_135370_(Z_ROT_DIRECTION);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(LEAPING);
    }

    public void setLeaping(boolean leaping) {
        this.f_19804_.m_135381_(LEAPING, (Object)leaping);
    }

    public boolean isBiting() {
        return (Boolean)this.f_19804_.m_135370_(BITING);
    }

    public void setBiting(boolean biting) {
        this.f_19804_.m_135381_(BITING, (Object)biting);
    }

    public boolean isMoving() {
        return this.m_20184_().m_82553_() > (double)0.1f;
    }

    public boolean isMouthOpen() {
        return this.isLeaping() || this.isBiting();
    }

    public void setTargetDigPitch(float pitch) {
        this.f_19804_.m_135381_(TARGET_DIG_PITCH, (Object)Float.valueOf(pitch));
    }

    public float getTargetDigPitch() {
        return ((Float)this.f_19804_.m_135370_(TARGET_DIG_PITCH)).floatValue();
    }

    public BlockPos getGobthumperPos() {
        return ((Optional)this.f_19804_.m_135370_(GOBTHUMPER_POS)).orElse(null);
    }

    public void setGobthumperPos(BlockPos gobthumperPos) {
        this.f_19804_.m_135381_(GOBTHUMPER_POS, Optional.ofNullable(gobthumperPos));
    }

    public boolean isTempSummon() {
        return (Boolean)this.f_19804_.m_135370_(TEMP_SUMMON);
    }

    public void setTempSummon(boolean tempSummon) {
        this.f_19804_.m_135381_(TEMP_SUMMON, (Object)tempSummon);
    }

    public boolean isValidRider() {
        return (Boolean)this.f_19804_.m_135370_(VALID_RIDER);
    }

    public Entity getRidingSegment() {
        if (!this.m_9236_().f_46443_) {
            UUID id = this.getRidingSegmentUUID();
            return id == null ? null : ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        int id = (Integer)this.f_19804_.m_135370_(RIDING_SEGMENT_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (LEAPING.equals(dataAccessor)) {
            this.attemptPlayStopDiggingNoise();
            this.recentlyLeaptTicks = 15;
        }
        super.m_7350_(dataAccessor);
    }

    public void setRidingSegmentId(int id) {
        this.f_19804_.m_135381_(RIDING_SEGMENT_ID, (Object)id);
    }

    @Nullable
    public UUID getRidingSegmentUUID() {
        return ((Optional)this.f_19804_.m_135370_(RIDING_SEGMENT_UUID)).orElse(null);
    }

    public void setRidingSegmentUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(RIDING_SEGMENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void setHookId(boolean left, int id) {
        this.f_19804_.m_135381_(left ? LEFT_HOOK_ID : RIGHT_HOOK_ID, (Object)id);
    }

    public Entity getHook(boolean left) {
        int id = (Integer)this.f_19804_.m_135370_(left ? LEFT_HOOK_ID : RIGHT_HOOK_ID);
        return id == -1 ? null : this.m_9236_().m_6815_(id);
    }

    public void setRidingLeapTime(int time) {
        this.f_19804_.m_135381_(RIDER_LEAP_TIME, (Object)time);
    }

    public void setMaxRidingLeapTime(int time) {
        this.f_19804_.m_135381_(RIDER_LEAP_TIME_MAX, (Object)time);
    }

    public int getRidingLeapTime() {
        return (Integer)this.f_19804_.m_135370_(RIDER_LEAP_TIME);
    }

    public int getMaxRidingLeapTime() {
        return (Integer)this.f_19804_.m_135370_(RIDER_LEAP_TIME_MAX);
    }

    private Vec3 calculateLightAbovePosition() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122178_(this.m_146903_(), this.m_146904_() - 1, this.m_146907_());
        while (mutableBlockPos.m_123342_() < this.m_9236_().m_151558_() && this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60828_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) {
            mutableBlockPos.m_122184_(0, 1, 0);
        }
        return new Vec3(this.m_20185_(), (double)mutableBlockPos.m_123342_(), this.m_20189_());
    }

    private double calculateSurfaceY() {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122169_((double)Math.round(this.surfacePosition.f_82479_), Math.max(this.surfacePosition.f_82480_, this.m_20227_(1.0)) + 2.0, (double)Math.round(this.surfacePosition.f_82481_));
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60828_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) {
            mutableBlockPos.m_122184_(0, -1, 0);
        }
        return 1.0 + (double)mutableBlockPos.m_123342_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)level);
        }
        GumWormSegmentEntity.createWormSegmentsFor(this, 15 + this.f_19796_.m_188503_(5));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.m_20183_().m_7495_();
        for (int downCount = 0; !world.m_8055_(down).m_60795_() && downCount < 10 && down.m_123342_() > world.m_141937_(); ++downCount) {
            down = down.m_7495_();
        }
        this.m_6034_((float)down.m_123341_() + 0.5f, down.m_123342_() + 1, (float)down.m_123343_() + 0.5f);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        BlockPos gobthumperPos = this.getGobthumperPos();
        if (gobthumperPos != null) {
            compoundTag.m_128405_("GobthumperX", gobthumperPos.m_123341_());
            compoundTag.m_128405_("GobthumperY", gobthumperPos.m_123342_());
            compoundTag.m_128405_("GobthumperZ", gobthumperPos.m_123343_());
        }
        if (this.getRidingSegmentUUID() != null) {
            compoundTag.m_128362_("RidingSegmentUUID", this.getRidingSegmentUUID());
        }
        compoundTag.m_128379_("TempSummon", this.isTempSummon());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("GobthumperX") && compoundTag.m_128441_("GobthumperY") && compoundTag.m_128441_("GobthumperZ")) {
            this.setGobthumperPos(new BlockPos(compoundTag.m_128451_("GobthumperX"), compoundTag.m_128451_("GobthumperY"), compoundTag.m_128451_("GobthumperZ")));
        }
        if (compoundTag.m_128403_("RidingSegmentUUID")) {
            this.setRidingSegmentUUID(compoundTag.m_128342_("RidingSegmentUUID"));
        }
        this.setTempSummon(compoundTag.m_128471_("TempSummon"));
    }

    public boolean canPassThrough(BlockPos blockPos, BlockState blockState, VoxelShape voxelShape) {
        return GumWormEntity.canDigBlock(blockState) && (!this.isRidingMode() || !this.m_9236_().m_8055_(blockPos.m_7494_()).m_280296_() || !blockState.m_60828_((BlockGetter)this.m_9236_(), blockPos));
    }

    public boolean m_20039_(BlockPos pos, BlockState blockstate) {
        return GumWormEntity.canDigBlock(blockstate) && super.m_20039_(pos, blockstate);
    }

    public Vec3 m_20272_(Vec3 vec3) {
        return ICustomCollisions.getAllowedMovementForEntity((Entity)this, (Vec3)vec3);
    }

    public static boolean isSafeDig(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        BlockState below = level.m_8055_(pos.m_7495_());
        return GumWormEntity.canDigBlock(state) && GumWormEntity.canDigBlock(below);
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!(this.m_20365_(entity) || entity instanceof GumWormSegmentEntity || entity.f_19794_ || this.f_19794_ || !((d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - this.m_20185_()), (double)(d1 = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entity.m_20160_() && (entity.m_6094_() || entity instanceof KaijuMob)) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public static boolean canDigBlock(BlockState state) {
        return state.m_60795_() || !state.m_204336_(ACTagRegistry.GUM_WORM_BLOCKS_DIGGING);
    }

    public boolean m_6673_(DamageSource damageSource) {
        return super.m_6673_(damageSource) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268722_) || damageSource.m_276093_(DamageTypes.f_268671_) || damageSource.m_7639_() != null && this.isRidingPlayer(damageSource.m_7639_());
    }

    public Vec3 m_7371_(float f) {
        if (this.surfacePosition != null && this.prevSurfacePosition != null) {
            Vec3 difference = this.surfacePosition.m_82546_(this.prevSurfacePosition);
            return this.prevSurfacePosition.m_82549_(difference.m_82490_((double)f)).m_82520_(0.0, (double)this.m_20192_(), 0.0);
        }
        return super.m_7371_(f);
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public float m_5686_(float partialTick) {
        return this.prevDigPitch + (this.digPitch - this.prevDigPitch) * partialTick;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(6.0);
    }

    public boolean canReach(BlockPos target) {
        int k;
        int j;
        Path path = this.m_21573_().m_7864_(target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_123341_();
        return (double)(i * i + (j = node.f_77272_ - target.m_123342_()) * j + (k = node.f_77273_ - target.m_123343_()) * k) <= 3.0;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        if (this.isLeaping() || !this.isMoving()) {
            return 0.0f;
        }
        return this.prevScreenShakeAmount + (this.screenShakeAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 64.0;
    }

    public Vec3 getHookPosition(int i) {
        Vec3 offset = new Vec3((double)((float)i * -1.0f), -0.5, (double)-1.15f).m_82496_((float)(-Math.toRadians(this.m_146909_()))).m_82524_((float)(-Math.toRadians(this.f_20883_)));
        return this.m_20182_().m_82520_(0.0, (double)(0.5f * this.m_20205_()), 0.0).m_82549_(offset);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.GUM_WORM_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.GUM_WORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.GUM_WORM_DEATH.get();
    }

    protected float m_6121_() {
        return super.m_6121_() * 3.0f;
    }

    public void tickController(Player passenger) {
        this.ridingPlayer = passenger;
        this.f_19804_.m_135381_(VALID_RIDER, (Object)this.isRidingPlayer((Entity)this.ridingPlayer));
        if (this.hasARidingHook()) {
            this.ridingModeTicks = 10;
        }
    }

    public void onPlayerJump(int i) {
        int leapFor = (int)Math.ceil((float)i * 0.2f) + 10;
        this.setRidingLeapTime(leapFor);
        this.setMaxRidingLeapTime(leapFor);
    }

    public boolean recentlyLeapt() {
        return this.recentlyLeaptTicks > 0;
    }

    public void onRidingPlayerAttack() {
        this.forceMouthOpenTicks = 40;
        this.attemptPlayAttackNoise();
    }

    public boolean isMouthForcedOpen() {
        return this.forceMouthOpenTicks > 0;
    }

    public void attemptPlayAttackNoise() {
        if (this.attackNoiseCooldown == 0) {
            this.m_5496_((SoundEvent)ACSoundRegistry.GUM_WORM_ATTACK.get(), this.m_6121_(), this.m_6100_());
            this.attackNoiseCooldown = 70;
        }
    }

    public void attemptPlayStopDiggingNoise() {
        if (this.stopDiggingNoiseCooldown == 0) {
            this.m_5496_((SoundEvent)ACSoundRegistry.GUM_WORM_DIG_STOP.get(), this.m_6121_(), this.m_6100_());
            this.stopDiggingNoiseCooldown = 10;
        }
    }

    class MoveController
    extends MoveControl {
        public MoveController() {
            super((Mob)GumWormEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.f_24974_.m_20191_().m_82309_();
                float digSpeed = 0.25f;
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * (double)digSpeed / d0);
                boolean safeDig = GumWormEntity.isSafeDig((BlockGetter)GumWormEntity.this.m_9236_(), BlockPos.m_274561_((double)this.f_24975_, (double)Mth.m_14008_((double)this.f_24976_, (double)(this.f_24974_.m_20186_() - 1.0), (double)(this.f_24974_.m_20186_() + 1.0)), (double)this.f_24977_));
                if (GumWormEntity.isSafeDig((BlockGetter)GumWormEntity.this.m_9236_(), BlockPos.m_274561_((double)this.f_24975_, (double)this.f_24976_, (double)this.f_24977_))) {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vector3d1).m_82490_((double)0.9f));
                } else {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.1, 0.0).m_82490_((double)0.7f));
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_21573_().m_26573_();
                }
                if (d0 < width * (double)0.15f) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width && !GumWormEntity.this.isLeaping()) {
                    this.f_24974_.m_146922_(Mth.m_14148_((float)this.f_24974_.m_146908_(), (float)(-((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f), (float)25.0f));
                }
            }
        }
    }

    class Navigator
    extends FlyingPathNavigation {
        public Navigator(Mob mob, Level world) {
            super(mob, world);
        }

        public boolean m_6342_(BlockPos blockPos) {
            return !this.f_26495_.m_46859_(blockPos) && CorrodentEntity.isSafeDig((BlockGetter)this.f_26495_, blockPos);
        }

        protected PathFinder m_5532_(int i) {
            this.f_26508_ = new CorrodentEntity.DiggingNodeEvaluator();
            return new PathFinder(this.f_26508_, i);
        }

        protected double m_183345_(Vec3 vec3) {
            return vec3.f_82480_ + (double)this.f_26494_.m_20206_();
        }

        protected boolean m_7632_() {
            return true;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_();
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 <= (double)this.f_26505_;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.shouldTargetNextNodeInDirection(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        protected boolean m_183431_(Vec3 vec3, Vec3 vec31) {
            Vec3 vector3d = new Vec3(vec31.f_82479_, vec31.f_82480_ + (double)this.f_26494_.m_20206_() * 0.5, vec31.f_82481_);
            BlockHitResult result = this.f_26495_.m_45547_(new ClipContext(vec3, vector3d, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.f_26494_));
            return GumWormEntity.isSafeDig((BlockGetter)this.f_26495_, result.m_82425_());
        }

        private boolean shouldTargetNextNodeInDirection(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (this.f_26495_.m_8055_(this.f_26496_.m_77400_()).m_60795_()) {
                return true;
            }
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }
}

