/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.QuarryBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.QuarrySmasherEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class QuarryBlockEntity
extends BlockEntity {
    private static int FURTHEST_TORCH_DISTANCE = 20;
    private float previousRotation;
    private float rotation;
    private BlockPos bottomLeftTorch;
    private BlockPos bottomRightTorch;
    private BlockPos topLeftTorch;
    private BlockPos topRightTorch;
    private boolean hasMiningArea;
    private int checkTimer;
    public int spinFor;
    private AABB miningBox;
    private QuarrySmasherEntity serverSmasher = null;
    private BlockPos lastMineablePos;

    public QuarryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.QUARRY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, QuarryBlockEntity entity) {
        entity.previousRotation = entity.rotation;
        if (entity.checkTimer-- < 0) {
            entity.checkTimer = 20 + level.f_46441_.m_188503_(20);
            if (entity.searchForTorches(level, blockPos, (Direction)state.m_61143_((Property)QuarryBlock.FACING))) {
                entity.hasMiningArea = true;
                AABB aabb1 = new AABB(entity.bottomLeftTorch, entity.bottomRightTorch);
                AABB aabb2 = new AABB(entity.topLeftTorch, entity.topRightTorch);
                entity.miningBox = aabb1.m_82367_(aabb2);
                if (!level.f_46443_) {
                    entity.lastMineablePos = entity.findMinableBlock(level, blockPos.m_123342_() + 3).orElse(null);
                    if (entity.serverSmasher == null) {
                        QuarrySmasherEntity closest = null;
                        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
                        for (QuarrySmasherEntity quarrySmasher : level.m_45976_(QuarrySmasherEntity.class, entity.miningBox.m_82377_(0.0, 100.0, 0.0))) {
                            if (closest != null && !(quarrySmasher.m_20238_(center) < closest.m_20238_(center))) continue;
                            closest = quarrySmasher;
                        }
                        entity.serverSmasher = closest;
                    }
                }
            } else {
                entity.hasMiningArea = false;
            }
        }
        if (level.f_46443_) {
            entity.spawnLightningBetween(level, entity.bottomLeftTorch, entity.bottomRightTorch);
            entity.spawnLightningBetween(level, entity.bottomLeftTorch, entity.topLeftTorch);
            entity.spawnLightningBetween(level, entity.bottomRightTorch, entity.topRightTorch);
            entity.spawnLightningBetween(level, entity.topLeftTorch, entity.topRightTorch);
        } else if (entity.serverSmasher != null) {
            entity.serverSmasher.setQuarryPos(blockPos);
            if (entity.serverSmasher.m_213877_()) {
                entity.serverSmasher = null;
            } else if (entity.hasMiningArea && entity.lastMineablePos != null) {
                entity.serverSmasher.setInactive(false);
            } else {
                entity.serverSmasher.setInactive(true);
                entity.serverSmasher = null;
            }
        }
        if (entity.spinFor > 0) {
            --entity.spinFor;
            entity.rotation += (float)Math.min(10, entity.spinFor) * 0.1f;
        }
    }

    private boolean searchForTorches(Level level, BlockPos blockPos, Direction blockFacing) {
        int dist;
        BlockPos directlyBehind = blockPos.m_121945_(blockFacing.m_122424_());
        BlockPos.MutableBlockPos mutableTorchPos = directlyBehind.m_122032_();
        Direction leftTorchDir = blockFacing.m_122424_().m_122428_();
        Direction rightTorchDir = blockFacing.m_122424_().m_122427_();
        for (dist = 0; dist < FURTHEST_TORCH_DISTANCE && !QuarryBlockEntity.isMinable(level, (BlockPos)mutableTorchPos) && level.m_46749_((BlockPos)mutableTorchPos); ++dist) {
            mutableTorchPos.m_122173_(leftTorchDir);
        }
        if (!level.m_8055_((BlockPos)mutableTorchPos).m_60713_((Block)ACBlockRegistry.MAGNETIC_LIGHT.get())) {
            this.bottomLeftTorch = null;
            return false;
        }
        this.bottomLeftTorch = mutableTorchPos.m_7949_();
        mutableTorchPos.m_122190_((Vec3i)directlyBehind);
        mutableTorchPos.m_122173_(rightTorchDir);
        for (dist = 0; dist < FURTHEST_TORCH_DISTANCE && !QuarryBlockEntity.isMinable(level, (BlockPos)mutableTorchPos) && level.m_46749_((BlockPos)mutableTorchPos); ++dist) {
            mutableTorchPos.m_122173_(rightTorchDir);
        }
        if (!level.m_8055_((BlockPos)mutableTorchPos).m_60713_((Block)ACBlockRegistry.MAGNETIC_LIGHT.get())) {
            this.bottomRightTorch = null;
            return false;
        }
        this.bottomRightTorch = mutableTorchPos.m_7949_();
        mutableTorchPos.m_122190_((Vec3i)this.bottomLeftTorch);
        mutableTorchPos.m_122173_(blockFacing.m_122424_());
        for (dist = 0; dist < FURTHEST_TORCH_DISTANCE && !QuarryBlockEntity.isMinable(level, (BlockPos)mutableTorchPos) && level.m_46749_((BlockPos)mutableTorchPos); ++dist) {
            mutableTorchPos.m_122173_(blockFacing.m_122424_());
        }
        if (!level.m_8055_((BlockPos)mutableTorchPos).m_60713_((Block)ACBlockRegistry.MAGNETIC_LIGHT.get())) {
            this.topLeftTorch = null;
            return false;
        }
        this.topLeftTorch = mutableTorchPos.m_7949_();
        mutableTorchPos.m_122190_((Vec3i)this.bottomRightTorch);
        mutableTorchPos.m_122173_(blockFacing.m_122424_());
        for (dist = 0; dist < FURTHEST_TORCH_DISTANCE && !QuarryBlockEntity.isMinable(level, (BlockPos)mutableTorchPos) && level.m_46749_((BlockPos)mutableTorchPos); ++dist) {
            mutableTorchPos.m_122173_(blockFacing.m_122424_());
        }
        if (!level.m_8055_((BlockPos)mutableTorchPos).m_60713_((Block)ACBlockRegistry.MAGNETIC_LIGHT.get())) {
            this.topRightTorch = null;
            return false;
        }
        this.topRightTorch = mutableTorchPos.m_7949_();
        if (this.topRightTorch.m_123341_() - this.topLeftTorch.m_123341_() != 0 && this.topRightTorch.m_123343_() - this.topLeftTorch.m_123343_() != 0) {
            return false;
        }
        if (this.topRightTorch.m_123341_() - this.bottomRightTorch.m_123341_() != 0 && this.topRightTorch.m_123343_() - this.bottomRightTorch.m_123343_() != 0) {
            return false;
        }
        if (this.topLeftTorch.m_123341_() - this.bottomLeftTorch.m_123341_() != 0 && this.topLeftTorch.m_123343_() - this.bottomLeftTorch.m_123343_() != 0) {
            return false;
        }
        return this.bottomRightTorch.m_123341_() - this.bottomLeftTorch.m_123341_() == 0 || this.bottomRightTorch.m_123343_() - this.bottomLeftTorch.m_123343_() == 0;
    }

    private void spawnLightningBetween(Level level, BlockPos pos1, BlockPos pos2) {
        if (pos1 != null && pos2 != null && level.f_46441_.m_188503_(4) == 0) {
            Vec3 particleTo;
            Vec3 particleFrom;
            if (level.f_46441_.m_188499_()) {
                particleFrom = Vec3.m_82514_((Vec3i)pos1, (double)0.4f);
                particleTo = Vec3.m_82514_((Vec3i)pos2, (double)0.4f);
            } else {
                particleFrom = Vec3.m_82514_((Vec3i)pos2, (double)0.4f);
                particleTo = Vec3.m_82514_((Vec3i)pos1, (double)0.4f);
            }
            level.m_7106_((ParticleOptions)ACParticleRegistry.QUARRY_BORDER_LIGHTING.get(), particleFrom.f_82479_, particleFrom.f_82480_, particleFrom.f_82481_, particleTo.f_82479_, particleTo.f_82480_, particleTo.f_82481_);
        }
    }

    public Optional<BlockPos> findMinableBlock(Level level, double yStart) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPos highest = null;
        for (int x = (int)(this.miningBox.f_82288_ + 1.0); x < (int)this.miningBox.f_82291_; ++x) {
            for (int z = (int)(this.miningBox.f_82290_ + 1.0); z < (int)this.miningBox.f_82293_; ++z) {
                mutableBlockPos.m_122169_((double)x, yStart, (double)z);
                while (mutableBlockPos.m_123342_() > level.m_141937_() + 1 && !QuarryBlockEntity.isMinable(level, (BlockPos)mutableBlockPos)) {
                    mutableBlockPos.m_122184_(0, -1, 0);
                }
                if (!QuarryBlockEntity.isMinable(level, (BlockPos)mutableBlockPos) || highest != null && highest.m_123342_() >= mutableBlockPos.m_123342_()) continue;
                highest = mutableBlockPos.m_7949_();
            }
        }
        return Optional.ofNullable(highest);
    }

    public static boolean isMinable(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !state.m_204336_(ACTagRegistry.UNMOVEABLE) && !state.m_60795_() && !state.m_247087_() && state.m_60734_().m_155943_() >= 0.0f;
    }

    public AABB getMiningBox() {
        return this.miningBox;
    }

    public boolean hasMiningArea() {
        return this.hasMiningArea;
    }

    public float getGrindRotation(float partialTicks) {
        return this.previousRotation + (this.rotation - this.previousRotation) * partialTicks;
    }
}

