/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ThinBoneBlock;
import com.github.alexmodguy.alexscaves.server.item.PrimordialArmorItem;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DinosaurChopBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public final Map<BlockState, VoxelShape> shapeMap = new HashMap<BlockState, VoxelShape>();
    private final int foodAmount;
    private final float saturationAmount;

    public DinosaurChopBlock(int foodAmount, float saturationAmount) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_154653_).m_60955_().m_60988_().m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.foodAmount = foodAmount;
        this.saturationAmount = saturationAmount;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getChopShape(state);
    }

    protected VoxelShape getChopShape(BlockState state) {
        VoxelShape shape;
        if (this.shapeMap.containsKey(state)) {
            return this.shapeMap.get(state);
        }
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites == 0) {
            shape = Shapes.m_83144_();
        } else {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            VoxelShape merge = ThinBoneBlock.SHAPE_Y;
            switch (facing.m_122434_()) {
                case X: {
                    merge = ThinBoneBlock.SHAPE_X;
                    break;
                }
                case Y: {
                    merge = ThinBoneBlock.SHAPE_Y;
                    break;
                }
                case Z: {
                    merge = ThinBoneBlock.SHAPE_Z;
                }
            }
            shape = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)DinosaurChopBlock.calculateShapeForRotation(facing, bites), (BooleanOp)BooleanOp.f_82695_);
        }
        this.shapeMap.put(state, shape);
        return shape;
    }

    private static VoxelShape calculateShapeForRotation(Direction facing, int bites) {
        float minHeight = 4 * bites;
        float height = 16.0f - minHeight;
        switch (facing) {
            case UP: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
            }
            case DOWN: {
                return Block.m_49796_((double)0.0, (double)minHeight, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
            case NORTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)minHeight, (double)16.0, (double)16.0, (double)16.0);
            }
            case SOUTH: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)height);
            }
            case EAST: {
                return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)height, (double)16.0, (double)16.0);
            }
            case WEST: {
                return Block.m_49796_((double)minHeight, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            }
        }
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelaccessor = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{WATERLOGGED, BITES, FACING});
    }

    public PushReaction getPistonPushReaction(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (this.eat((LevelAccessor)level, blockPos, blockState, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eat((LevelAccessor)level, blockPos, blockState, player);
    }

    protected InteractionResult eat(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        int extraShanksFromArmor = this == ACBlockRegistry.DINOSAUR_CHOP.get() ? PrimordialArmorItem.getExtraSaturationFromArmor((LivingEntity)player) : 0;
        player.m_36324_().m_38707_(this.foodAmount + extraShanksFromArmor, this.saturationAmount + (float)extraShanksFromArmor * 0.125f);
        int i = (Integer)blockState.m_61143_((Property)BITES);
        levelAccessor.m_142346_((Entity)player, GameEvent.f_157806_, blockPos);
        if (i < 3) {
            levelAccessor.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            levelAccessor.m_7471_(blockPos, false);
            levelAccessor.m_7731_(blockPos, (BlockState)((Block)ACBlockRegistry.THIN_BONE.get()).m_49966_().m_61124_((Property)ThinBoneBlock.f_55923_, (Comparable)((Direction)blockState.m_61143_((Property)FACING)).m_122434_()), 4);
            levelAccessor.m_142346_((Entity)player, GameEvent.f_157794_, blockPos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213898_(BlockState currentState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188503_(4) == 0 && this == ACBlockRegistry.DINOSAUR_CHOP.get() && this.isFireBelow((Level)level, blockPos.m_7495_())) {
            BlockState blockstate1 = (BlockState)((BlockState)((Block)ACBlockRegistry.COOKED_DINOSAUR_CHOP.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)currentState.m_61143_((Property)FACING)))).m_61124_((Property)BITES, (Comparable)((Integer)currentState.m_61143_((Property)BITES)));
            level.m_46597_(blockPos, blockstate1);
        }
    }

    private boolean isFireBelow(Level level, BlockPos pos) {
        while (level.m_8055_(pos).m_60795_() && pos.m_123342_() > level.m_141937_()) {
            pos = pos.m_7495_();
        }
        BlockState fireState = level.m_8055_(pos);
        return fireState.m_204336_(ACTagRegistry.COOKS_MEAT_BLOCKS);
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return DinosaurChopBlock.getOutputSignal((Integer)blockState.m_61143_((Property)BITES));
    }

    public static int getOutputSignal(int i) {
        return (7 - i) * 2;
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState blockState, Fluid fluid) {
        return (Integer)blockState.m_61143_((Property)BITES) != 0 && fluid == Fluids.f_76193_;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.m_61143_((Property)BITES) != 0 && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            levelAccessor.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            if (!blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
                levelAccessor.m_46961_(blockPos, true);
            }
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }
}

